/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.schedulers;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.service.CookieService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CookiesCleaner {
    private static final Logger log = LoggerFactory.getLogger(CookiesCleaner.class);
    private final CookieService cookieService;
    private final LockManager lockManager;

    @Scheduled(cron="${atp.itf.lite.clean.cookie.cron.expression}")
    public void cookiesCleanUpJob() {
        this.lockManager.executeWithLock("cleanupCookies", this::cleanupCookies);
    }

    private void cleanupCookies() {
        log.info("Start cookies cleanup");
        this.cookieService.deleteIfErIdOrTrIdSpecified();
        List<Cookie> cookies = this.cookieService.getAll();
        ArrayList<UUID> cookiesToDelete = new ArrayList<UUID>();
        cookies.forEach(cookie -> {
            List<HttpCookie> parsedCookies = HttpCookie.parse(cookie.getValue());
            for (HttpCookie parsedCookie : parsedCookies) {
                if (!parsedCookie.hasExpired()) continue;
                cookiesToDelete.add(cookie.getId());
                break;
            }
        });
        this.cookieService.deleteAllByIdIn(cookiesToDelete);
        log.info("Finish cookies cleanup");
    }

    public CookiesCleaner(CookieService cookieService, LockManager lockManager) {
        this.cookieService = cookieService;
        this.lockManager = lockManager;
    }
}

