/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.schedulers;

import org.qubership.atp.itf.lite.backend.service.history.iface.DeleteHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class HistoryOldRevisionsCleaner {
    private static final Logger log = LoggerFactory.getLogger(HistoryOldRevisionsCleaner.class);
    private static final String UTC_TIMEZONE = "UTC";
    private final DeleteHistoryService deleteHistoryService;
    @Value(value="${atp.itf.lite.history.clean.job.revision.max.count}")
    private long maxRevisionCount;
    @Value(value="${atp.itf.lite.history.clean.job.page-size}")
    private Integer pageSize;

    @Scheduled(cron="${atp.itf.lite.history.clean.job.expression}", zone="UTC")
    public void run() {
        this.deleteHistoryService.deleteTerminatedSnapshots(this.pageSize);
        this.deleteHistoryService.deleteOldSnapshots(this.maxRevisionCount);
    }

    public HistoryOldRevisionsCleaner(DeleteHistoryService deleteHistoryService) {
        this.deleteHistoryService = deleteHistoryService;
    }
}

