/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.schedulers;

import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.itf.lite.backend.service.RequestExecutionHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class RequestExecutionHistoryCleanup {
    private static final Logger log = LoggerFactory.getLogger(RequestExecutionHistoryCleanup.class);
    @Value(value="${history.retention.in.days}")
    private int historyRetentionInDays;
    private final LockManager lockManager;
    private final RequestExecutionHistoryService requestExecutionHistoryService;

    public RequestExecutionHistoryCleanup(LockManager lockManager, RequestExecutionHistoryService requestExecutionHistoryService) {
        this.lockManager = lockManager;
        this.requestExecutionHistoryService = requestExecutionHistoryService;
    }

    @Scheduled(cron="${history.retention.cron.expression}")
    public void cleanUpRequestExecutionHistoryWithLockManager() {
        this.lockManager.executeWithLock("cleanUpRequestExecutionHistory", this::cleanUpRequestExecutionHistory);
    }

    public void cleanUpRequestExecutionHistory() {
        log.info("Start cleanUp of request execution history");
        log.info("CleanUp of request execution history {} records got deleted.", (Object)this.requestExecutionHistoryService.cleanUpRequestExecutionHistory(this.historyRetentionInDays));
        log.info("Finish cleanUp of request execution history");
    }
}

