/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.qubership.atp.itf.lite.backend.exceptions.access.ItfLiteFileSecurityAccessException;
import org.qubership.atp.itf.lite.backend.exceptions.file.ItfLiteFileCreationException;
import org.qubership.atp.itf.lite.backend.exceptions.internal.ItfLiteCatalogFileDownloadException;
import org.qubership.atp.itf.lite.backend.exceptions.internal.ItfLiteIllegalFileInfoDownloadArgumentsException;
import org.qubership.atp.itf.lite.backend.feign.dto.CertificateDto;
import org.qubership.atp.itf.lite.backend.feign.dto.FileInfoDto;
import org.qubership.atp.itf.lite.backend.feign.service.CatalogueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CertificateService {
    private static final Logger log = LoggerFactory.getLogger(CertificateService.class);
    public static final String CERTIFICATE_FOLDER = "ProjectCertificates" + File.separator + "%s" + File.separator;
    private final CatalogueService catalogueFeignService;

    public CertificateService(CatalogueService catalogueFeignService) {
        this.catalogueFeignService = catalogueFeignService;
    }

    public CertificateDto getCertificate(UUID projectId) {
        ResponseEntity<CertificateDto> certificateDtoResponseEntity = this.catalogueFeignService.getCertificate(projectId);
        if (certificateDtoResponseEntity != null) {
            return (CertificateDto)certificateDtoResponseEntity.getBody();
        }
        return new CertificateDto();
    }

    public File getCertificateVerificationFile(UUID projectId) {
        FileInfoDto trustStoreFileInfo = this.getCertificate(projectId).getTrustStoreFileInfo();
        return this.getFileOrDownload(projectId, trustStoreFileInfo);
    }

    public File getClientCertificateFile(UUID projectId) {
        FileInfoDto keyStoreFileInfo = this.getCertificate(projectId).getKeyStoreFileInfo();
        return this.getFileOrDownload(projectId, keyStoreFileInfo);
    }

    private File getFileOrDownload(UUID projectId, FileInfoDto fileInfo) {
        File certFile;
        block13: {
            if (fileInfo == null || fileInfo.getName() == null || fileInfo.getId() == null) {
                log.error("Found illegal downloaded file info data: {}", (Object)fileInfo);
                throw new ItfLiteIllegalFileInfoDownloadArgumentsException();
            }
            Path rootDir = Paths.get(String.format(CERTIFICATE_FOLDER, projectId), new String[0]).toAbsolutePath().normalize();
            try {
                Files.createDirectories(rootDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Cannot create certificate folder", (Throwable)e);
                throw new ItfLiteFileCreationException("Cannot create certificate folder");
            }
            String sanitizedFileName = Paths.get(fileInfo.getName(), new String[0]).getFileName().toString();
            sanitizedFileName = org.qubership.atp.itf.lite.backend.utils.FileUtils.sanitizeFileName(sanitizedFileName);
            Path certPath = rootDir.resolve(sanitizedFileName).normalize();
            if (!certPath.startsWith(rootDir)) {
                log.error("Detected path traversal attempt: {}", (Object)sanitizedFileName);
                throw new ItfLiteFileSecurityAccessException("Detected path traversal attempt: " + sanitizedFileName);
            }
            certFile = certPath.toFile();
            if (!certFile.exists()) {
                log.info("Certificate file '{}' not present on pod storage, load from catalogue", (Object)sanitizedFileName);
                String fileId = fileInfo.getId();
                try (InputStream stream = ((Resource)this.catalogueFeignService.downloadFile(fileId).getBody()).getInputStream();){
                    FileUtils.copyInputStreamToFile((InputStream)stream, (File)certFile);
                    break block13;
                }
                catch (Exception e) {
                    log.error("Failed to download file from catalogue. Project: '{}', file id: '{}'", new Object[]{projectId, fileId, e});
                    throw new ItfLiteCatalogFileDownloadException();
                }
            }
            log.info("Certificate file '{}' present on pod storage", (Object)sanitizedFileName);
        }
        return certFile;
    }
}

