/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.sql.Timestamp;
import java.util.Calendar;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CollectionRunNextRequestRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CollectionRunRequestsCountRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CollectionRunRequestsRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.CollectionRunStackRequestsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CollectionRunService {
    private static final Logger log = LoggerFactory.getLogger(CollectionRunService.class);
    private final CollectionRunNextRequestRepository collectionRunNextRequestRepository;
    private final CollectionRunRequestsCountRepository collectionRunRequestsCountRepository;
    private final CollectionRunRequestsRepository collectionRunRequestsRepository;
    private final CollectionRunStackRequestsRepository collectionRunStackRequestsRepository;

    @Transactional
    public void cleanUpRequestExecutionHistory(int collectionRunsRemoveDays) {
        Calendar calendar = Calendar.getInstance();
        int minusDays = collectionRunsRemoveDays > 0 ? collectionRunsRemoveDays * -1 : collectionRunsRemoveDays;
        calendar.add(5, minusDays);
        Timestamp expirationTimestamp = new Timestamp(calendar.getTimeInMillis());
        log.info("[clean_up] COLLECTION_RUN_NEXT_REQUEST {} records got deleted.", (Object)this.collectionRunNextRequestRepository.deleteByCreatedWhenBefore(expirationTimestamp));
        log.info("[clean_up] COLLECTION_RUN_REQUESTS_COUNT {} records got deleted.", (Object)this.collectionRunRequestsCountRepository.deleteByCreatedWhenBefore(expirationTimestamp));
        log.info("[clean_up] COLLECTION_RUN_REQUESTS_ORDER {} records got deleted.", (Object)this.collectionRunRequestsRepository.deleteByCreatedWhenBefore(expirationTimestamp));
        log.info("[clean_up] COLLECTION_RUN_STACK_REQUESTS_ORDER {} records got deleted.", (Object)this.collectionRunStackRequestsRepository.deleteByCreatedWhenBefore(expirationTimestamp));
    }

    public CollectionRunService(CollectionRunNextRequestRepository collectionRunNextRequestRepository, CollectionRunRequestsCountRepository collectionRunRequestsCountRepository, CollectionRunRequestsRepository collectionRunRequestsRepository, CollectionRunStackRequestsRepository collectionRunStackRequestsRepository) {
        this.collectionRunNextRequestRepository = collectionRunNextRequestRepository;
        this.collectionRunRequestsCountRepository = collectionRunRequestsCountRepository;
        this.collectionRunRequestsRepository = collectionRunRequestsRepository;
        this.collectionRunStackRequestsRepository = collectionRunStackRequestsRepository;
    }
}

