/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.auth.springbootstarter.utils.ReflectionUtils;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractEntity;
import org.qubership.atp.itf.lite.backend.service.IdentifiedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.JpaRepository;

public abstract class CrudService<T extends AbstractEntity>
implements IdentifiedService {
    private static final Logger log = LoggerFactory.getLogger(CrudService.class);

    protected abstract JpaRepository<T, UUID> repository();

    public <E> boolean isEntityExists(E entity) {
        return this.repository().existsById((Object)((UUID)entity));
    }

    public T get(UUID id) {
        return (T)((AbstractEntity)this.repository().findById((Object)id).orElseThrow(() -> {
            String entityName = ReflectionUtils.getGenericClassSimpleName((Object)this);
            log.error("Failed to found {} entity with id: {}", (Object)entityName, (Object)id);
            return new AtpEntityNotFoundException(entityName, (Object)id);
        }));
    }

    public T save(T entity) {
        return (T)((AbstractEntity)this.repository().save(entity));
    }

    public List<T> getAll() {
        return this.repository().findAll();
    }

    public List<T> saveAll(List<T> entities) {
        return this.repository().saveAll(entities);
    }

    public void delete(T entity) {
        this.repository().delete(entity);
    }

    public void deleteByEntities(Iterable<T> entities) {
        this.repository().deleteAll(entities);
    }
}

