/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.codehaus.commons.compiler.util.Producer;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestEnvironmentNotSpecifiedException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestEnvironmentVariableNotFoundException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestHeaderDecryptException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestParamDecryptException;
import org.qubership.atp.itf.lite.backend.feign.service.EnvironmentFeignService;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.BearerAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.OAuth2AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpParamSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.environments.Connection;
import org.qubership.atp.itf.lite.backend.model.api.response.environments.System;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnvironmentVariableService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentVariableService.class);
    private final String envVariableWithoutSpecialChars = "envVariableWithoutSpecialChars";
    private final Pattern envVariablesSearchPattern = Pattern.compile("(\\$\\{(?i)ENV\\.(?<envVariableWithoutSpecialChars>[^}]+)\\})");
    private final String encryptedEnvParameterPrefix = "EncryptedParameterENV";
    private final Pattern envEncryptedVariablesSearchPattern = Pattern.compile("(\\{(?i)EncryptedParameterENV\\.(?<envVariableWithoutSpecialChars>[^}]+)\\})");
    private final String envName = "envName";
    private final Pattern encodedEnvVariableSearchPattern = Pattern.compile("(%24%7B(?<envName>[^%7D]+)%7D)");
    private final EnvironmentFeignService environmentFeignService;
    private final EncryptionService encryptionService;

    public void resolveEnvironmentParameters(OAuth2AuthorizationSaveRequest request, UUID environmentId) throws AtpDecryptException {
        log.debug("Resolve environment parameters in OAuth2 authorization request, environment id: {}", (Object)environmentId);
        HashMap<Producer<String>, Consumer<String>> resolveMap = new HashMap<Producer<String>, Consumer<String>>();
        resolveMap.put(request::getUrl, request::setUrl);
        resolveMap.put(request::getClientId, request::setClientId);
        resolveMap.put(request::getClientSecret, request::setClientSecret);
        resolveMap.put(request::getUsername, request::setUsername);
        resolveMap.put(request::getPassword, request::setPassword);
        resolveMap.put(request::getScope, request::setScope);
        List<String> resolvableFields = Stream.of(request.getUrl(), request.getClientId(), request.getClientSecret(), request.getUsername(), request.getPassword(), request.getScope()).filter(Objects::nonNull).collect(Collectors.toList());
        this.resolveEnvironmentParameters(resolvableFields, resolveMap, environmentId);
    }

    public void resolveEnvironmentParameters(BearerAuthorizationSaveRequest request, UUID environmentId) throws AtpDecryptException {
        log.debug("Resolve environment parameters in OAuth2 authorization request, environment id: {}", (Object)environmentId);
        List<String> resolvableFields = Stream.of(request.getToken()).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<Producer<String>, Consumer<String>> resolveMap = new HashMap<Producer<String>, Consumer<String>>();
        resolveMap.put(request::getToken, request::setToken);
        this.resolveEnvironmentParameters(resolvableFields, resolveMap, environmentId);
    }

    public void resolveEnvironmentParameters(List<String> resolvableFields, Map<Producer<String>, Consumer<String>> resolveMap, UUID environmentId) throws AtpDecryptException {
        log.debug("Resolve environment parameters in OAuth2 authorization request, environment id: {}", (Object)environmentId);
        if (this.isEnvironmentVariablesPresent(resolvableFields)) {
            log.debug("Found environment parameters");
            if (Objects.isNull(environmentId)) {
                log.error("The environment has not been specified for the request");
                throw new ItfLiteRequestEnvironmentNotSpecifiedException();
            }
            List<System> systems = this.environmentFeignService.getEnvironmentSystems(environmentId);
            ArrayList<String> notFoundVariables = new ArrayList<String>();
            for (Map.Entry<Producer<String>, Consumer<String>> entry : resolveMap.entrySet()) {
                this.resolveParameter(entry.getKey(), entry.getValue(), systems, notFoundVariables);
            }
            this.checkNotFoundVariables(notFoundVariables);
        }
    }

    public void resolveEnvironmentParameters(HttpRequestEntitySaveRequest httpRequest, boolean onlyEncrypted, UUID environmentId) throws AtpDecryptException {
        RequestBody requestBody;
        List<HttpHeaderSaveRequest> requestHeaders;
        UUID requestId = httpRequest.getId();
        log.debug("Resolve values for request id = {}", (Object)requestId);
        if (this.isEnvironmentVariablesPresent(httpRequest) && !onlyEncrypted) {
            log.debug("Environment variables are not found in request");
            return;
        }
        if (this.isEncryptedEnvironmentVariablesPresent(httpRequest) && onlyEncrypted) {
            log.debug("Encrypted environment variables are not found in request");
            return;
        }
        if (environmentId == null) {
            log.error("The environment has not been specified for the request '{}'", (Object)requestId);
            throw new ItfLiteRequestEnvironmentNotSpecifiedException();
        }
        log.debug("Get list of systems for environment id = {}", (Object)environmentId);
        List<System> systems = this.environmentFeignService.getEnvironmentSystems(environmentId);
        ArrayList<String> notFoundVariables = new ArrayList<String>();
        String url = httpRequest.getUrl();
        url = this.resolveParameter(url, systems, notFoundVariables, onlyEncrypted);
        httpRequest.setUrl(url);
        List<HttpParamSaveRequest> requestParameters = httpRequest.getRequestParams();
        if (!CollectionUtils.isEmpty(requestParameters)) {
            requestParameters.forEach(parameter -> {
                String key = parameter.getKey();
                String value = parameter.getValue();
                try {
                    String updatedParameterValue = this.resolveParameter(value, systems, notFoundVariables, onlyEncrypted);
                    parameter.setValue(updatedParameterValue);
                }
                catch (AtpDecryptException e) {
                    log.error("Failed to decrypt request parameter '{}' with value: '{}'", new Object[]{key, value, e});
                    throw new ItfLiteRequestParamDecryptException(key, value);
                }
            });
        }
        if (!CollectionUtils.isEmpty(requestHeaders = httpRequest.getRequestHeaders())) {
            requestHeaders.forEach(header -> {
                String key = header.getKey();
                String value = header.getValue();
                try {
                    String updatedHeaderValue = this.resolveParameter(value, systems, notFoundVariables, onlyEncrypted);
                    header.setValue(updatedHeaderValue);
                }
                catch (AtpDecryptException e) {
                    log.error("Failed to decrypt request parameter '{}' with value: '{}'", new Object[]{key, value, e});
                    throw new ItfLiteRequestHeaderDecryptException(key, value);
                }
            });
        }
        if ((requestBody = httpRequest.getBody()) != null) {
            String updatedContent = this.resolveParameter(requestBody.getContent(), systems, notFoundVariables, onlyEncrypted);
            requestBody.setContent(updatedContent);
        }
        this.checkNotFoundVariables(notFoundVariables);
    }

    public List<System> getEnvironmentSystemsById(UUID environmentId) {
        return this.environmentFeignService.getEnvironmentSystems(environmentId);
    }

    public boolean isEnvironmentVariablesPresent(Collection<String> params) {
        return params.stream().anyMatch(field -> {
            Matcher envMatcher = this.envVariablesSearchPattern.matcher((CharSequence)field);
            return envMatcher.find();
        });
    }

    public boolean isEnvironmentVariablesPresent(HttpRequestEntitySaveRequest httpRequest) {
        List<String> requestFields = this.prepareRequestFields(httpRequest);
        return requestFields.stream().noneMatch(field -> {
            Matcher envMatcher = this.envVariablesSearchPattern.matcher((CharSequence)field);
            return envMatcher.find();
        });
    }

    public boolean isEncryptedEnvironmentVariablesPresent(HttpRequestEntitySaveRequest httpRequest) {
        List<String> requestFields = this.prepareRequestFields(httpRequest);
        return requestFields.stream().noneMatch(field -> {
            Matcher envMatcher = this.envEncryptedVariablesSearchPattern.matcher((CharSequence)field);
            return envMatcher.find();
        });
    }

    private List<String> prepareRequestFields(HttpRequestEntitySaveRequest httpRequest) {
        RequestBody requestBody;
        List<HttpHeaderSaveRequest> requestHeaders;
        List<HttpParamSaveRequest> requestParameters;
        ArrayList<String> requestFields = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)httpRequest.getUrl())) {
            requestFields.add(httpRequest.getUrl());
        }
        if (!CollectionUtils.isEmpty(requestParameters = httpRequest.getRequestParams())) {
            requestParameters.forEach(parameter -> requestFields.add(parameter.getValue()));
        }
        if (!CollectionUtils.isEmpty(requestHeaders = httpRequest.getRequestHeaders())) {
            requestHeaders.forEach(header -> requestFields.add(header.getValue()));
        }
        if ((requestBody = httpRequest.getBody()) != null && Objects.nonNull(requestBody.getContent())) {
            requestFields.add(requestBody.getContent());
        }
        return requestFields;
    }

    private String resolveParameter(String paramValue, List<System> systems, List<String> notFoundVariables, boolean onlyEncrypted) throws AtpDecryptException {
        Matcher envMatcher = onlyEncrypted ? this.envEncryptedVariablesSearchPattern.matcher(paramValue) : this.envVariablesSearchPattern.matcher(paramValue);
        String stringWithValues = paramValue;
        while (envMatcher.find()) {
            String variableFullName = envMatcher.group("envVariableWithoutSpecialChars");
            log.debug("Found environment variable {}", (Object)variableFullName);
            String varEnvironmentValue = this.getEnvironmentValueByVariableFullName(variableFullName, systems);
            if (varEnvironmentValue != null) {
                if (onlyEncrypted) {
                    varEnvironmentValue = this.encryptionService.decryptIfEncrypted(varEnvironmentValue);
                    stringWithValues = envMatcher.replaceFirst(varEnvironmentValue);
                } else {
                    stringWithValues = !this.encryptionService.isEncrypted(varEnvironmentValue) ? envMatcher.replaceFirst(varEnvironmentValue) : envMatcher.replaceFirst("{EncryptedParameterENV." + variableFullName + "}");
                }
            } else {
                notFoundVariables.add(variableFullName);
                stringWithValues = envMatcher.replaceFirst("{valueForEnvironmentVariableNotFound}");
            }
            envMatcher.reset(stringWithValues);
        }
        log.debug("Environment variables resolve is finished");
        return stringWithValues;
    }

    private void resolveParameter(Producer<String> getter, Consumer<String> setter, List<System> systems, List<String> notFoundVariables) throws AtpDecryptException {
        String paramValue = (String)getter.produce();
        if (Objects.nonNull(paramValue)) {
            paramValue = this.resolveParameter(paramValue, systems, notFoundVariables, false);
            paramValue = this.resolveParameter(paramValue, systems, notFoundVariables, true);
            setter.accept(paramValue);
        }
    }

    private void checkNotFoundVariables(List<String> notFoundVariables) {
        if (!CollectionUtils.isEmpty(notFoundVariables)) {
            StringJoiner stringJoiner = new StringJoiner("\n");
            notFoundVariables.forEach(stringJoiner::add);
            String variables = stringJoiner.toString();
            log.error("The environment variables aren't found: {}", (Object)variables);
            throw new ItfLiteRequestEnvironmentVariableNotFoundException(variables);
        }
    }

    private String getEnvironmentValueByVariableFullName(String variableFullName, List<System> environmentSystems) {
        String tempVariable = String.copyValueOf(variableFullName.toCharArray()).toLowerCase();
        String systemName = this.getVariablePart(tempVariable);
        List filteredSystems = environmentSystems.stream().filter(system -> system.getName().equalsIgnoreCase(systemName)).collect(Collectors.toList());
        if (!filteredSystems.isEmpty()) {
            log.debug("Filtered systems: {}", filteredSystems);
            tempVariable = this.getVariableWithoutStartPart(tempVariable, systemName);
            String connectionName = this.getVariablePart(tempVariable);
            System system2 = (System)filteredSystems.get(0);
            log.debug("Filter connections for system: {}", (Object)system2.getId());
            List filteredConnections = system2.getConnections().stream().filter(connection -> connection.getName().equalsIgnoreCase(connectionName)).collect(Collectors.toList());
            if (!filteredConnections.isEmpty()) {
                log.debug("Filtered connections: {}", filteredConnections);
                tempVariable = StringUtils.strip((String)this.getVariableWithoutStartPart(tempVariable, connectionName), (String)".\"");
                if (((Connection)filteredConnections.get(0)).getParameters().containsKey((Object)tempVariable)) {
                    String value = (String)((Connection)filteredConnections.get(0)).getParameters().get((Object)tempVariable);
                    log.debug("Found variable value: {} = {}", (Object)variableFullName, (Object)value);
                    return value;
                }
            }
        }
        log.error("Environment variable {} not found", (Object)variableFullName);
        return null;
    }

    private String getVariablePart(String variable) {
        if (variable.startsWith("\"")) {
            return StringUtils.substringBetween((String)variable, (String)"\"", (String)"\"");
        }
        return StringUtils.substringBefore((String)variable, (String)".");
    }

    private String getVariableWithoutStartPart(String variable, String part) {
        if (variable.startsWith("\"")) {
            return StringUtils.stripStart((String)variable.replaceFirst("\"" + part + "\"", ""), (String)".");
        }
        return StringUtils.stripStart((String)variable.replaceFirst(part, ""), (String)".");
    }

    public String encodeParameterExceptEnv(String parameter) throws UnsupportedEncodingException {
        String encodedParameter = URLEncoder.encode(parameter, StandardCharsets.UTF_8.name());
        Matcher encodedEnvMatcher = this.encodedEnvVariableSearchPattern.matcher(encodedParameter);
        while (encodedEnvMatcher.find()) {
            String name = encodedEnvMatcher.group("envName");
            encodedParameter = encodedEnvMatcher.replaceFirst("\\$\\{" + name + "\\}");
            encodedEnvMatcher.reset(encodedParameter);
        }
        log.debug("parameter encoded {} -> {}", (Object)parameter, (Object)encodedParameter);
        return encodedParameter;
    }

    public EnvironmentVariableService(EnvironmentFeignService environmentFeignService, EncryptionService encryptionService) {
        this.environmentFeignService = environmentFeignService;
        this.encryptionService = encryptionService;
    }
}

