/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.modelmapper.ModelMapper;
import org.qubership.atp.auth.springbootstarter.entities.Operation;
import org.qubership.atp.auth.springbootstarter.entities.Operations;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.auth.springbootstarter.security.permissions.PolicyEnforcement;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.FolderRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestRepository;
import org.qubership.atp.itf.lite.backend.enums.EntityType;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.exceptions.access.ItfLiteAccessDeniedException;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderCopyRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderDeleteRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderEditRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderMoveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderOrderChangeRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderTreeSearchRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderUpsetRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.IdWithModifiedWhen;
import org.qubership.atp.itf.lite.backend.model.api.request.Permissions;
import org.qubership.atp.itf.lite.backend.model.api.request.Settings;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.GroupResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.ParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractNamedEntity;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.PermissionEntity;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.auth.InheritFromParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.converters.ListConverter;
import org.qubership.atp.itf.lite.backend.model.entities.converters.PermissionEntityConverter;
import org.qubership.atp.itf.lite.backend.service.CrudService;
import org.qubership.atp.itf.lite.backend.service.FolderSpecificationService;
import org.qubership.atp.itf.lite.backend.service.RequestAuthorizationService;
import org.qubership.atp.itf.lite.backend.service.history.iface.DeleteHistoryService;
import org.qubership.atp.itf.lite.backend.service.history.iface.EntityHistoryService;
import org.qubership.atp.itf.lite.backend.utils.RequestUtils;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.qubership.atp.itf.lite.backend.utils.UserManagementEntities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FolderService
extends CrudService<Folder>
implements EntityHistoryService {
    private static final Logger log = LoggerFactory.getLogger(FolderService.class);
    private final FolderRepository folderRepository;
    private final RequestRepository requestRepository;
    private final ModelMapper modelMapper;
    private final UsersService usersService;
    private final PolicyEnforcement policyEnforcement;
    private final Provider<UserInfo> userInfoProvider;
    private final RequestAuthorizationService requestAuthorizationService;
    private final FolderSpecificationService folderSpecificationService;
    private final DeleteHistoryService deleteHistoryService;
    private final PermissionEntityConverter permissionEntityConverter;
    private final ListConverter listConverter;

    @Override
    protected JpaRepository<Folder, UUID> repository() {
        return this.folderRepository;
    }

    @Override
    public Folder save(Folder folder) {
        Folder savedFolder = Objects.isNull(folder.getId()) ? super.save(folder) : this.updateFolderChildren(folder);
        this.updateParentFolderChildren(folder);
        return savedFolder;
    }

    @Override
    public List<Folder> saveAll(List<Folder> folders) {
        List<Folder> savedFolders = this.updateFoldersChildren(folders);
        this.updateParentFolderChildren(folders);
        return savedFolders;
    }

    public Folder getFolder(UUID folderId) {
        log.info("Find folder by id {}", (Object)folderId);
        return (Folder)this.get(folderId);
    }

    public Settings getSettings(UUID folderId) {
        log.info("Get folder settings by id {}", (Object)folderId);
        return (Settings)this.modelMapper.map(this.get(folderId), Settings.class);
    }

    public Set<UUID> getPermissionFolderIdsByFolderIds(Set<UUID> folderIds) {
        return this.folderRepository.findAllByIdIn(folderIds).stream().map(Folder::getPermissionFolderId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public List<Folder> getFolderByIdAndName(UUID folderId, String folderName) {
        return this.folderRepository.findAllByIdAndName(folderId, folderName);
    }

    public List<Folder> getFoldersByIds(Set<UUID> folderIds) {
        return this.folderRepository.findAllById(folderIds);
    }

    public Collection<Folder> getAllFolders(UUID projectId) {
        log.info("Find all folders, filters: [projectId: {}]", (Object)projectId);
        if (Objects.nonNull(projectId)) {
            return this.folderRepository.findAllByProjectIdOrderByOrder(projectId);
        }
        return this.getAll();
    }

    public List<Folder> getAllByProjectIdAndParentId(UUID projectId, UUID parentFolderId) {
        log.info("Find all folders, filters: [projectId: {}, parentFolderId: {}]", (Object)projectId, (Object)parentFolderId);
        Specification folderSpecification = Specification.where(this.folderSpecificationService.generateSpecificationToFilterFoldersByProjectIdAndParentFolderId(projectId, parentFolderId));
        return this.folderRepository.findAll(folderSpecification);
    }

    public GroupResponse getFolderRequestsTree(Boolean onlyFolders, FolderTreeSearchRequest request) {
        UUID projectId = request.getProjectId();
        UUID parentId = request.getParentId();
        String search = request.getSearch();
        log.info("Get folders and requests tree by project '{}', parent id '{}' and search contains '{}'", new Object[]{projectId, parentId, search});
        boolean isSearchEmpty = StringUtils.isEmpty((Object)search);
        List<Object> requests = onlyFolders == false ? this.requestRepository.findAllByProjectId(projectId) : new ArrayList();
        List<Folder> projectFolders = this.folderRepository.findAllByProjectId(projectId);
        List<Folder> projectTopFolders = StreamUtils.filterList(projectFolders, folder -> Objects.isNull(folder.getParentId()));
        Map servicePermissions = this.usersService.getObjectPermissionsForService(request.getProjectId());
        List<GroupResponse> topLevelEntities = projectTopFolders.stream().map(rootFolder -> this.getFolderGroupResponse((Folder)rootFolder, new GroupResponse((Folder)rootFolder, null), projectFolders, (List<Request>)requests, search, servicePermissions)).filter(rootFolder -> !rootFolder.isFilteredOut()).collect(Collectors.toList());
        if (!isSearchEmpty) {
            topLevelEntities = topLevelEntities.stream().filter(folder -> !CollectionUtils.isEmpty(folder.getChildren()) || clover.org.apache.commons.lang.StringUtils.containsIgnoreCase((String)folder.getName(), (String)search)).collect(Collectors.toList());
        }
        List topLevelRequests = StreamUtils.filterList(requests, req -> Objects.isNull(req.getFolderId())).stream().filter(topLevelRequest -> Objects.isNull(search) || clover.org.apache.commons.lang.StringUtils.containsIgnoreCase((String)topLevelRequest.getName(), (String)search)).map(r -> {
            GroupResponse gr = new GroupResponse((Request)r, null);
            gr.setHasWritePermissions(true);
            return gr;
        }).collect(Collectors.toList());
        topLevelEntities.addAll(topLevelRequests);
        GroupResponse response = new GroupResponse();
        response.setChildren(topLevelEntities);
        this.sortFolderRequestTree(response);
        return response;
    }

    public GroupResponse getRequestTreeByParentFolderId(UUID parentFolderId) {
        Folder parentFolder = this.getFolder(parentFolderId);
        List<Request> projectRequests = this.requestRepository.findAllByProjectId(parentFolder.getProjectId());
        List<Folder> projectFolders = this.folderRepository.findAllByProjectId(parentFolder.getProjectId());
        GroupResponse response = this.getFolderGroupResponse(parentFolder, new GroupResponse(parentFolder, null), projectFolders, projectRequests, null, null);
        this.sortFolderRequestTree(response);
        return response;
    }

    public AbstractNamedEntity restore(AbstractNamedEntity entity) {
        try {
            Folder folder = (Folder)entity;
            log.info("Restore folder to version {}", (Object)folder);
            PermissionEntity permission = this.permissionEntityConverter.convertToEntityAttribute(folder.getPermission());
            FolderEditRequest folderUpsetRequest = new FolderEditRequest(folder.getName(), folder.getProjectId(), folder.getParentId(), permission == null ? null : new Permissions(permission));
            return this.editFolder(folder.getId(), folderUpsetRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<GroupResponse> getChildFolders(GroupResponse root) {
        return root.getChildren().stream().filter(child -> child.getType().equals((Object)EntityType.FOLDER)).collect(Collectors.toList());
    }

    private void sortFolderRequestTree(GroupResponse tree) {
        List<GroupResponse> children = tree.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            Collections.sort(children);
            children.forEach(this::sortFolderRequestTree);
        }
    }

    private GroupResponse getFolderGroupResponse(Folder rootFolder, GroupResponse response, List<Folder> folders, List<Request> requests, String search, Map<String, Map<UUID, Operations>> servicePermissions) {
        boolean hasWritePermissions;
        UUID rootFolderId = rootFolder.getId();
        UUID permissionFolderId = rootFolder.getPermissionFolderId();
        Permissions perms = new Permissions();
        if (Objects.nonNull(permissionFolderId) && !CollectionUtils.isEmpty(servicePermissions)) {
            Map<UUID, Operations> objectPermissions = servicePermissions.get(this.usersService.getObjectName(UserManagementEntities.FOLDER.getName(), permissionFolderId));
            if (rootFolder.getId().equals(permissionFolderId) && Objects.nonNull(objectPermissions)) {
                perms.setUserAccess(objectPermissions.keySet());
                perms.setIsEnable(true);
            }
            response.setPermissions(perms);
            hasWritePermissions = this.userHasWritePermissions(objectPermissions);
            response.setHasWritePermissions(hasWritePermissions);
        } else {
            hasWritePermissions = true;
            response.setHasWritePermissions(true);
        }
        List<Folder> childrenFolders = StreamUtils.filterList(folders, folder -> rootFolderId.equals(folder.getParentId()));
        RequestAuthorization rootFolderAuth = rootFolder.getAuthorization();
        ParentRequestAuthorization parentAuth = Objects.nonNull(rootFolderAuth) ? (RequestAuthorizationType.INHERIT_FROM_PARENT.equals((Object)rootFolderAuth.getType()) ? response.getParentAuth() : new ParentRequestAuthorization(rootFolder.getId(), rootFolder.getName(), rootFolderAuth.getType())) : new ParentRequestAuthorization(rootFolder.getId(), rootFolder.getName(), null);
        childrenFolders.forEach(folder -> {
            GroupResponse childResponse = this.getFolderGroupResponse((Folder)folder, new GroupResponse((Folder)folder, parentAuth), folders, requests, search, servicePermissions);
            if (!childResponse.isFilteredOut()) {
                response.addChildren(childResponse);
            }
        });
        List<Request> folderMatchedRequests = StreamUtils.filterList(requests, request -> rootFolderId.equals(request.getFolderId()));
        if (!CollectionUtils.isEmpty(folderMatchedRequests)) {
            List<GroupResponse> childFolders = this.getChildFolders(response);
            boolean isAllChildrenFoldersFilteredOut = childFolders.isEmpty() || childFolders.stream().allMatch(GroupResponse::isFilteredOut);
            boolean isNoneRequestNameMatchesSearch = folderMatchedRequests.stream().noneMatch(request -> clover.org.apache.commons.lang.StringUtils.containsIgnoreCase((String)request.getName(), (String)search));
            List<GroupResponse> requestResponses = Objects.nonNull(search) && (!isNoneRequestNameMatchesSearch || !isAllChildrenFoldersFilteredOut) ? folderMatchedRequests.stream().filter(request -> clover.org.apache.commons.lang.StringUtils.containsIgnoreCase((String)request.getName(), (String)search)).map(request -> {
                GroupResponse gr = new GroupResponse((Request)request, parentAuth);
                gr.setPermissions(perms);
                gr.setHasWritePermissions(hasWritePermissions);
                return gr;
            }).collect(Collectors.toList()) : folderMatchedRequests.stream().map(request -> {
                GroupResponse gr = new GroupResponse((Request)request, parentAuth);
                gr.setPermissions(perms);
                gr.setHasWritePermissions(hasWritePermissions);
                return gr;
            }).collect(Collectors.toList());
            boolean isFolderNameMatchesSearch = clover.org.apache.commons.lang.StringUtils.containsIgnoreCase((String)rootFolder.getName(), (String)search);
            if (Objects.nonNull(search)) {
                response.setFilteredOut(isNoneRequestNameMatchesSearch && isAllChildrenFoldersFilteredOut && !isFolderNameMatchesSearch);
            }
            response.addChildren(requestResponses);
        } else {
            List<GroupResponse> childFolders = this.getChildFolders(response);
            boolean isAllChildrenFoldersFilteredOut = childFolders.isEmpty() || childFolders.stream().allMatch(GroupResponse::isFilteredOut);
            boolean isFolderNameMatchesSearch = clover.org.apache.commons.lang.StringUtils.containsIgnoreCase((String)rootFolder.getName(), (String)search);
            if (Objects.nonNull(search)) {
                response.setFilteredOut(isAllChildrenFoldersFilteredOut && !isFolderNameMatchesSearch);
            }
        }
        return response;
    }

    private boolean userHasWritePermissions(Map<UUID, Operations> objectPermissions) {
        UserInfo userInfo = (UserInfo)this.userInfoProvider.get();
        UUID userId = Objects.nonNull(userInfo) ? userInfo.getId() : null;
        return this.policyEnforcement.isAdmin() || Objects.nonNull(userId) && !CollectionUtils.isEmpty(objectPermissions) && objectPermissions.containsKey(userId);
    }

    @Transactional
    public Folder createFolder(FolderUpsetRequest request) throws Exception {
        log.info("Create folder by request: {}", (Object)request);
        AuthorizationSaveRequest authorization = request.getAuthorization();
        if (Objects.nonNull(authorization)) {
            this.requestAuthorizationService.encryptAuthorizationParameters(authorization);
        }
        Folder folder = (Folder)this.modelMapper.map((Object)request, Folder.class);
        this.setOrder(folder);
        if (Objects.nonNull(request.getPermissions())) {
            this.updateFolderPermissions(folder, request.getPermissions());
        }
        this.updateAuthorizationFolderId(folder);
        log.debug("Saving folder: {}", (Object)folder);
        Folder savedFolder = this.save(folder);
        if (Objects.nonNull(request.getPermissions()) && request.getPermissions().getIsEnable()) {
            this.usersService.grantAllPermissions(UserManagementEntities.FOLDER.getName(), request.getProjectId(), savedFolder.getPermissionFolderId(), new ArrayList<UUID>(request.getPermissions().getUserAccess()));
        }
        return savedFolder;
    }

    private void updateFolderPermissions(Folder folder, Permissions permissions) {
        if (permissions.getIsEnable()) {
            UUID folderId = folder.getId();
            if (Objects.isNull(folderId)) {
                folderId = UUID.randomUUID();
                folder.setId(folderId);
            }
            folder.setPermissionFolderId(folderId);
            folder.setPermission(this.permissionEntityConverter.convertToDatabaseColumn(new PermissionEntity(this.getUsersForPermission(permissions.getUserAccess(), folder.getProjectId()))));
        } else if (Objects.nonNull(folder.getParentId())) {
            Folder parentFolder = this.getFolder(folder.getParentId());
            folder.setPermissionFolderId(parentFolder.getPermissionFolderId());
            folder.setPermission(parentFolder.getPermission());
        } else {
            folder.setPermissionFolderId(null);
            folder.setPermission(this.permissionEntityConverter.convertToDatabaseColumn(new PermissionEntity()));
        }
    }

    private TreeMap<UUID, String> getUsersForPermission(Set<UUID> userIds, UUID projectId) {
        TreeMap<UUID, String> users = new TreeMap<UUID, String>();
        List userInfoList = this.usersService.getUsersInfoByProjectId(projectId, new ArrayList<UUID>(userIds));
        if (userInfoList != null) {
            userInfoList.forEach(u -> users.put(u.getId(), u.getFullName()));
        }
        return users;
    }

    private void setChildPermissions(Folder parentFolder) {
        if (Objects.nonNull(parentFolder)) {
            GroupResponse rootNode = this.getRequestTreeByParentFolderId(parentFolder.getId());
            this.setChildPermission(rootNode, parentFolder.getPermissionFolderId());
        }
    }

    private void setChildPermissions(UUID parentFolderId) {
        if (Objects.nonNull(parentFolderId)) {
            Folder parentFolder = this.getFolder(parentFolderId);
            GroupResponse rootNode = this.getRequestTreeByParentFolderId(parentFolderId);
            this.setChildPermission(rootNode, parentFolder.getPermissionFolderId());
        }
    }

    private void setChildPermission(GroupResponse node, UUID permissionFolderId) {
        List<GroupResponse> children = node.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            children.forEach(child -> {
                if (EntityType.FOLDER.equals((Object)child.getType())) {
                    Folder childFolder = this.getFolder(child.getId());
                    if (childFolder != null && !childFolder.getId().equals(childFolder.getPermissionFolderId())) {
                        childFolder.setPermissionFolderId(permissionFolderId);
                        this.save(childFolder);
                        this.setChildPermission((GroupResponse)child, permissionFolderId);
                    }
                } else {
                    Request childRequest = (Request)this.requestRepository.findById(child.getId()).orElseThrow(() -> new AtpEntityNotFoundException("Request", (Object)child.getId()));
                    childRequest.setPermissionFolderId(permissionFolderId);
                    this.requestRepository.save(childRequest);
                }
            });
        }
    }

    public void setOrder(Folder folder) {
        int n;
        Integer maxOrder;
        UUID projectId = folder.getProjectId();
        UUID parentId = folder.getParentId();
        Integer n2 = maxOrder = Objects.isNull(parentId) ? this.folderRepository.findMaxOrder(projectId) : this.folderRepository.findMaxOrder(projectId, parentId);
        if (Objects.nonNull(maxOrder)) {
            maxOrder = maxOrder + 1;
            n = maxOrder;
        } else {
            n = 0;
        }
        Integer calcOrder = n;
        log.debug("Folder order: {}", (Object)calcOrder);
        folder.setOrder(calcOrder);
    }

    public List<Folder> createFolders(List<Folder> folders) {
        log.info("Create folders by list folders: {}", folders);
        return this.saveAll(folders);
    }

    @Transactional
    public Folder editFolder(UUID folderId, FolderEditRequest request) throws Exception {
        Folder folder;
        log.info("Update folder by request: {}", (Object)request);
        AuthorizationSaveRequest authorization = request.getAuthorization();
        if (Objects.nonNull(authorization)) {
            this.requestAuthorizationService.encryptAuthorizationParameters(authorization);
        }
        if (!this.isSettingsAreEqual(folder = (Folder)this.get(folderId), request)) {
            Set copyFolderIds = this.folderRepository.findHeirsIdsByIdIn(Collections.singleton(folderId));
            List<Folder> foundFolders = this.folderRepository.findAllByIdIn(copyFolderIds);
            foundFolders.add(folder);
            this.changeOfInheritedProperties(foundFolders, request);
        }
        this.modelMapper.map((Object)request, (Object)folder);
        if (Objects.nonNull(request.getPermissions())) {
            this.updateFolderPermissions(folder, request.getPermissions());
            this.setChildPermissions(folder);
        }
        this.updateAuthorizationFolderId(folder);
        Folder savedFolder = this.save(folder);
        if (Objects.nonNull(request.getPermissions()) && request.getPermissions().getIsEnable()) {
            this.usersService.grantAllPermissions(UserManagementEntities.FOLDER.getName(), request.getProjectId(), savedFolder.getPermissionFolderId(), new ArrayList<UUID>(request.getPermissions().getUserAccess()));
        }
        return savedFolder;
    }

    public void updateAuthorizationFolderId(Request request) {
        this.updateAuthorizationFolderId(request.getAuthorization(), request.getFolderId());
    }

    public void updateAuthorizationFolderId(Folder folder) {
        this.updateAuthorizationFolderId(folder.getAuthorization(), folder.getParentId());
    }

    public void updateAuthorizationFolderId(@Nullable RequestAuthorization authorization, @Nullable UUID parentFolderId) {
        if (Objects.nonNull(authorization) && RequestAuthorizationType.INHERIT_FROM_PARENT.equals((Object)authorization.getType())) {
            InheritFromParentRequestAuthorization inheritAuth = (InheritFromParentRequestAuthorization)authorization;
            inheritAuth.setAuthorizationFolderId(parentFolderId);
        }
    }

    private Set<UUID> getAllChildFolderIds(Folder parentFolder) {
        List<Folder> projectFolders = this.folderRepository.findAllByProjectId(parentFolder.getProjectId());
        return this.collectChildFolderIds(parentFolder, projectFolders);
    }

    private void changeOfInheritedProperties(List<Folder> folderList, FolderEditRequest requestUpdate) {
        Set<UUID> foldersIds = StreamUtils.extractIds(folderList);
        List<Request> requestList = this.requestRepository.findAllByFolderIdIn(foldersIds);
        requestList.forEach(request -> {
            request.setDisableSslCertificateVerification(requestUpdate.isDisableSslCertificateVerification());
            request.setDisableSslClientCertificate(requestUpdate.isDisableSslClientCertificate());
            request.setDisableFollowingRedirect(requestUpdate.isDisableFollowingRedirect());
            request.setAutoCookieDisabled(requestUpdate.isAutoCookieDisabled());
            request.setDisableAutoEncoding(requestUpdate.isDisableAutoEncoding());
        });
        folderList.forEach(folder -> {
            folder.setDisableSslCertificateVerification(requestUpdate.isDisableSslCertificateVerification());
            folder.setDisableSslClientCertificate(requestUpdate.isDisableSslClientCertificate());
            folder.setDisableFollowingRedirect(requestUpdate.isDisableFollowingRedirect());
            folder.setAutoCookieDisabled(requestUpdate.isAutoCookieDisabled());
            folder.setDisableAutoEncoding(requestUpdate.isDisableAutoEncoding());
        });
        log.debug("Change properties for folders: {} and requests: {}", foldersIds, StreamUtils.extractIds(folderList));
        this.requestRepository.saveAll(requestList);
        this.saveAll(folderList);
    }

    @Transactional
    public void copyFolders(FolderCopyRequest request) {
        log.info("Copy folders by request: {}", (Object)request);
        Set<UUID> sourceFolderIds = request.getIds();
        Set copyFolderIds = this.folderRepository.findHeirsIdsByIdIn(sourceFolderIds);
        List<Folder> foundFolders = this.folderRepository.findAllByIdIn(copyFolderIds);
        HashMap<UUID, UUID> oldNewIdsMapping = new HashMap<UUID, UUID>();
        copyFolderIds.forEach(folderId -> oldNewIdsMapping.put((UUID)folderId, UUID.randomUUID()));
        List<Folder> copyFolders = StreamUtils.map(foundFolders, Folder::new);
        UUID destinationFolderId = request.getToFolderId();
        UUID projectId = request.getProjectId();
        copyFolders.forEach(folder -> {
            UUID id = folder.getId();
            UUID parentId = folder.getParentId();
            if (sourceFolderIds.contains(id)) {
                List<Folder> destinationFolders = this.folderRepository.findAllByProjectIdAndParentId(projectId, destinationFolderId);
                this.addPostfixIfFolderNameInDestinationIsTaken(destinationFolders, (Folder)folder);
                folder.setParentId(destinationFolderId);
                this.setOrder((Folder)folder);
            } else {
                folder.setParentId((UUID)oldNewIdsMapping.get(parentId));
            }
            folder.setId((UUID)oldNewIdsMapping.get(id));
            folder.setPermissionFolderId(null);
            this.updateAuthorizationFolderId((Folder)folder);
        });
        Set<UUID> copyFoldersIds = StreamUtils.extractIds(copyFolders);
        log.debug("Coping folders: {}", copyFoldersIds);
        this.saveAll(copyFolders);
        this.updateParentFolderChildren(destinationFolderId);
        this.copyFoldersRequests(foundFolders, oldNewIdsMapping);
        if (Objects.nonNull(request.getToFolderId())) {
            this.setChildPermissions(request.getToFolderId());
        }
    }

    public void addPostfixIfFolderNameInDestinationIsTaken(List<Folder> destinationFolders, Folder folder) {
        while (destinationFolders.stream().anyMatch(destinationFolder -> destinationFolder.getName().equals(folder.getName()))) {
            folder.setName(folder.getName() + " Copy");
        }
    }

    private void copyFoldersRequests(List<Folder> folders, Map<UUID, UUID> oldNewIdsMapping) {
        Set<UUID> foldersIds = StreamUtils.extractIds(folders);
        log.debug("Copy folder requests. Folders: {}, id's mapping: {}", foldersIds, oldNewIdsMapping);
        List<Request> foundRequests = this.requestRepository.findAllByFolderIdIn(foldersIds);
        List<Request> copyRequests = StreamUtils.map(foundRequests, RequestUtils::copyRequestFromRequest);
        copyRequests.forEach(request -> {
            request.setId(UUID.randomUUID());
            request.setFolderId((UUID)oldNewIdsMapping.get(request.getFolderId()));
            request.setPermissionFolderId(null);
            this.updateAuthorizationFolderId((Request)request);
        });
        Set<UUID> copyRequestIds = StreamUtils.extractIds(copyRequests);
        log.debug("Coping requests with ids: {}", copyRequestIds);
        this.requestRepository.saveAll(copyRequests);
        foldersIds.forEach(this::updateParentFolderChildren);
    }

    @Transactional
    public void moveFolders(FolderMoveRequest request) {
        log.info("Move folders by request: {}", (Object)request);
        Set<UUID> sourceFolderIds = StreamUtils.extractIds(request.getIds(), IdWithModifiedWhen::getId);
        UUID destinationFolderId = request.getToFolderId();
        List<Folder> moveFolders = this.folderRepository.findAllByIdIn(sourceFolderIds);
        moveFolders.forEach(folder -> {
            folder.setParentId(destinationFolderId);
            this.setOrder((Folder)folder);
            folder.setPermissionFolderId(null);
            this.updateAuthorizationFolderId((Folder)folder);
        });
        log.debug("Moving folders: [{}]", moveFolders);
        this.saveAll(moveFolders);
        this.setChildPermissions(destinationFolderId);
    }

    @Transactional
    public void deleteFolders(FolderDeleteRequest request) {
        log.info("Delete folders by request: {}", (Object)request);
        UUID projectId = request.getProjectId();
        List<Folder> allProjectFolders = this.folderRepository.findAllByProjectId(projectId);
        Set deleteFolderIds = this.folderRepository.findHeirsIdsByIdIn(request.getIds());
        Set<UUID> folderPermissionsIds = allProjectFolders.stream().map(Folder::getPermissionFolderId).filter(permissionFolderId -> Objects.nonNull(permissionFolderId) && deleteFolderIds.contains(permissionFolderId)).collect(Collectors.toSet());
        this.checkThatAccessGranted(projectId, folderPermissionsIds, Operation.DELETE);
        List<Request> foldersRequests = this.requestRepository.findAllByFolderIdIn(deleteFolderIds);
        Set<UUID> foldersRequestsIds = StreamUtils.extractIds(foldersRequests);
        log.debug("Deleting request ids: [{}]", foldersRequestsIds);
        this.requestRepository.deleteByIdIn(foldersRequestsIds);
        log.debug("Delete javers history snapshots by request ids: {}", foldersRequestsIds);
        this.deleteHistoryService.deleteSnapshotsByEntityIds(foldersRequestsIds);
        log.debug("Deleting folder ids: [{}]", (Object)deleteFolderIds);
        deleteFolderIds.forEach(this::updateParentFolderChildren);
        this.folderRepository.deleteByIdIn(deleteFolderIds);
        log.debug("Delete javers history snapshots by folder ids: {}", (Object)deleteFolderIds);
        this.deleteHistoryService.deleteSnapshotsByEntityIds(deleteFolderIds);
        if (!CollectionUtils.isEmpty(folderPermissionsIds)) {
            this.usersService.deleteObjectPermissionsBulk(UserManagementEntities.FOLDER.getName(), request.getProjectId(), new ArrayList<UUID>(folderPermissionsIds));
        }
    }

    public void checkThatAccessGranted(UUID projectId, Set<UUID> folderPermissionsIds, Operation operation) {
        boolean isAccessGranted = false;
        try {
            isAccessGranted = this.policyEnforcement.checkAccess(UserManagementEntities.FOLDER.getName(), projectId, folderPermissionsIds, operation);
        }
        catch (Exception ex) {
            log.error("Failed to check access on {} folders, message: {}", (Object)operation.toString(), (Object)ex.getMessage());
        }
        if (!isAccessGranted) {
            String message = "You do not have access to " + operation + " folder.";
            log.error(message);
            throw new ItfLiteAccessDeniedException(message);
        }
    }

    public long countFolderHeirs(FolderDeleteRequest request) {
        log.info("Get folders with heirs by request: {}", (Object)request);
        long contHeirs = 0L;
        Set summaryFolderIds = this.folderRepository.findHeirsIdsByIdIn(request.getIds());
        List<Request> foldersRequests = this.requestRepository.findAllByFolderIdIn(summaryFolderIds);
        if (!CollectionUtils.isEmpty(foldersRequests)) {
            contHeirs = foldersRequests.size();
        }
        log.debug("Folders heirs: [{}]", foldersRequests);
        return contHeirs;
    }

    public void order(UUID folderId, FolderOrderChangeRequest request) {
        log.debug("Change order for the folder with id '{}', request params: {}", (Object)folderId, (Object)request);
        UUID projectId = request.getProjectId();
        UUID parentFolderId = request.getParentFolderId();
        int order = request.getOrder();
        List<Folder> folders = this.folderRepository.findAllByProjectIdAndParentId(projectId, parentFolderId);
        folders.sort(Comparator.comparingInt(Folder::getOrder));
        Folder changedFolder = StreamUtils.find(folders, folder -> folder.getId().equals(folderId));
        folders.remove(changedFolder);
        folders.add(order, changedFolder);
        int count = 0;
        for (Folder folder2 : folders) {
            folder2.setOrder(count++);
        }
        this.saveAll(folders);
    }

    public Folder getByProjectIdAndSourceId(UUID projectId, UUID sourceId) {
        return this.folderRepository.getByProjectIdAndSourceId(projectId, sourceId);
    }

    public UUID getIdByFoldersPath(UUID projectId, List<String> path) {
        try {
            return this.folderRepository.getFolderIdPyPath(projectId, path);
        }
        catch (Exception ex) {
            log.error("Failed to get folder id by path {}", path, (Object)ex);
            throw new AtpEntityNotFoundException("Folder", "path", path);
        }
    }

    public ParentRequestAuthorization getParentAuth(@Nullable UUID parentFolderId) {
        if (Objects.isNull(parentFolderId)) {
            return null;
        }
        Folder folder = this.getFolder(parentFolderId);
        RequestAuthorization folderAuth = folder.getAuthorization();
        if (Objects.nonNull(folderAuth)) {
            if (RequestAuthorizationType.INHERIT_FROM_PARENT.equals((Object)folderAuth.getType())) {
                return this.getParentAuth(folder.getParentId());
            }
            return new ParentRequestAuthorization(parentFolderId, folder.getName(), folderAuth.getType());
        }
        return new ParentRequestAuthorization(parentFolderId, folder.getName(), null);
    }

    public Folder updateParentFolderChildren(UUID folderId) {
        if (folderId != null) {
            try {
                return this.updateParentFolderChildren((Folder)this.get(folderId));
            }
            catch (AtpEntityNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public Folder updateParentFolderChildren(Folder folder) {
        if (folder.getParentId() != null) {
            return this.updateFolderChildren(folder.getParentId());
        }
        return folder;
    }

    public List<Folder> updateParentFolderChildren(List<Folder> folders) {
        Set parents = folders.stream().filter(folder -> folder.getParentId() != null).map(folder -> {
            try {
                return this.updateFolderChildren((Folder)this.get(folder.getParentId()));
            }
            catch (AtpEntityNotFoundException e) {
                return null;
            }
        }).collect(Collectors.toSet());
        return this.updateFoldersChildren(new ArrayList<Folder>(parents));
    }

    public Folder updateFolderChildren(UUID folderId) {
        if (folderId != null) {
            try {
                return this.updateFolderChildren((Folder)this.get(folderId));
            }
            catch (AtpEntityNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public Folder updateFolderChildren(Folder folder) {
        folder.setChildFolders(this.listConverter.convertToDatabaseColumn(this.getChildFolderNames(folder)));
        folder.setChildRequests(this.listConverter.convertToDatabaseColumn(this.getChildRequestNames(folder)));
        return super.save(folder);
    }

    public List<Folder> updateFoldersChildren(List<Folder> folders) {
        folders.forEach(folder -> {
            if (folder != null) {
                folder.setChildFolders(this.listConverter.convertToDatabaseColumn(this.getChildFolderNames((Folder)folder)));
                folder.setChildRequests(this.listConverter.convertToDatabaseColumn(this.getChildRequestNames((Folder)folder)));
            }
        });
        return super.saveAll(folders);
    }

    private List<String> getChildRequestNames(Folder parentFolder) {
        return this.requestRepository.findAllByFolderId(parentFolder.getId()).stream().map(AbstractNamedEntity::getName).sorted().collect(Collectors.toList());
    }

    private List<String> getChildFolderNames(Folder parentFolder) {
        return new ArrayList<String>(this.collectChildFolderIds(parentFolder, this.folderRepository.findAllByProjectId(parentFolder.getProjectId()), false).values());
    }

    private Set<UUID> collectChildFolderIds(Folder parentFolder, List<Folder> projectFolders) {
        HashSet<UUID> childIds = new HashSet<UUID>();
        projectFolders.stream().filter(folder -> parentFolder.getId().equals(folder.getParentId())).forEach(folder -> {
            childIds.add(folder.getId());
            childIds.addAll(this.collectChildFolderIds((Folder)folder, projectFolders));
        });
        return childIds;
    }

    private TreeMap<UUID, String> collectChildFolderIds(Folder parentFolder, List<Folder> projectFolders, boolean includeChild) {
        TreeMap<UUID, String> childIds = new TreeMap<UUID, String>();
        projectFolders.stream().filter(folder -> parentFolder.getId().equals(folder.getParentId())).forEach(folder -> {
            childIds.put(folder.getId(), folder.getName());
            if (includeChild) {
                childIds.putAll(this.collectChildFolderIds((Folder)folder, projectFolders, true));
            }
        });
        return childIds;
    }

    private boolean isSettingsAreEqual(Folder folder, FolderEditRequest folderEditRequest) {
        return new EqualsBuilder().append(folder.isAutoCookieDisabled(), folderEditRequest.isAutoCookieDisabled()).append(folder.isDisableSslCertificateVerification(), folderEditRequest.isDisableSslCertificateVerification()).append(folder.isDisableSslClientCertificate(), folderEditRequest.isDisableSslClientCertificate()).append(folder.isDisableFollowingRedirect(), folderEditRequest.isDisableFollowingRedirect()).append(folder.isDisableAutoEncoding(), folderEditRequest.isDisableAutoEncoding()).isEquals();
    }

    public FolderService(FolderRepository folderRepository, RequestRepository requestRepository, ModelMapper modelMapper, UsersService usersService, PolicyEnforcement policyEnforcement, Provider<UserInfo> userInfoProvider, RequestAuthorizationService requestAuthorizationService, FolderSpecificationService folderSpecificationService, DeleteHistoryService deleteHistoryService, PermissionEntityConverter permissionEntityConverter, ListConverter listConverter) {
        this.folderRepository = folderRepository;
        this.requestRepository = requestRepository;
        this.modelMapper = modelMapper;
        this.usersService = usersService;
        this.policyEnforcement = policyEnforcement;
        this.userInfoProvider = userInfoProvider;
        this.requestAuthorizationService = requestAuthorizationService;
        this.folderSpecificationService = folderSpecificationService;
        this.deleteHistoryService = deleteHistoryService;
        this.permissionEntityConverter = permissionEntityConverter;
        this.listConverter = listConverter;
    }
}

