/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.UUID;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.FormDataPartRepository;
import org.qubership.atp.itf.lite.backend.exceptions.ItfLiteException;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FormDataPartService {
    private static final Logger log = LoggerFactory.getLogger(FormDataPartService.class);
    private final FormDataPartRepository formDataPartRepository;
    private final GridFsService gridFsService;

    @Transactional
    public void uploadFile(UUID requestId, UUID id, MultipartFile file) {
        UUID fileId = UUID.randomUUID();
        try {
            this.formDataPartRepository.updateFileInfoById(fileId, file.getSize(), file.getOriginalFilename(), id);
            this.gridFsService.saveFileByRequestId(LocalDateTime.now().toString(), requestId, file.getInputStream(), file.getOriginalFilename(), fileId);
        }
        catch (IOException ex) {
            log.error("Failed to upload file for formDataPart (requestId: {}, id: {})", (Object)requestId, (Object)id);
            throw new ItfLiteException("Failed to upload file");
        }
    }

    public FormDataPartService(FormDataPartRepository formDataPartRepository, GridFsService gridFsService) {
        this.formDataPartRepository = formDataPartRepository;
        this.gridFsService = gridFsService;
    }
}

