/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.GridFsRepository;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GridFsService {
    private static final Logger log = LoggerFactory.getLogger(GridFsService.class);
    private final GridFsRepository repository;

    @Autowired
    public GridFsService(GridFsRepository repository) {
        this.repository = repository;
    }

    public Optional<FileData> downloadFile(UUID requestId) {
        return this.repository.getRequestFileData(requestId);
    }

    public Optional<FileData> downloadFileByFileId(UUID fileId) {
        return this.repository.getFileDataByFileId(fileId);
    }

    public Optional<FileData> downloadFileBySessionIdAndRequestId(UUID sessionId, UUID sessionRequestId) {
        return this.repository.getFileDataBySessionIdAndRequestId(sessionId, sessionRequestId);
    }

    public void removeFileByRequestId(UUID requestId) {
        this.repository.removeFileByRequestId(requestId);
    }

    public void removeAllFilesByRequestId(UUID requestId) {
        this.repository.removeAllFilesByRequestId(requestId);
    }

    public void removeAllFilesBySessionIdAndSessionRequestId(UUID sessionId, UUID requestId) {
        this.repository.removeAllFilesBySessionIdAndSessionRequestId(sessionId, requestId);
    }

    public void bulkRemoveFilesBySnapshotKeys(UUID sessionId, List<UUID> requestIds) {
        this.repository.bulkRemoveFilesBySnapshotKeys(sessionId, requestIds);
    }

    public void removeFileByFileId(UUID fileId) {
        this.repository.removeFileByFileId(fileId);
    }

    public void removeBinaryFileByRequestId(UUID requestId) {
        this.repository.removeBinaryFileByRequestId(requestId);
    }

    public void removeFilesByDate(Integer days) {
        this.repository.removeFilesByDate(days);
    }

    public UUID saveDictionaryByRequestId(String creationTime, UUID requestId, InputStream dictionaryInputStream, String dictionaryName) {
        return this.repository.saveDictionaryByRequestId(creationTime, requestId, dictionaryInputStream, dictionaryName);
    }

    public UUID saveDictionaryBySessionIdAndSessionRequestId(String creationTime, UUID sessionId, UUID sessionRequestId, InputStream dictionaryInputStream, String dictionaryName) {
        return this.repository.saveDictionaryBySessionIdAndSessionRequestId(creationTime, sessionId, sessionRequestId, dictionaryInputStream, dictionaryName);
    }

    public void saveFileByRequestId(String creationTime, UUID requestId, InputStream fileInputStream, String fileName, UUID fileId) {
        this.repository.saveFileByRequestId(creationTime, requestId, fileInputStream, fileName, fileId);
    }

    public void saveFileBySessionId(String creationTime, UUID sessionId, InputStream fileInputStream, String fileName, UUID fileId) {
        this.repository.saveFileBySessionId(creationTime, sessionId, fileInputStream, fileName, fileId);
    }

    public List<FileData> getFilesDataByRequestId(UUID requestId) {
        return this.repository.getFilesDataList(requestId);
    }

    public UUID copyFileById(UUID fileId, @Nullable UUID newRequestId) {
        return this.repository.copyFileWithFileId(fileId, newRequestId);
    }

    public FileBody saveBinaryByRequestId(String creationTime, UUID requestId, InputStream inputStream, String name, String contentType) {
        return this.repository.saveBinaryByRequestId(creationTime, requestId, inputStream, name, contentType);
    }

    public FileBody saveBinaryBySessionId(String creationTime, UUID sessionId, UUID sessionRequestId, InputStream inputStream, String name, String contentType) {
        return this.repository.saveBinaryBySessionIdAndSessionRequestId(creationTime, sessionId, sessionRequestId, inputStream, name, contentType);
    }

    public UUID saveHistoryBinary(String creationTime, InputStream inputStream, String name) {
        return this.repository.saveHistoryBinary(creationTime, inputStream, name);
    }

    public void saveByFileInfo(FileInfo fileInfo, InputStream inputStream) {
        this.repository.saveByFileInfo(fileInfo, inputStream);
    }

    public Map<UUID, List<FileInfo>> getFileInfosByRequestIds(Set<UUID> requestIds) {
        return this.repository.getFileInfosByRequestIds(requestIds);
    }

    public List<FileInfo> getFileInfosByRequestId(UUID requestId) {
        return this.repository.getFileInfosByRequestId(requestId);
    }

    public Map<UUID, InputStream> getFilesByFileInfos(List<FileInfo> fileInfos) {
        return this.repository.getFileByFileInfos(fileInfos);
    }

    public FileInfo getFileInfoByRequestId(UUID requestId) {
        return this.repository.getFileInfoByRequestId(requestId);
    }

    public FileInfo getFileInfoByFileId(UUID fileId) {
        return this.repository.getFileInfoByFileId(fileId);
    }

    public InputStream getFileByFileInfo(FileInfo fileInfo) {
        return this.repository.getFileByFileInfo(fileInfo);
    }

    public void moveFileFromSnapshotToRequest(UUID sessionId, UUID requestId) {
        this.repository.moveFileFromSnapshotToRequest(sessionId, requestId);
    }

    public void removeFileBySessionId(UUID sessionId) {
        this.repository.removeFileBySessionId(sessionId);
    }
}

