/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.UUID;
import lombok.NonNull;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetricService {
    private static final Logger log = LoggerFactory.getLogger(MetricService.class);
    private final MeterRegistry meterRegistry;
    public static final String ITF_LITE_REQUESTS_COUNTER = "itf.lite.run.collections.requests.count";
    public static final String ITF_LITE_RUN_COLLECTIONS_COUNTER = "itf.lite.run.collections.count";
    public static final String ITF_LITE_REQUESTS_SIZE = "itf.lite.run.requests.size";
    public static final String ITF_LITE_RESPONSE_SIZE = "itf.lite.run.response.size";
    public static final String PROJECT_ID = "projectId";
    public static final String TRANSPORT_TYPE = "transportType";
    private final Counter.Builder itfLiteRequestsCounter = Counter.builder((String)"itf.lite.run.collections.requests.count").description("Counter for all requests");
    private final Counter.Builder itfLiteRunCollectionCounter = Counter.builder((String)"itf.lite.run.collections.count").description("Counter for run collections");
    private final Counter.Builder itfLiteRequestsSizeCounter = Counter.builder((String)"itf.lite.run.requests.size").description("Counter for requests size");
    private final Counter.Builder itfLiteResponseSizeCounter = Counter.builder((String)"itf.lite.run.response.size").description("Counter for response size");

    public Timer timer(String name, String ... tags) {
        return this.meterRegistry.timer(name, tags);
    }

    public void registerCountCollectionRequests(UUID projectId) {
        this.incrementByTypeTag(projectId.toString(), ITF_LITE_REQUESTS_COUNTER);
    }

    public void registerCountRunCollections(UUID projectId) {
        this.incrementByTypeTag(projectId.toString(), ITF_LITE_RUN_COLLECTIONS_COUNTER);
    }

    public void incrementRequestSizePerProject(Double size, UUID projectId, TransportType transportType) {
        this.incrementByBuilderCounterAndTags(this.itfLiteRequestsSizeCounter, size, PROJECT_ID, projectId.toString(), TRANSPORT_TYPE, transportType.getName());
    }

    public void incrementResponseSizePerProject(Double size, UUID projectId, TransportType transportType) {
        this.incrementByBuilderCounterAndTags(this.itfLiteResponseSizeCounter, size, PROJECT_ID, projectId.toString(), TRANSPORT_TYPE, transportType.getName());
    }

    private void incrementByTypeTag(@NonNull String project, @NonNull String requestType) {
        if (project == null) {
            throw new NullPointerException("project is marked non-null but is null");
        }
        if (requestType == null) {
            throw new NullPointerException("requestType is marked non-null but is null");
        }
        switch (requestType) {
            case "itf.lite.run.collections.requests.count": {
                this.incrementByBuilderCounterAndTags(this.itfLiteRequestsCounter, PROJECT_ID, project);
                break;
            }
            case "itf.lite.run.collections.count": {
                this.incrementByBuilderCounterAndTags(this.itfLiteRunCollectionCounter, PROJECT_ID, project);
                break;
            }
        }
    }

    private void incrementByBuilderCounterAndTags(Counter.Builder counter, double amount, String ... tags) {
        counter.tags(tags).register(this.meterRegistry).increment(amount);
    }

    private void incrementByBuilderCounterAndTags(Counter.Builder counter, String ... tags) {
        this.incrementByBuilderCounterAndTags(counter, 1.0, tags);
    }

    public MetricService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

