/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationRegistry;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyRequest;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyResponse;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpParamSaveRequest;
import org.qubership.atp.itf.lite.backend.model.context.SaveRequestResolvingContext;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.qubership.atp.itf.lite.backend.utils.AuthorizationUtils;
import org.qubership.atp.macros.core.processor.Evaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RequestAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(RequestAuthorizationService.class);
    private final RequestAuthorizationRegistry registry;

    public String processRequestAuthorization(UUID projectId, HttpRequestEntitySaveRequest httpRequest, HttpRequestEntitySaveRequest httpHistoryRequest, UUID environmentId, Evaluator evaluator, SaveRequestResolvingContext resolvingContext) throws AtpDecryptException, JsonProcessingException {
        Map<String, String> authorizationParams;
        String safeAuthorizationToken;
        log.debug("Processing authorization for the request: '{}'", (Object)httpRequest);
        AuthorizationSaveRequest unsafeAuthorization = httpRequest.getAuthorization();
        if (unsafeAuthorization == null) {
            log.debug("Request hasn't configured authorization");
            return null;
        }
        AuthorizationStrategyRequest strategyRequest = AuthorizationUtils.createAuthStrategyRequest(unsafeAuthorization, evaluator, resolvingContext, projectId, environmentId, httpRequest.getUrl(), httpRequest.getHttpMethod());
        RequestAuthorizationStrategy strategy = this.registry.getRequestAuthorizationStrategy(unsafeAuthorization.getType());
        log.debug("Found request authorization with type: {}", (Object)strategy.getAuthorizationType());
        AuthorizationStrategyResponse strategyResponse = strategy.getAuthorizationToken(strategyRequest);
        if (strategyResponse == null) {
            return null;
        }
        String requestAuthorizationToken = strategyResponse.getUnsafeAuthorizationToken();
        if (requestAuthorizationToken != null && !requestAuthorizationToken.isEmpty()) {
            this.updateAuthorizationHeader(httpRequest, requestAuthorizationToken);
            log.debug("Applied unsafe authorization token to request headers");
        }
        if ((safeAuthorizationToken = strategyResponse.getSafeAuthorizationToken()) != null && !safeAuthorizationToken.isEmpty()) {
            this.updateAuthorizationHeader(httpHistoryRequest, safeAuthorizationToken);
            log.debug("Applied safe authorization token to history headers");
        }
        if ((authorizationParams = strategyResponse.getAuthorizationParams()) != null && !authorizationParams.isEmpty()) {
            this.addAuthorizationParamsToRequest(httpRequest, authorizationParams);
            log.debug("Added {} authorization params to request", (Object)authorizationParams.size());
        }
        return requestAuthorizationToken;
    }

    private void addAuthorizationParamsToRequest(HttpRequestEntitySaveRequest request, Map<String, String> authParams) {
        if (request == null || authParams == null || authParams.isEmpty()) {
            return;
        }
        List<HttpParamSaveRequest> requestParams = request.getRequestParams();
        authParams.forEach((key, value) -> requestParams.add(new HttpParamSaveRequest((String)key, (String)value, "", false)));
    }

    private void updateAuthorizationHeader(HttpRequestEntitySaveRequest request, String authorizationHeaderValue) {
        if (request == null || authorizationHeaderValue == null || authorizationHeaderValue.isEmpty()) {
            return;
        }
        List<HttpHeaderSaveRequest> requestHeaders = request.getRequestHeaders();
        requestHeaders.removeIf(header -> "Authorization".equalsIgnoreCase(header.getKey()));
        requestHeaders.add(new HttpHeaderSaveRequest("Authorization", authorizationHeaderValue.trim(), "", false, true));
    }

    public void encryptAuthorizationParameters(AuthorizationSaveRequest authorization) {
        RequestAuthorizationType type = authorization.getType();
        log.debug("Found request authorization with type: {}", (Object)type);
        RequestAuthorizationStrategy authorizationStrategy = this.registry.getRequestAuthorizationStrategy(type);
        log.debug("Encrypting authorization parameters");
        authorizationStrategy.encryptParameters(authorization);
    }

    public RequestAuthorization parseAuthorizationFromMap(Map<String, String> auth, RequestAuthorizationType type) {
        RequestAuthorizationStrategy authorizationStrategy = this.registry.getRequestAuthorizationStrategy(type);
        return authorizationStrategy.parseAuthorizationFromMap(auth);
    }

    @Nullable
    public RequestHeader generateAuthorizationHeader(RequestAuthorization authorization) {
        RequestAuthorizationStrategy strategy = this.resolveStrategy(authorization, "authorization header");
        return strategy != null ? strategy.generateAuthorizationHeader(authorization) : null;
    }

    @Nullable
    public List<RequestParam> generateAuthorizationParams(RequestAuthorization authorization) {
        RequestAuthorizationStrategy strategy = this.resolveStrategy(authorization, "authorization params");
        return strategy != null ? strategy.generateAuthorizationParams(authorization) : null;
    }

    private RequestAuthorizationStrategy resolveStrategy(RequestAuthorization authorization, String context) {
        if (authorization == null || authorization.getType() == null) {
            log.warn("Authorization or type is null. Skipping {} generation", (Object)context);
            return null;
        }
        return this.registry.getRequestAuthorizationStrategy(authorization.getType());
    }

    public RequestAuthorizationService(RequestAuthorizationRegistry registry) {
        this.registry = registry;
    }
}

