/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Striped;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.persistence.EntityNotFoundException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.util.function.TriConsumer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.modelmapper.ModelMapper;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.configuration.FeignClientsProperties;
import org.qubership.atp.itf.lite.backend.configuration.RequestResponseSizeProperties;
import org.qubership.atp.itf.lite.backend.converters.CurlFormatToRequestConverter;
import org.qubership.atp.itf.lite.backend.converters.RequestToCurlFormatConverter;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestExecutionDetailsRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestRepository;
import org.qubership.atp.itf.lite.backend.enums.ContextScope;
import org.qubership.atp.itf.lite.backend.enums.ScriptEngineExceptionType;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.enums.ValueType;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.exceptions.ItfLiteException;
import org.qubership.atp.itf.lite.backend.exceptions.file.ItfLiteMaxFileException;
import org.qubership.atp.itf.lite.backend.exceptions.jsengine.ItfLiteScriptEngineAtpDecryptException;
import org.qubership.atp.itf.lite.backend.exceptions.jsengine.ItfLiteScriptEngineAtpEncryptException;
import org.qubership.atp.itf.lite.backend.exceptions.jsengine.ItfLiteScriptEnginePostScriptExecutionException;
import org.qubership.atp.itf.lite.backend.exceptions.jsengine.ItfLiteScriptEnginePostmanSandboxContextException;
import org.qubership.atp.itf.lite.backend.exceptions.jsengine.ItfLiteScriptEnginePreScriptExecutionException;
import org.qubership.atp.itf.lite.backend.exceptions.jsengine.ItfLiteScriptEngineUnavailableException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteExportRequestException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteHttpRequestExecuteException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteHttpRequestIllegalMethodValueException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestIllegalUrlEmptyValueException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestQueryParamEncodingException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestSizeLimitException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteResponseSizeLimitException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteUploadFileException;
import org.qubership.atp.itf.lite.backend.feign.clients.ItfPlainFeignClient;
import org.qubership.atp.itf.lite.backend.feign.dto.ConsoleLogDto;
import org.qubership.atp.itf.lite.backend.feign.dto.HttpResponseExceptionTypeEnum;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanExecuteScriptResponseDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanExecuteScriptResponseTestResultsInnerErrorDto;
import org.qubership.atp.itf.lite.backend.feign.dto.UIVelocityRequestBodyDto;
import org.qubership.atp.itf.lite.backend.feign.service.ItfFeignService;
import org.qubership.atp.itf.lite.backend.feign.service.JsScriptEngineService;
import org.qubership.atp.itf.lite.backend.feign.service.RamService;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.model.RequestRuntimeOptions;
import org.qubership.atp.itf.lite.backend.model.api.dto.ResponseCookie;
import org.qubership.atp.itf.lite.backend.model.api.request.ContextVariable;
import org.qubership.atp.itf.lite.backend.model.api.request.CurlStringImportRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.ExecutionCollectionRequestExecuteRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderDeleteRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.IdWithModifiedWhen;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitiesBulkDelete;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitiesCopyRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitiesMoveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntityCopyRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntityCreateRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntityEditRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntityMoveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestOrderChangeRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.Settings;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpParamSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.JsExecutionResult;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionHeaderResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestPreExecuteResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.collections.ContextEntity;
import org.qubership.atp.itf.lite.backend.model.api.response.collections.ExecuteStepResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.environments.System;
import org.qubership.atp.itf.lite.backend.model.api.response.itf.ItfParametersResolveResponse;
import org.qubership.atp.itf.lite.backend.model.context.SaveRequestResolvingContext;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.collection.run.CollectionRunRequest;
import org.qubership.atp.itf.lite.backend.model.entities.collection.run.CollectionRunStackRequest;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.model.entities.history.HttpRequestExecutionDetails;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecutionDetails;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;
import org.qubership.atp.itf.lite.backend.service.CookieService;
import org.qubership.atp.itf.lite.backend.service.CrudService;
import org.qubership.atp.itf.lite.backend.service.DynamicVariablesService;
import org.qubership.atp.itf.lite.backend.service.EnvironmentVariableService;
import org.qubership.atp.itf.lite.backend.service.FolderService;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.qubership.atp.itf.lite.backend.service.ItfLiteFileService;
import org.qubership.atp.itf.lite.backend.service.MacrosService;
import org.qubership.atp.itf.lite.backend.service.MetricService;
import org.qubership.atp.itf.lite.backend.service.NextRequestService;
import org.qubership.atp.itf.lite.backend.service.RequestAuthorizationService;
import org.qubership.atp.itf.lite.backend.service.RequestExecutionHistoryService;
import org.qubership.atp.itf.lite.backend.service.RequestSpecificationService;
import org.qubership.atp.itf.lite.backend.service.TemplateResolverService;
import org.qubership.atp.itf.lite.backend.service.WritePermissionsService;
import org.qubership.atp.itf.lite.backend.service.history.iface.DeleteHistoryService;
import org.qubership.atp.itf.lite.backend.service.history.iface.EntityHistoryService;
import org.qubership.atp.itf.lite.backend.service.rest.HttpClientService;
import org.qubership.atp.itf.lite.backend.utils.Constants;
import org.qubership.atp.itf.lite.backend.utils.CookieUtils;
import org.qubership.atp.itf.lite.backend.utils.FileUtils;
import org.qubership.atp.itf.lite.backend.utils.RequestUtils;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.qubership.atp.itf.lite.backend.utils.UrlParsingUtils;
import org.qubership.atp.macros.core.processor.Evaluator;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.SerializationUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class RequestService
extends CrudService<Request>
implements EntityHistoryService<Request> {
    private static final Logger log = LoggerFactory.getLogger(RequestService.class);
    static final String ITF_URL_CONTEXT_SEPARATOR = "#/context/";
    static final String ITF_URL_PROJECT_SEPARATOR = "/project/";
    static final String ITF_CONFIGURATOR = "configurator";
    static final String ITF_EXECUTOR = "executor";
    static final String SESSION_ID = "Session-Id";
    static final String ORIGIN_HOST = "Origin-Host";
    static final String ORIGIN_HOST_VALUE = "originHostValue";
    static final String ORIGIN_REALM = "Origin-Realm";
    static final String ORIGIN_REALM_VALUE = "originRealmValue";
    static final String DPA_FORMAT = "<DPA><Origin-Host>${originHostValue}</Origin-Host><Origin-Realm>${originRealmValue}</Origin-Realm><Result-Code>2001</Result-Code></DPA>";
    static final String RESULT_CODE_TAG = "Result-Code";
    static final String MESSAGE_TEXT_TAG = "Error-Message";
    static final String TAG_DELIMITER = ";";
    static final String XML_START_SYMBOL = "<";
    static final String XML_END_SYMBOL = ">";
    private static final int STRIPES = 100;
    private static final Striped<Lock> LOCK_STRIPED = Striped.lazyWeakLock((int)100);
    private final RequestRepository requestRepository;
    private final ModelMapper modelMapper;
    private final ObjectMapper objectMapper;
    private final CurlFormatToRequestConverter curlFormatToRequestConverter;
    private final RequestToCurlFormatConverter requestToCurlFormatConverter;
    private final ItfFeignService itfFeignService;
    private final ItfPlainFeignClient itfPlainFeignClient;
    private final FeignClientsProperties feignClientsProperties;
    private final GridFsService gridFsService;
    private final RequestExecutionHistoryService executionHistoryService;
    private final FolderService folderService;
    private final RequestAuthorizationService requestAuthorizationService;
    private final EnvironmentVariableService envParamService;
    private final RequestSpecificationService requestSpecificationService;
    private final MetricService metricService;
    private final HttpClientService httpClientService;
    private final MacrosService macrosService;
    private final JsScriptEngineService scriptService;
    private final ItfLiteFileService itfLiteFileService;
    private final TemplateResolverService templateResolverService;
    private final RamService ramService;
    private final DynamicVariablesService dynamicVariablesService;
    private final WritePermissionsService writePermissionsService;
    private final CookieService cookieService;
    private final RequestExecutionDetailsRepository detailsRepository;
    private final NextRequestService nextRequestService;
    private final RequestResponseSizeProperties requestResponseSizeProperties;
    private final DeleteHistoryService deleteHistoryService;
    @Value(value="${atp.itf.lite.max-size-file:10485760}")
    private long maxFileSize;

    @Override
    protected JpaRepository<Request, UUID> repository() {
        return this.requestRepository;
    }

    @Override
    public Request restore(Request entity) {
        return this.save(entity);
    }

    @Override
    public Request save(Request request) {
        Request savedRequest = super.save(request);
        this.folderService.updateFolderChildren(savedRequest.getFolderId());
        return savedRequest;
    }

    public Request getRequest(UUID requestId) {
        return this.getRequest(requestId, null);
    }

    public Request getRequest(UUID requestId, UUID projectId) {
        HttpRequest httpRequest;
        List<Cookie> cookies;
        Request request;
        log.info("Find request by id {} and projectId {}", (Object)requestId, (Object)projectId);
        Request request2 = request = Objects.isNull(projectId) ? (Request)this.get(requestId) : this.getByProjectIdAndId(projectId, requestId);
        if (!request.isAutoCookieDisabled() && request instanceof HttpRequest && !CollectionUtils.isEmpty(cookies = this.cookieService.getNotExpiredCookiesByUserIdAndProjectId(request.getProjectId())) && StringUtils.isNotEmpty((String)(httpRequest = (HttpRequest)request).getUrl())) {
            try {
                URI uri = new URI(httpRequest.getUrl());
                HttpHeaderSaveRequest cookieHeader = this.cookieService.cookieListToRequestHeader(uri, cookies);
                if (StringUtils.isNotEmpty((String)cookieHeader.getValue())) {
                    log.info("Get cookies header for request with id {}", (Object)request.getId());
                    httpRequest.setCookieHeader(cookieHeader);
                }
            }
            catch (URISyntaxException ignore) {
                log.warn("Syntax exception", (Throwable)ignore);
            }
        }
        request.setHasWritePermissions(this.writePermissionsService.hasWritePermissions(request.getPermissionFolderId(), request.getProjectId()));
        request.setParentAuth(this.folderService.getParentAuth(request.getFolderId()));
        return request;
    }

    @Nullable
    public RequestHeader generateAuthorizationHeader(@Nullable RequestAuthorization authorization) {
        if (Objects.nonNull(authorization)) {
            return this.requestAuthorizationService.generateAuthorizationHeader(authorization);
        }
        return null;
    }

    @Nullable
    public List<RequestParam> generateAuthorizationParams(RequestAuthorization authorization) {
        if (Objects.nonNull(authorization)) {
            return this.requestAuthorizationService.generateAuthorizationParams(authorization);
        }
        return null;
    }

    private Request getByProjectIdAndId(UUID projectId, UUID requestId) {
        Optional<Request> requestOptional = this.requestRepository.findByProjectIdAndId(projectId, requestId);
        if (requestOptional.isPresent()) {
            return requestOptional.get();
        }
        log.error("Unable find request by id = {} and projectId = {}", (Object)requestId, (Object)projectId);
        throw new AtpEntityNotFoundException("Request", (Object)requestId);
    }

    public Settings getSettings(UUID requestId) {
        log.debug("Get request settings by requestId: {}", (Object)requestId);
        return (Settings)this.modelMapper.map((Object)this.getRequest(requestId), Settings.class);
    }

    public Set<UUID> getPermissionFolderIdsByRequestIds(Set<UUID> requestIds) {
        return this.requestRepository.findAllByIdIn(requestIds).stream().filter(request -> request.getPermissionFolderId() != null).map(Request::getPermissionFolderId).collect(Collectors.toSet());
    }

    public Set<UUID> getPermissionFolderIdsByIdsWithModifiedWhen(Set<IdWithModifiedWhen> requestIds) {
        Set<UUID> ids = requestIds.stream().map(IdWithModifiedWhen::getId).collect(Collectors.toSet());
        return this.requestRepository.findAllByIdIn(ids).stream().filter(request -> request.getPermissionFolderId() != null).map(Request::getPermissionFolderId).collect(Collectors.toSet());
    }

    public boolean isRequestExists(UUID requestId) {
        log.debug("Check request existence by id {}", (Object)requestId);
        if (!this.isEntityExists(requestId)) {
            log.error("Failed to found {} entity with id: {}", (Object)RequestService.class.getName(), (Object)requestId);
            throw new AtpEntityNotFoundException(RequestService.class.getName(), (Object)requestId);
        }
        return true;
    }

    public void getRequestBinaryFile(UUID requestId, HttpServletResponse response) throws IOException {
        log.info("Get binary file for request with id {}", (Object)requestId);
        Request request = this.getRequest(requestId);
        FileData requestBinaryFile = this.itfLiteFileService.getRequestFileData(requestId, request.getModifiedWhen(), Constants.DEFAULT_BINARY_FILES_FOLDER);
        if (requestBinaryFile == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        ServletOutputStream responseOutputStream = response.getOutputStream();
        responseOutputStream.write(requestBinaryFile.getContent());
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", requestBinaryFile.getFileName()));
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Content-Type", requestBinaryFile.getContentType());
        log.debug("File with name {} and content type {} was downloaded.", (Object)requestBinaryFile.getFileName(), (Object)requestBinaryFile.getContentType());
        response.flushBuffer();
    }

    public void getFile(UUID requestId, UUID fileId, HttpServletResponse response) throws IOException {
        log.info("Get file by id {}", (Object)fileId);
        Request request = this.getRequest(requestId);
        FileData file = this.itfLiteFileService.getFileDataById(fileId, request.getModifiedWhen(), Constants.DEFAULT_FORM_DATA_FOLDER);
        if (file == null) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        ServletOutputStream responseOutputStream = response.getOutputStream();
        responseOutputStream.write(file.getContent());
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", file.getFileName()));
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.flushBuffer();
    }

    public void writeResponseAsFile(UUID requestId, UUID executionId, HttpServletResponse response) throws IOException {
        String binaryFileName;
        log.info("Get response as file for requestId = {} by executionId = {}", (Object)requestId, (Object)executionId);
        Optional<RequestExecutionDetails> detailsOptional = this.detailsRepository.findByRequestExecutionByExecutionId(executionId);
        if (!detailsOptional.isPresent()) {
            log.warn("Details information for request id {} not found by EXECUTION ID {}.", (Object)requestId, (Object)executionId);
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        RequestExecutionDetails details = detailsOptional.get();
        HttpRequestExecutionDetails httpRequestExecutionDetails = (HttpRequestExecutionDetails)details;
        Map<String, List<String>> responseHeaders = httpRequestExecutionDetails.getResponseHeaders();
        String extension = this.getExtensionByContentTypeHeader(responseHeaders);
        if (StringUtils.isEmpty((String)extension) && !StringUtils.isEmpty((String)(extension = FilenameUtils.getExtension((String)(binaryFileName = this.getResponseFilenameFromResponseHeaders(responseHeaders)))))) {
            extension = "." + extension;
        }
        if (StringUtils.isEmpty((String)extension)) {
            extension = ".txt";
        }
        String rawFileName = details.getRequestExecution().getName().trim().replaceAll("\\s+", "_") + "_" + details.getRequestExecution().getExecutedWhen().getTime();
        String safeFileName = rawFileName.replaceAll("[\\\\/:*?\"<>|\\r\\n]", "_");
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", safeFileName + extension));
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("X-Content-Type-Options", "nosniff");
        ServletOutputStream responseOutputStream = response.getOutputStream();
        byte[] responseContentAsByteArray = details.getResponseBodyByte();
        responseOutputStream.write(responseContentAsByteArray);
        response.flushBuffer();
    }

    public void uploadBinaryFile(UUID requestId, MultipartFile file) {
        log.info("Upload binary file {} for request with id {}", (Object)file.getOriginalFilename(), (Object)requestId);
        try {
            Request request = this.getRequest(requestId);
            FileBody fileBody = this.itfLiteFileService.uploadFileForRequest(requestId, Constants.DEFAULT_BINARY_FILES_FOLDER, file);
            ((HttpRequest)request).getBody().setBinaryBody(fileBody);
            this.save(request);
        }
        catch (IOException e) {
            log.error("Failed to load the file with name {} for request with id {}", new Object[]{file.getOriginalFilename(), requestId.toString(), e});
            throw new ItfLiteUploadFileException(file.getOriginalFilename(), requestId.toString());
        }
    }

    public Request getRequestByProjectIdAndRequestId(UUID projectId, UUID requestId) {
        log.info("Find request by projectId {} and request id {}", (Object)projectId, (Object)requestId);
        return this.requestRepository.findByProjectIdAndId(projectId, requestId).orElseThrow(() -> {
            log.error("Failed to find request by projectId = {} and id = {}", (Object)projectId, (Object)requestId);
            return new EntityNotFoundException(String.format("Failed to find request by projectId = %s and id = %s", projectId, requestId));
        });
    }

    public Collection<Request> getAllRequests(UUID projectId, UUID folderId) {
        log.info("Find all requests, filters: [projectId: {}, folderId: {}]", (Object)projectId, (Object)folderId);
        Specification requestSpecification = Specification.where(this.requestSpecificationService.generateSpecificationToFilterRequestsByProjectIdFolderIdsRequestIds(projectId, folderId == null ? null : Collections.singleton(folderId), null));
        return this.requestRepository.findAll(requestSpecification);
    }

    public List<Request> getAllRequestsByProjectIdFolderIdsRequestIds(UUID projectId, Set<UUID> folderIds, Set<UUID> requestIds) {
        log.info("Find all requests, filters: [projectId: {}, folderIds: {}, requestIds: {}]", new Object[]{projectId, folderIds, requestIds});
        Specification requestSpecification = Specification.where(this.requestSpecificationService.generateSpecificationToFilterRequestsByProjectIdFolderIdsRequestIds(projectId, folderIds, requestIds));
        return this.requestRepository.findAll(requestSpecification);
    }

    public Request createRequest(RequestEntityCreateRequest requestCreationRequest) {
        Request request = (Request)this.modelMapper.map((Object)requestCreationRequest, HttpRequest.class);
        this.setOrder(request);
        this.folderService.updateFolderChildren(request.getFolderId());
        return this.save(request);
    }

    public Request createRequest(Request request) {
        this.setOrder(request);
        return this.save(request);
    }

    public List<Request> createRequests(List<Request> requests) {
        requests.forEach(this::setOrder);
        return this.saveAll(requests);
    }

    public Request saveRequest(UUID requestId, RequestEntitySaveRequest requestEntitySaveRequest, List<MultipartFile> files, Optional<FileBody> fileInfo) {
        this.checkFilesSize(files);
        log.debug("Check if request with requestId {} exists in project {}", (Object)requestId, (Object)requestEntitySaveRequest.getProjectId());
        AuthorizationSaveRequest authorization = requestEntitySaveRequest.getAuthorization();
        if (Objects.nonNull(authorization)) {
            this.requestAuthorizationService.encryptAuthorizationParameters(authorization);
        }
        requestEntitySaveRequest.normalize();
        Request request = (Request)this.get(requestId);
        HttpRequest httpRequest = (HttpRequest)request;
        HttpRequestEntitySaveRequest saveRequest = (HttpRequestEntitySaveRequest)requestEntitySaveRequest;
        this.retainFormData(httpRequest.getBody(), saveRequest.getBody(), httpRequest.getId(), false);
        this.modelMapper.map((Object)requestEntitySaveRequest, (Object)request);
        this.removeAutoGeneratedHeadersExcept(httpRequest, "Content-Type");
        this.removeAutoGeneratedParamsExcept(httpRequest, new String[0]);
        this.updateHeadersFields(httpRequest.getRequestHeaders());
        this.updateParametersFields(httpRequest.getRequestParams());
        this.dynamicVariablesService.enrichPreScriptsByDynamicVariables(httpRequest);
        this.prepareFormDataRequest(httpRequest.getBody(), files, httpRequest.getId(), false);
        if (fileInfo.isPresent()) {
            if (Objects.isNull(httpRequest.getBody())) {
                httpRequest.setBody(new RequestBody(fileInfo.get(), RequestBodyType.Binary));
            } else {
                httpRequest.getBody().setBinaryBody(fileInfo.get());
            }
        }
        this.folderService.updateAuthorizationFolderId(request);
        return this.save(request);
    }

    private void removeAutoGeneratedHeadersExcept(HttpRequest httpRequest, String ... except) {
        HashSet exceptions = Sets.newHashSet((Object[])except);
        httpRequest.getRequestHeaders().removeIf(header -> !exceptions.contains(header.getKey()) && header.isGenerated());
    }

    private void removeAutoGeneratedParamsExcept(HttpRequest httpRequest, String ... except) {
        HashSet exceptions = Sets.newHashSet((Object[])except);
        httpRequest.getRequestParams().removeIf(param -> !exceptions.contains(param.getKey()) && param.isGenerated());
    }

    public void retainFormData(RequestBody body, RequestBody bodyToSave, UUID id, boolean isSnapshot) {
        RequestBodyType requestToSaveBodyType;
        RequestBodyType savedRequestBodyType = Objects.isNull(body) ? null : body.getType();
        RequestBodyType requestBodyType = requestToSaveBodyType = Objects.isNull(bodyToSave) ? null : bodyToSave.getType();
        if (RequestBodyType.FORM_DATA.equals((Object)requestToSaveBodyType)) {
            if (RequestBodyType.FORM_DATA.equals((Object)savedRequestBodyType)) {
                List<FormDataPart> savedFormDataParts = body.getFormDataBody();
                List<FormDataPart> formDataPartsToSave = bodyToSave.getFormDataBody();
                if (!CollectionUtils.isEmpty(savedFormDataParts)) {
                    if (CollectionUtils.isEmpty(formDataPartsToSave)) {
                        log.debug("RequestToSave not contain files - remove old form-data files");
                        if (isSnapshot) {
                            this.gridFsService.removeFileBySessionId(id);
                        } else {
                            this.gridFsService.removeFileByRequestId(id);
                        }
                    } else {
                        List<UUID> savedFileIds = this.getUniqueFileIds(body.getFormDataBody());
                        savedFileIds.removeAll(this.getUniqueFileIds(bodyToSave.getFormDataBody()));
                        log.info("Remove files with id in {}", savedFileIds);
                        savedFileIds.forEach(this.gridFsService::removeFileByFileId);
                    }
                }
            }
        } else if (RequestBodyType.FORM_DATA.equals((Object)savedRequestBodyType)) {
            log.debug("Request to save change body type - remove old request files (requestId {})", (Object)id);
            if (isSnapshot) {
                this.gridFsService.removeFileBySessionId(id);
            } else {
                this.gridFsService.removeFileByRequestId(id);
            }
            body.setFormDataBody(null);
        }
    }

    private List<UUID> getUniqueFileIds(List<FormDataPart> formData) {
        return formData.stream().filter(fd -> ValueType.FILE.equals((Object)fd.getType())).map(FormDataPart::getFileId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void checkFilesSize(List<MultipartFile> files) {
        if (!CollectionUtils.isEmpty(files)) {
            files.forEach(file -> {
                if (file.getSize() > this.maxFileSize) {
                    throw new ItfLiteMaxFileException(file.getName());
                }
            });
        }
    }

    public List<UUID> prepareFormDataRequest(RequestBody requestBody, List<MultipartFile> files, UUID id, boolean isSnapshotFile) {
        List<FormDataPart> formDataParts;
        ArrayList<UUID> fileIds = new ArrayList<UUID>();
        if (Objects.nonNull(requestBody) && !CollectionUtils.isEmpty(formDataParts = requestBody.getFormDataBody()) && !CollectionUtils.isEmpty(files)) {
            int i = 0;
            for (FormDataPart fdp : formDataParts) {
                if (!ValueType.FILE.equals((Object)fdp.getType()) || !Objects.isNull(fdp.getFileId()) || i >= files.size()) continue;
                MultipartFile f = files.get(i);
                if (Objects.nonNull(f)) {
                    UUID fileId = UUID.randomUUID();
                    fileIds.add(fileId);
                    fdp.setFileId(fileId);
                    fdp.setFileSize(f.getSize());
                    try {
                        if (isSnapshotFile) {
                            this.gridFsService.saveFileBySessionId(LocalDateTime.now().toString(), id, f.getInputStream(), f.getOriginalFilename(), fileId);
                        } else {
                            this.gridFsService.saveFileByRequestId(LocalDateTime.now().toString(), id, f.getInputStream(), f.getOriginalFilename(), fileId);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++i;
            }
        }
        return fileIds;
    }

    private <S, O> List<S> retainEntities(List<O> opposite, Function<O, S> mapper) {
        return opposite.stream().map(mapper).collect(Collectors.toList());
    }

    public Request editRequest(UUID requestId, RequestEntityEditRequest requestEntityCreateRequest) {
        log.debug("Check if request with requestId {} exists in project {}", (Object)requestId, (Object)requestEntityCreateRequest.getProjectId());
        Request request = (Request)this.get(requestId);
        this.modelMapper.map((Object)requestEntityCreateRequest, (Object)request);
        return this.save(request);
    }

    public Request copyRequest(UUID requestId, RequestEntityCopyRequest requestEntityCopyRequest) {
        log.debug("Check if request with requestId {} exists in project {}", (Object)requestId, (Object)requestEntityCopyRequest.getProjectId());
        Request request = (Request)this.get(requestId);
        Request copyRequest = RequestUtils.copyRequestFromRequest(request);
        UUID targetFolderId = requestEntityCopyRequest.getFolderId();
        Folder targetFolder = targetFolderId == null ? null : this.folderService.getFolder(targetFolderId);
        this.setFolderFields(copyRequest, targetFolder);
        this.setOrder(copyRequest);
        log.debug("Get requests by folder id {}", (Object)targetFolderId);
        List<Request> folderRequests = this.requestRepository.findAllByProjectIdAndFolderId(requestEntityCopyRequest.getProjectId(), requestEntityCopyRequest.getFolderId());
        this.addPostfixIfNameIsTaken(folderRequests, copyRequest);
        this.folderService.updateAuthorizationFolderId(copyRequest);
        Request savedRequest = this.save(copyRequest);
        HttpRequest savedHttpRequest = (HttpRequest)savedRequest;
        if (Objects.nonNull(savedHttpRequest.getBody())) {
            if (RequestBodyType.Binary.equals((Object)savedHttpRequest.getBody().getType())) {
                try {
                    Optional<FileBody> fileInfo = this.itfLiteFileService.copyFileForCopiedRequest(requestId, request.getModifiedWhen(), savedRequest.getId(), Constants.DEFAULT_BINARY_FILES_FOLDER);
                    if (fileInfo.isPresent()) {
                        savedHttpRequest.getBody().setBinaryBody(fileInfo.get());
                        savedRequest = this.save(savedHttpRequest);
                    }
                }
                catch (IOException e) {
                    log.error("File wasn't copied for request {}", (Object)savedRequest.getId(), (Object)e);
                }
            } else if (RequestBodyType.FORM_DATA.equals((Object)savedHttpRequest.getBody().getType()) && !CollectionUtils.isEmpty(savedHttpRequest.getBody().getFormDataBody())) {
                this.copyFormDataFiles(savedHttpRequest.getBody().getFormDataBody(), savedHttpRequest.getId());
                savedRequest = this.save(savedHttpRequest);
            }
        }
        return savedRequest;
    }

    private void copyFormDataFiles(List<FormDataPart> formData, UUID newRequestId) {
        formData.stream().filter(fdp -> ValueType.FILE.equals((Object)fdp.getType()) && Objects.nonNull(fdp.getFileId())).forEach(fdp -> fdp.setFileId(this.gridFsService.copyFileById(fdp.getFileId(), newRequestId)));
    }

    @Transactional
    public void copyRequests(RequestEntitiesCopyRequest requestEntitiesCopyRequest) {
        UUID projectId = requestEntitiesCopyRequest.getProjectId();
        Set<UUID> requestIds = requestEntitiesCopyRequest.getRequestIds();
        log.debug("Check if requests with requestIds {} exist in project {}", requestIds, (Object)projectId);
        List<Request> requests = this.requestRepository.findAllByProjectIdAndIdIn(projectId, requestIds);
        log.debug("Get requests by folder id {}", (Object)requestEntitiesCopyRequest.getFolderId());
        UUID targetFolderId = requestEntitiesCopyRequest.getFolderId();
        List<Request> folderRequests = this.requestRepository.findAllByProjectIdAndFolderId(requestEntitiesCopyRequest.getProjectId(), targetFolderId);
        Folder targetFolder = targetFolderId == null ? null : this.folderService.getFolder(targetFolderId);
        Set<UUID> foundRequestIds = StreamUtils.extractIds(requests);
        ArrayList<Request> copyRequests = new ArrayList<Request>();
        for (Request request : requests) {
            MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)request.getId());
            Request copiedRequest = RequestUtils.copyRequestFromRequest(request);
            this.setFolderFields(copiedRequest, targetFolder);
            this.addPostfixIfNameIsTaken(folderRequests, copiedRequest);
            if (TransportType.REST.equals((Object)request.getTransportType()) && ((HttpRequest)request).getBody() != null) {
                HttpRequest savedRequest;
                HttpRequest httpRequest = (HttpRequest)request;
                HttpRequest httpCopiedRequest = (HttpRequest)copiedRequest;
                if (RequestBodyType.Binary.equals((Object)httpRequest.getBody().getType())) {
                    this.setOrder(httpCopiedRequest);
                    savedRequest = (HttpRequest)this.save(httpCopiedRequest);
                    try {
                        log.info("Coping request with binary file {} to folder {}", (Object)request.getId(), (Object)requestEntitiesCopyRequest.getFolderId());
                        Optional<FileBody> fileInfo = this.itfLiteFileService.copyFileForCopiedRequest(request.getId(), request.getModifiedWhen(), savedRequest.getId(), Constants.DEFAULT_BINARY_FILES_FOLDER);
                        if (fileInfo.isPresent()) {
                            savedRequest.getBody().setBinaryBody(fileInfo.get());
                            this.save(savedRequest);
                        }
                    }
                    catch (IOException e) {
                        log.error("File wasn't copied for request {}", (Object)savedRequest.getId(), (Object)e);
                    }
                } else if (RequestBodyType.FORM_DATA.equals((Object)httpCopiedRequest.getBody().getType()) && !CollectionUtils.isEmpty(httpCopiedRequest.getBody().getFormDataBody())) {
                    this.setOrder(httpCopiedRequest);
                    savedRequest = (HttpRequest)this.save(httpCopiedRequest);
                    this.copyFormDataFiles(savedRequest.getBody().getFormDataBody(), savedRequest.getId());
                    this.save(savedRequest);
                } else {
                    copyRequests.add(copiedRequest);
                }
            }
            MDC.remove((String)ItfLiteMdcField.REQUEST_ID.toString());
        }
        copyRequests.forEach(req -> {
            this.setOrder((Request)req);
            this.folderService.updateAuthorizationFolderId((Request)req);
        });
        log.info("Coping requests [{}] to folder {}", foundRequestIds, (Object)requestEntitiesCopyRequest.getFolderId());
        this.saveAll(copyRequests);
    }

    public UUID copyDictionary(UUID fromRequestId, UUID toRequestId) {
        Optional<FileData> dictionary = this.gridFsService.downloadFile(fromRequestId);
        if (dictionary.isPresent()) {
            ByteArrayInputStream dictionaryInputStream = new ByteArrayInputStream(dictionary.get().getContent());
            return this.gridFsService.saveDictionaryByRequestId(LocalDateTime.now().toString(), toRequestId, dictionaryInputStream, dictionary.get().getFileName());
        }
        return null;
    }

    public Request moveRequest(UUID requestId, RequestEntityMoveRequest requestEntityMoveRequest) {
        log.debug("Check if request with requestId {} exists in project {}", (Object)requestId, (Object)requestEntityMoveRequest.getProjectId());
        Request request = (Request)this.get(requestId);
        UUID targetFolderId = requestEntityMoveRequest.getFolderId();
        Folder targetFolder = targetFolderId == null ? null : this.folderService.getFolder(targetFolderId);
        this.setFolderFields(request, targetFolder);
        this.setOrder(request);
        this.folderService.updateAuthorizationFolderId(request);
        return this.save(request);
    }

    @Transactional
    public void moveRequests(RequestEntitiesMoveRequest requestEntityMoveRequest) {
        UUID projectId = requestEntityMoveRequest.getProjectId();
        Set<UUID> requestIds = StreamUtils.extractIds(requestEntityMoveRequest.getRequestIds(), IdWithModifiedWhen::getId);
        log.debug("Check if requests with requestIds {} exist in project {}", requestIds, (Object)projectId);
        List<Request> requests = this.requestRepository.findAllByProjectIdAndIdIn(projectId, requestIds);
        UUID targetFolderId = requestEntityMoveRequest.getFolderId();
        Folder targetFolder = targetFolderId == null ? null : this.folderService.getFolder(targetFolderId);
        requests.forEach(request -> {
            this.setFolderFields((Request)request, targetFolder);
            this.setOrder((Request)request);
            this.folderService.updateAuthorizationFolderId((Request)request);
        });
        Set<UUID> foundRequestIds = StreamUtils.extractIds(requests);
        log.info("Moving requests [{}] to folder {}", foundRequestIds, (Object)requestEntityMoveRequest.getFolderId());
        this.saveAll(requests);
    }

    private void setFolderFields(Request request, Folder folder) {
        request.setFolderId(folder == null ? null : folder.getId());
        request.setPermissionFolderId(folder == null ? null : folder.getPermissionFolderId());
    }

    @Transactional
    public void deleteRequest(UUID requestId) {
        log.debug("Check that request with requestId {} exists", (Object)requestId);
        Request request = (Request)this.get(requestId);
        this.delete(request);
        log.debug("Delete files from gridFs by request id {}", (Object)requestId);
        this.gridFsService.removeAllFilesByRequestId(requestId);
        log.debug("Delete javers history snapshots by request id = {}", (Object)requestId);
        this.deleteHistoryService.deleteSnapshotsByEntityIds(Sets.newHashSet((Object[])new UUID[]{requestId}));
    }

    @Transactional
    public void bulkDeleteRequests(RequestEntitiesBulkDelete requestEntitiesBulkDelete) {
        Set<UUID> requestsAndFoldersUuids = requestEntitiesBulkDelete.getRequestIds();
        log.debug("Check if requests with requestIds {} exist in project", requestsAndFoldersUuids);
        List requestsToDelete = this.requestRepository.findAllById(requestsAndFoldersUuids);
        List<Folder> foldersToDelete = this.folderService.getFoldersByIds(requestsAndFoldersUuids);
        Set<UUID> foundRequestIds = StreamUtils.extractIds(requestsToDelete);
        log.info("Delete requests with ids: {}", foundRequestIds);
        this.deleteByEntities(requestsToDelete);
        Set<UUID> folderIdsToDelete = StreamUtils.extractIds(foldersToDelete);
        log.info("Remove folder with ids: {}", folderIdsToDelete);
        FolderDeleteRequest folderDeleteRequest = new FolderDeleteRequest(folderIdsToDelete, requestEntitiesBulkDelete.getProjectId());
        this.folderService.deleteFolders(folderDeleteRequest);
        foundRequestIds.forEach(id -> {
            log.debug("Delete files from gridFs by request id {}", id);
            this.gridFsService.removeAllFilesByRequestId((UUID)id);
        });
        log.debug("Delete javers history snapshots by request ids: {}", foundRequestIds);
        this.deleteHistoryService.deleteSnapshotsByEntityIds(foundRequestIds);
    }

    public void addPostfixIfNameIsTaken(List<Request> folderRequests, Request request) {
        while (folderRequests.stream().anyMatch(folderRequest -> folderRequest.getName().equals(request.getName()))) {
            request.setName(request.getName() + " Copy");
        }
    }

    public String exportRequest(UUID requestId, UUID environmentId, String context, List<ContextVariable> contextVariables) throws URISyntaxException {
        log.debug("Check if request with requestId {} exists", (Object)requestId);
        Request request = (Request)this.get(requestId);
        try {
            AuthorizationSaveRequest authorization;
            HttpRequestEntitySaveRequest httpRequest = (HttpRequestEntitySaveRequest)this.modelMapper.map((Object)request, HttpRequestEntitySaveRequest.class);
            UUID projectId = request.getProjectId();
            Evaluator evaluator = this.macrosService.createMacrosEvaluator(projectId);
            SaveRequestResolvingContext resolvingContext = SaveRequestResolvingContext.builder().build();
            if (Objects.nonNull(environmentId)) {
                Map<String, Object> environmentVariables = SaveRequestResolvingContext.parseSystems(this.envParamService.getEnvironmentSystemsById(environmentId));
                resolvingContext.setEnvironmentVariables(environmentVariables);
                resolvingContext.getEnvironment().putAll(environmentVariables);
            }
            resolvingContext.parseAndClassifyContextVariables(contextVariables);
            this.templateResolverService.resolveTemplatesWithOrder(httpRequest, resolvingContext, evaluator);
            this.templateResolverService.processEncryptedValues(httpRequest, true);
            RequestBody body = httpRequest.getBody();
            if (body != null && RequestBodyType.Velocity.equals((Object)body.getType())) {
                String response = this.processVelocity(httpRequest.getProjectId(), body.getContent(), context);
                httpRequest.getBody().setContent(response);
            }
            if (Objects.nonNull(authorization = httpRequest.getAuthorization())) {
                this.requestAuthorizationService.processRequestAuthorization(projectId, httpRequest, null, environmentId, evaluator, resolvingContext);
            }
            return this.requestToCurlFormatConverter.convertRequestToCurlStringBuilder(httpRequest);
        }
        catch (AtpException ex) {
            log.error("Failed to export request to cURL format", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Failed to export request to cURL format", (Throwable)ex);
            throw new ItfLiteExportRequestException();
        }
    }

    public Request importRequest(CurlStringImportRequest importRequest) {
        log.debug("Check if request with requestId {} exists", (Object)importRequest.getRequestId());
        Request request = (Request)this.get(importRequest.getRequestId());
        HttpRequest httpRequest = (HttpRequest)request;
        return this.curlFormatToRequestConverter.convertCurlStringToRequest(httpRequest, importRequest.getRequestString());
    }

    public ExecuteStepResponse executeRequestWithRamAdapterLogging(ExecutionCollectionRequestExecuteRequest requestExecuteRequest, Request request, UUID environmentId) {
        Object envId;
        Map<String, Object> context = requestExecuteRequest.getContext();
        UUID testRunId = requestExecuteRequest.getTestRunId();
        if (this.nextRequestService.hasNextRequest(testRunId)) {
            if (this.isRequestMatchesNextRequest(testRunId, request.getId(), request.getName())) {
                this.nextRequestService.deleteNextRequest(testRunId);
            } else {
                log.info("Current request not matched next request - skip execution. (TestRunId: {}, requestId: {})", (Object)testRunId, (Object)request.getId());
                this.ramService.writeMessage("Request execution was skipped because the nextRequest is specified, which does not match the current request", TestingStatuses.SKIPPED);
                return this.createSkippedExecuteStepResponse(context);
            }
        }
        SaveRequestResolvingContext resolvingContext = SaveRequestResolvingContext.builder().globals(SaveRequestResolvingContext.parseScope(context, ContextScope.GLOBALS)).collectionVariables(SaveRequestResolvingContext.parseScope(context, ContextScope.COLLECTION)).environment(SaveRequestResolvingContext.parseScope(context, ContextScope.ENVIRONMENT)).iterationData(SaveRequestResolvingContext.parseScope(context, ContextScope.DATA)).variables(SaveRequestResolvingContext.parseScope(context, ContextScope.LOCAL_VARIABLES)).build();
        if (Objects.nonNull(context) && Objects.nonNull(envId = context.get("ENV_ID"))) {
            List<System> systems = this.envParamService.getEnvironmentSystemsById(UUID.fromString(envId.toString()));
            Map<String, Object> environmentVariables = SaveRequestResolvingContext.parseSystems(systems);
            resolvingContext.setEnvironmentVariables(environmentVariables);
            resolvingContext.getEnvironment().putAll(environmentVariables);
        }
        ExecuteStepResponse response = this.executeRequestWithRamAdapterLogging(requestExecuteRequest, request, environmentId, resolvingContext);
        if (this.nextRequestService.isSubCollectionExists(testRunId)) {
            this.ramService.updateExecutionStatus(requestExecuteRequest, ExecutionStatuses.FINISHED);
            List<ExecuteStepResponse> responses = this.runSubCollection(requestExecuteRequest, environmentId, resolvingContext);
            if (!responses.isEmpty()) {
                response.setContext(responses.get(responses.size() - 1).getContext());
                if (responses.stream().anyMatch(r -> TestingStatuses.FAILED.equals((Object)r.getTestingStatus()))) {
                    response.setTestingStatus(TestingStatuses.FAILED);
                }
            }
        }
        return response;
    }

    private ExecuteStepResponse executeRequestWithRamAdapterLogging(ExecutionCollectionRequestExecuteRequest requestExecuteRequest, Request request, UUID environmentId, SaveRequestResolvingContext resolvingContext) {
        CollectionRunRequest collReq;
        boolean statusPassed;
        UUID testRunId = requestExecuteRequest.getTestRunId();
        if (this.nextRequestService.isExecutionLimitExceeded(testRunId, request.getId())) {
            log.info("Execution count limit was exceeded. Skip collection execution (requestId: {})", (Object)request.getId());
            this.nextRequestService.setNextRequest(testRunId, null);
            this.ramService.writeMessage("Request execution limit has been exceeded. Collection execution skipped", TestingStatuses.SKIPPED);
            return this.createSkippedExecuteStepResponse(resolvingContext.mergeWithScopePrefixes());
        }
        try {
            List<Cookie> cookies;
            HttpRequestEntitySaveRequest httpSaveRequest;
            Object envId;
            UUID transportLogRecordId = UUID.randomUUID();
            RequestEntitySaveRequest saveRequest = (RequestEntitySaveRequest)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)request), RequestEntitySaveRequest.class);
            if (Objects.nonNull(requestExecuteRequest.getContext()) && Objects.nonNull(envId = requestExecuteRequest.getContext().get("ENV_ID"))) {
                saveRequest.setEnvironmentId(UUID.fromString(envId.toString()));
            }
            Optional<Object> file = Objects.nonNull((httpSaveRequest = (HttpRequestEntitySaveRequest)saveRequest).getBody()) && RequestBodyType.Binary.equals((Object)httpSaveRequest.getBody().getType()) ? this.itfLiteFileService.getFileAsMultipartFileByRequestId(saveRequest.getId(), request.getModifiedWhen(), Constants.DEFAULT_BINARY_FILES_FOLDER) : Optional.empty();
            if (!httpSaveRequest.isAutoCookieDisabled()) {
                httpSaveRequest.setCookies(this.cookieService.getAllByExecutionRequestIdAndTestRunId(requestExecuteRequest.getExecutionRequestId(), requestExecuteRequest.getTestRunId()));
            }
            TriConsumer afterRestExecution = (req, resp, error) -> {
                TestingStatuses status = error == null ? TestingStatuses.PASSED : TestingStatuses.FAILED;
                this.ramService.writeRequestExecutionResult(transportLogRecordId, (RequestEntitySaveRequest)req, (RequestExecutionResponse)resp, (Exception)error, status);
            };
            BiFunction<PostmanExecuteScriptResponseDto, Boolean, JsExecutionResult> scriptExecution = this.ramService::writeTestsResults;
            BiConsumer<RequestEntitySaveRequest, List<ConsoleLogDto>> logConsoleLogs = (req, consoleLogs) -> {
                String prescript = req == null || req.getPreScripts() == null ? "" : req.getPreScripts();
                String postscript = req == null || req.getPostScripts() == null ? "" : req.getPostScripts();
                this.ramService.writeConsoleLogs(transportLogRecordId, prescript, postscript, (List<ConsoleLogDto>)consoleLogs);
            };
            Function<RequestExecutionResponse, UUID> setExecutionId = resp -> transportLogRecordId;
            RequestExecutionResponse response = this.executeRequest(saveRequest, null, file, resolvingContext, (TriConsumer<RequestEntitySaveRequest, RequestExecutionResponse, Exception>)afterRestExecution, scriptExecution, environmentId, null, setExecutionId, logConsoleLogs, this.getRuntimeOptions(request), this.getUpdateNextRequestFunc(testRunId));
            statusPassed = response.isTestsPassed();
            if (!request.isAutoCookieDisabled() && saveRequest instanceof HttpRequestEntitySaveRequest && !CollectionUtils.isEmpty(cookies = saveRequest.getCookies())) {
                this.cookieService.fillCookieInfoWithExecutionRequestInfo(cookies, requestExecuteRequest.getExecutionRequestId(), requestExecuteRequest.getTestRunId());
                this.cookieService.deleteByExecutionRequestIdAndTestRunId(requestExecuteRequest.getExecutionRequestId(), requestExecuteRequest.getTestRunId());
                this.cookieService.save(cookies);
            }
        }
        catch (Exception e) {
            statusPassed = false;
            log.error("Request execution failed: (RequestId: {})", (Object)request.getId(), (Object)e);
        }
        this.nextRequestPostProcess(testRunId, request.getId(), request.getName());
        if (this.nextRequestService.hasNextRequest(testRunId) && Objects.nonNull(collReq = this.nextRequestService.findInCollectionOrderNextRequest(testRunId))) {
            log.info("Next request is found among already executed requests. (NextRequest: {})", (Object)collReq);
            this.nextRequestService.deleteNextRequest(testRunId);
            this.nextRequestService.createNewSubCollection(testRunId, collReq);
        }
        return this.createExecuteStepResponse(requestExecuteRequest, resolvingContext, statusPassed);
    }

    private boolean isRequestMatchesNextRequest(UUID testRunId, UUID currentRequestId, String currentRequestName) {
        String nextRequest = this.nextRequestService.getNextRequest(testRunId);
        if (Objects.isNull(nextRequest)) {
            return false;
        }
        return currentRequestName.equals(nextRequest) || currentRequestId.toString().equals(nextRequest);
    }

    private void nextRequestPostProcess(UUID testRunId, UUID requestId, String requestName) {
        this.nextRequestService.addRequestToCollectionOrder(testRunId, requestId, requestName);
        this.nextRequestService.incrementExecutionCount(testRunId, requestId);
    }

    private List<ExecuteStepResponse> runSubCollection(ExecutionCollectionRequestExecuteRequest requestExecuteRequest, UUID environmentId, SaveRequestResolvingContext resolvingContext) {
        UUID testRunId = requestExecuteRequest.getTestRunId();
        log.debug("Execute sub collection from stack");
        ArrayList<ExecuteStepResponse> responses = new ArrayList<ExecuteStepResponse>();
        CollectionRunStackRequest requestFromStack = this.nextRequestService.pop(testRunId);
        while (Objects.nonNull(requestFromStack)) {
            Long createdDateStamp = requestExecuteRequest.getSection().getCreatedDateStamp();
            Long newCreatedDateStamp = (Objects.nonNull(createdDateStamp) ? createdDateStamp : 0L) + 1L;
            requestExecuteRequest.getSection().setCreatedDateStamp(newCreatedDateStamp);
            Request nextRequest = (Request)this.get(requestFromStack.getRequestId());
            this.ramService.openNewExecuteRequestSection(nextRequest.getName(), newCreatedDateStamp);
            requestExecuteRequest.setContext(resolvingContext.mergeWithScopePrefixes());
            responses.add(this.executeRequestWithRamAdapterLogging(requestExecuteRequest, nextRequest, environmentId, resolvingContext));
            this.ramService.closeCurrentSection(requestExecuteRequest.getContext(), resolvingContext.mergeWithScopePrefixes());
            requestFromStack = this.nextRequestService.pop(testRunId);
        }
        return responses;
    }

    private RequestRuntimeOptions getRuntimeOptions(Request request) {
        return new RequestRuntimeOptions(request.isDisableSslCertificateVerification(), request.isDisableSslClientCertificate(), request.isDisableFollowingRedirect(), request.isDisableAutoEncoding());
    }

    private ExecuteStepResponse createExecuteStepResponse(ExecutionCollectionRequestExecuteRequest requestExecuteRequest, SaveRequestResolvingContext resolvingContext, boolean isPassed) {
        ExecuteStepResponse executeStepResponse = new ExecuteStepResponse();
        executeStepResponse.setStatus(ExecutionStatuses.FINISHED);
        executeStepResponse.setTestingStatus(isPassed ? TestingStatuses.PASSED : TestingStatuses.FAILED);
        if (Objects.nonNull(requestExecuteRequest.getContext()) && Objects.nonNull(resolvingContext)) {
            ContextEntity context = new ContextEntity();
            try {
                context.setJsonString(this.objectMapper.writeValueAsString(resolvingContext.mergeWithScopePrefixes()));
                executeStepResponse.setContext(context);
            }
            catch (JsonProcessingException e) {
                log.error("Failed parse context (RequestId: {})", (Object)requestExecuteRequest.getExecutionRequestId(), (Object)e);
            }
        }
        return executeStepResponse;
    }

    private ExecuteStepResponse createSkippedExecuteStepResponse(Map<String, Object> contextVariables) {
        ExecuteStepResponse executeStepResponse = new ExecuteStepResponse();
        executeStepResponse.setStatus(ExecutionStatuses.FINISHED);
        executeStepResponse.setTestingStatus(TestingStatuses.SKIPPED);
        ContextEntity context = new ContextEntity();
        try {
            context.setJsonString(this.objectMapper.writeValueAsString(contextVariables));
            executeStepResponse.setContext(context);
        }
        catch (JsonProcessingException e) {
            log.error("Failed parse context", (Throwable)e);
        }
        return executeStepResponse;
    }

    public RequestExecutionResponse executeRequest(RequestEntitySaveRequest request, String context, String token, UUID sseId, Optional<MultipartFile> file, UUID environmentId, List<FileData> fileDataList) throws Exception {
        return this.executeRequest(request, context, token, sseId, file, environmentId, fileDataList, new RequestRuntimeOptions());
    }

    public RequestExecutionResponse executeRequest(RequestEntitySaveRequest request, String context, String token, UUID sseId, Optional<MultipartFile> file, UUID environmentId, List<FileData> fileDataList, RequestRuntimeOptions runtimeOptions) throws Exception {
        SaveRequestResolvingContext resolvingContext = SaveRequestResolvingContext.builder().build();
        resolvingContext.parseAndClassifyContextVariables(request.getContextVariables());
        if (Objects.nonNull(environmentId)) {
            List<System> systems = this.envParamService.getEnvironmentSystemsById(environmentId);
            Map<String, Object> environmentVariables = SaveRequestResolvingContext.parseSystems(systems);
            resolvingContext.setEnvironmentVariables(environmentVariables);
            resolvingContext.getEnvironment().putAll(environmentVariables);
        }
        UUID projectId = request.getProjectId();
        if (request instanceof HttpRequestEntitySaveRequest) {
            HttpRequestEntitySaveRequest httpRequest = (HttpRequestEntitySaveRequest)request;
            if (!request.isAutoCookieDisabled()) {
                httpRequest.setCookies(this.cookieService.getNotExpiredCookiesByUserIdAndProjectId(projectId));
            }
            httpRequest.getRequestHeaders().removeIf(header -> header.isGenerated() && "Authorization".equals(header.getKey()));
        }
        TriConsumer afterExecution = (req, resp, error) -> this.executionHistoryService.logRequestExecution(token, sseId, (RequestEntitySaveRequest)req, (RequestExecutionResponse)resp, (Exception)error, fileDataList);
        BiFunction<PostmanExecuteScriptResponseDto, Boolean, JsExecutionResult> scriptExecution = (scriptResults, isPreScript) -> this.executionHistoryService.logRequestJsExecution(token, sseId, request, (PostmanExecuteScriptResponseDto)scriptResults, (boolean)isPreScript);
        BiConsumer<RequestEntitySaveRequest, List<ConsoleLogDto>> logConsoleLogs = (req, consoleLogs) -> {
            RequestExecutionDetails details;
            Optional<RequestExecutionDetails> detailsOptional = this.detailsRepository.findByRequestExecutionSseId(sseId);
            if (detailsOptional.isPresent()) {
                details = detailsOptional.get();
            } else {
                log.warn("Details information for request id {} not found by SSE ID {}. Generate new details.", (Object)req.getId(), (Object)sseId);
                details = this.executionHistoryService.generateAndConfigureRequestExecutionDetails(request, token, sseId);
            }
            details.setConsoleLogs((List<ConsoleLogDto>)consoleLogs);
            this.detailsRepository.save(details);
        };
        Function<RequestExecutionResponse, UUID> setExecutionId = resp -> {
            RequestExecutionDetails details;
            Optional<RequestExecutionDetails> detailsOptional = this.detailsRepository.findByRequestExecutionSseId(sseId);
            if (detailsOptional.isPresent()) {
                details = detailsOptional.get();
            } else {
                log.warn("Details information for request id {} not found by SSE ID {}. Generate new details.", (Object)request.getId(), (Object)sseId);
                details = this.executionHistoryService.generateAndConfigureRequestExecutionDetails(request, token, sseId);
                this.detailsRepository.save(details);
            }
            return details.getRequestExecution().getId();
        };
        RequestExecutionResponse response = this.executeRequest(request, context, file, resolvingContext, (TriConsumer<RequestEntitySaveRequest, RequestExecutionResponse, Exception>)afterExecution, scriptExecution, environmentId, fileDataList, setExecutionId, logConsoleLogs, runtimeOptions, ignore -> {});
        response.parseAndSetContextVariables(resolvingContext);
        RequestExecutionDetails details = this.detailsRepository.findByRequestExecutionSseId(sseId).orElseGet(() -> {
            log.warn("Details information for request id {} not found by SSE ID {}. Generate new details.", (Object)request.getId(), (Object)sseId);
            return this.executionHistoryService.generateAndConfigureRequestExecutionDetails(request, token, sseId);
        });
        details.setContextVariables(response.getContextVariables());
        if (request instanceof HttpRequestEntitySaveRequest) {
            HttpRequestEntitySaveRequest httpRequest = (HttpRequestEntitySaveRequest)request;
            List<Cookie> cookies = request.getCookies();
            if (!CollectionUtils.isEmpty(cookies)) {
                if (!request.isAutoCookieDisabled()) {
                    this.cookieService.fillCookieInfo(cookies, projectId);
                    this.cookieService.deleteByUserIdAndProjectId(projectId);
                    List<Cookie> savedCookies = this.cookieService.save(cookies);
                    try {
                        URI uri = new URI(httpRequest.getUrl());
                        HttpHeaderSaveRequest cookieHeader = this.cookieService.cookieListToRequestHeader(uri, savedCookies);
                        if (StringUtils.isNotEmpty((String)cookieHeader.getValue())) {
                            response.setCookieHeader(cookieHeader);
                            details.setCookieHeader(cookieHeader);
                        }
                    }
                    catch (URISyntaxException ignore2) {
                        log.debug("Syntax exception", (Throwable)ignore2);
                    }
                }
                response.setCookies(CookieUtils.convertCookieListToResponseCookieList(this.cookieService.filterCookie(httpRequest.getUrl(), cookies)));
                details.setCookies(response.getCookies());
            }
        }
        this.detailsRepository.save(details);
        log.debug("Response to return: {}, and final details saved {}", (Object)response, (Object)details);
        return response;
    }

    private RequestExecutionResponse executeRequest(RequestEntitySaveRequest request, String context, Optional<MultipartFile> file, SaveRequestResolvingContext resolvingContext, TriConsumer<RequestEntitySaveRequest, RequestExecutionResponse, Exception> afterExecution, BiFunction<PostmanExecuteScriptResponseDto, Boolean, JsExecutionResult> scriptExecution, UUID environmentId, List<FileData> fileDataList, Function<RequestExecutionResponse, UUID> setExecutionId, BiConsumer<RequestEntitySaveRequest, List<ConsoleLogDto>> logConsoleLogs) {
        return this.executeRequest(request, context, file, resolvingContext, afterExecution, scriptExecution, environmentId, fileDataList, setExecutionId, logConsoleLogs, new RequestRuntimeOptions(), ignore -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestExecutionResponse executeRequest(RequestEntitySaveRequest request, String context, Optional<MultipartFile> file, SaveRequestResolvingContext resolvingContext, TriConsumer<RequestEntitySaveRequest, RequestExecutionResponse, Exception> afterExecution, BiFunction<PostmanExecuteScriptResponseDto, Boolean, JsExecutionResult> scriptExecution, UUID environmentId, List<FileData> fileDataList, Function<RequestExecutionResponse, UUID> setExecutionId, BiConsumer<RequestEntitySaveRequest, List<ConsoleLogDto>> logConsoleLogs, RequestRuntimeOptions runtimeOptions, Consumer<PostmanExecuteScriptResponseDto> updateNextRequest) {
        RequestExecutionResponse response = new RequestExecutionResponse();
        response.setStartedWhen(new Date());
        UUID projectId = request.getProjectId();
        Stopwatch timer = Stopwatch.createStarted();
        TransportType transportType = request.getTransportType();
        file.ifPresent(multipartFile -> ((HttpRequestEntitySaveRequest)request).setFile(new FileData(null, multipartFile.getOriginalFilename())));
        if (CollectionUtils.isEmpty(fileDataList)) {
            fileDataList = this.gridFsService.getFilesDataByRequestId(request.getId());
        } else {
            List<FileData> finalFileDataListForFiltering = fileDataList;
            List gridFsFileDatas = this.gridFsService.getFilesDataByRequestId(request.getId()).stream().filter(fileData -> finalFileDataListForFiltering.stream().noneMatch(receivedFileData -> receivedFileData.getFileName().equals(fileData.getFileName()))).collect(Collectors.toList());
            fileDataList.addAll(gridFsFileDatas);
        }
        this.validateRequestSizeLimits(request, transportType, file, fileDataList);
        Evaluator evaluator = this.macrosService.createMacrosEvaluator(request.getProjectId());
        AtpException errorMessage = null;
        RequestEntitySaveRequest requestForHistory = request;
        List<Object> consoleLogs = null;
        try {
            PostmanExecuteScriptResponseDto scriptResponseDto;
            JsExecutionResult jsResult = null;
            try {
                request.normalize();
                scriptResponseDto = this.scriptService.evaluateRequestPreScript(request, resolvingContext);
                jsResult = scriptExecution.apply(scriptResponseDto, true);
                updateNextRequest.accept(scriptResponseDto);
                if (!jsResult.isPassed()) {
                    throw this.getExceptionIfScriptEngineScriptResultIsNotPassed(scriptResponseDto, true);
                }
                this.templateResolverService.resolveTemplatesWithOrder(request, resolvingContext, evaluator);
                requestForHistory = this.generateRequestForHistory(request);
                this.templateResolverService.processEncryptedValues(request, false);
                this.templateResolverService.processEncryptedValues(requestForHistory, true);
                consoleLogs = jsResult.getConsoleLogs();
                RequestPreExecuteResponse requestPreExecuteResponse = this.preExecuteProcessing(projectId, request, requestForHistory, environmentId, resolvingContext, evaluator);
                this.addCookieHeader(request);
                response = this.executeRequest(request, context, resolvingContext, file, fileDataList, runtimeOptions);
                response.setTestsPassed(true);
            }
            catch (AtpException ex) {
                errorMessage = ex;
                throw ex;
            }
            finally {
                this.updateRequestForHistory(request, requestForHistory);
                afterExecution.accept((Object)requestForHistory, (Object)response, (Object)errorMessage);
                response.setExecutionId(setExecutionId.apply(response));
            }
            this.validateResponseAndPostScriptSizeLimits(response, request.getPostScripts());
            scriptResponseDto = this.scriptService.evaluateRequestPostScript(request, response, resolvingContext);
            jsResult = scriptExecution.apply(scriptResponseDto, false);
            updateNextRequest.accept(scriptResponseDto);
            response.setTestsPassed(jsResult.isPassed());
            if (!jsResult.isPassed()) {
                ItfLiteException postScriptException = this.getExceptionIfScriptEngineScriptResultIsNotPassed(scriptResponseDto, false);
                response.setError(RequestUtils.getErrorResponse((Exception)((Object)postScriptException)));
            }
            if (jsResult.getConsoleLogs() != null) {
                if (consoleLogs == null) {
                    consoleLogs = jsResult.getConsoleLogs();
                } else {
                    consoleLogs.addAll(jsResult.getConsoleLogs());
                }
            }
        }
        finally {
            if (consoleLogs == null) {
                consoleLogs = new ArrayList();
            }
            logConsoleLogs.accept(requestForHistory, consoleLogs);
            this.addTimeMetric(transportType, projectId, timer);
        }
        return response;
    }

    private RequestExecutionResponse executeRequest(RequestEntitySaveRequest request, String context, SaveRequestResolvingContext resolvingContext, Optional<MultipartFile> file, List<FileData> fileDataList, RequestRuntimeOptions runtimeOptions) {
        TransportType transportType = request.getTransportType();
        try {
            return this.prepareAndExecuteHttpRequest((HttpRequestEntitySaveRequest)request, context, resolvingContext, file, fileDataList, runtimeOptions);
        }
        catch (AtpException ex) {
            log.error("Exception during request execution", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Exception during request execution", (Throwable)ex);
            throw new ItfLiteException(ex.getMessage());
        }
    }

    private void validateRequestSizeLimits(RequestEntitySaveRequest request, TransportType transportType, Optional<MultipartFile> file, List<FileData> fileDataList) {
        HttpRequestEntitySaveRequest httpRequestEntitySaveRequest = (HttpRequestEntitySaveRequest)request;
        byte[] serializedHttpRequestEntitySaveRequest = SerializationUtils.serialize((Object)httpRequestEntitySaveRequest);
        long requestWithoutPostScriptSize = 0L;
        if (Objects.nonNull(serializedHttpRequestEntitySaveRequest)) {
            requestWithoutPostScriptSize = serializedHttpRequestEntitySaveRequest.length;
        } else {
            log.warn("Can't serialize http request entity save for request {}", (Object)request.getId());
        }
        if (Objects.nonNull(httpRequestEntitySaveRequest.getPostScripts())) {
            byte[] serializedPostScripts = SerializationUtils.serialize((Object)httpRequestEntitySaveRequest.getPostScripts());
            long postScriptsSizeInBytes = 0L;
            if (Objects.nonNull(serializedPostScripts)) {
                postScriptsSizeInBytes = serializedPostScripts.length;
            } else {
                log.warn("Can't serialize post scripts for request {}", (Object)request.getId());
            }
            requestWithoutPostScriptSize -= postScriptsSizeInBytes;
        }
        if (!CollectionUtils.isEmpty(fileDataList)) {
            byte[] serializedFileDataList = SerializationUtils.serialize(fileDataList);
            if (Objects.nonNull(serializedFileDataList)) {
                requestWithoutPostScriptSize += (long)serializedFileDataList.length;
            } else {
                log.warn("Can't serialize file data list for request {}", (Object)request.getId());
            }
        }
        if (file != null && file.isPresent()) {
            try {
                requestWithoutPostScriptSize += (long)file.get().getBytes().length;
            }
            catch (IOException exception) {
                log.warn("Can't get bytes for binary file for request {}", (Object)request.getId(), (Object)exception);
            }
        }
        if (this.isNotEntityContentMeetLimit(requestWithoutPostScriptSize, true)) {
            ItfLiteRequestSizeLimitException exception = new ItfLiteRequestSizeLimitException();
            log.error("Request and pre-script are bigger than ITF-Lite's configured limit = {} Mb", (Object)this.requestResponseSizeProperties.getRequestSizeLimitInMb(), (Object)exception);
            throw exception;
        }
    }

    private void validateResponseAndPostScriptSizeLimits(RequestExecutionResponse response, String postScripts) {
        byte[] serializedResponse = SerializationUtils.serialize((Object)response);
        long responseAndPostScriptSize = 0L;
        if (Objects.nonNull(serializedResponse)) {
            responseAndPostScriptSize = serializedResponse.length;
        } else {
            log.warn("Can't serialize response with id = {}", (Object)response.getId());
        }
        if (StringUtils.isNotEmpty((String)postScripts)) {
            byte[] serializedPostScripts = SerializationUtils.serialize((Object)postScripts);
            long postScriptsSize = 0L;
            if (Objects.nonNull(serializedPostScripts)) {
                postScriptsSize = serializedPostScripts.length;
            } else {
                log.warn("Can't serialize post scripts with response id = {}", (Object)response.getId());
            }
            responseAndPostScriptSize += postScriptsSize;
        }
        if (this.isNotEntityContentMeetLimit(responseAndPostScriptSize, false)) {
            ItfLiteResponseSizeLimitException exception = new ItfLiteResponseSizeLimitException();
            log.error("Response and post-script are bigger than ITF-Lite's configured limit = {} Mb", (Object)this.requestResponseSizeProperties.getResponseSizeLimitInMb(), (Object)exception);
            throw exception;
        }
    }

    private Consumer<PostmanExecuteScriptResponseDto> getUpdateNextRequestFunc(UUID testRunId) {
        return scriptExecResp -> {
            if (Objects.nonNull(scriptExecResp) && scriptExecResp.getHasNextRequest().booleanValue()) {
                this.nextRequestService.setNextRequest(testRunId, scriptExecResp.getNextRequest());
            }
        };
    }

    private ItfLiteException getExceptionIfScriptEngineScriptResultIsNotPassed(PostmanExecuteScriptResponseDto scriptResponseDto, boolean isPreScript) {
        ItfLiteException exception = null;
        exception = isPreScript ? new ItfLiteScriptEnginePreScriptExecutionException() : new ItfLiteScriptEnginePostScriptExecutionException();
        if (!CollectionUtils.isEmpty(scriptResponseDto.getTestResults())) {
            PostmanExecuteScriptResponseTestResultsInnerErrorDto scriptResponseErrorDto = scriptResponseDto.getTestResults().get(0).getError();
            exception = isPreScript ? new ItfLiteScriptEnginePreScriptExecutionException(scriptResponseErrorDto.getMessage()) : null;
            HttpResponseExceptionTypeEnum exceptionTypeDto = scriptResponseErrorDto.getHttpResponseExceptionType();
            if (Objects.isNull((Object)exceptionTypeDto)) {
                log.warn("Exception type not specified");
                return exception;
            }
            ScriptEngineExceptionType exceptionType = ScriptEngineExceptionType.valueOf(exceptionTypeDto.getValue());
            if (ScriptEngineExceptionType.DECRYPT_EXCEPTION.equals((Object)exceptionType)) {
                exception = new ItfLiteScriptEngineAtpDecryptException(scriptResponseErrorDto.getMessage());
            } else if (ScriptEngineExceptionType.ENCRYPT_EXCEPTION.equals((Object)exceptionType)) {
                exception = new ItfLiteScriptEngineAtpEncryptException(scriptResponseErrorDto.getMessage());
            } else if (ScriptEngineExceptionType.UNAVAILABLE_EXCEPTION.equals((Object)exceptionType)) {
                exception = new ItfLiteScriptEngineUnavailableException();
            } else if (ScriptEngineExceptionType.POSTMAN_SANDBOX_CONTEXT_EXCEPTION.equals((Object)exceptionType)) {
                exception = new ItfLiteScriptEnginePostmanSandboxContextException();
            }
        }
        return exception;
    }

    private RequestPreExecuteResponse preExecuteProcessing(UUID projectId, RequestEntitySaveRequest request, RequestEntitySaveRequest historyRequest, UUID environmentId, SaveRequestResolvingContext resolvingContext, Evaluator evaluator) {
        if (request instanceof HttpRequestEntitySaveRequest && historyRequest instanceof HttpRequestEntitySaveRequest) {
            return this.httpRequestPreExecuteProcessing(projectId, (HttpRequestEntitySaveRequest)request, (HttpRequestEntitySaveRequest)historyRequest, environmentId, resolvingContext, evaluator);
        }
        return RequestPreExecuteResponse.builder().build();
    }

    private RequestPreExecuteResponse httpRequestPreExecuteProcessing(UUID projectId, HttpRequestEntitySaveRequest request, HttpRequestEntitySaveRequest historyRequest, UUID environmentId, SaveRequestResolvingContext resolvingContext, Evaluator evaluator) {
        String authToken = null;
        try {
            authToken = this.requestAuthorizationService.processRequestAuthorization(projectId, request, historyRequest, environmentId, evaluator, resolvingContext);
        }
        catch (AtpException ex) {
            log.error("Exception during request authorization processing", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Exception during request authorization processing", (Throwable)ex);
            throw new ItfLiteException(ex.getMessage());
        }
        return RequestPreExecuteResponse.builder().authToken(authToken).build();
    }

    private void addCookieHeader(RequestEntitySaveRequest request) {
        HttpRequestEntitySaveRequest httpRequest;
        if (request instanceof HttpRequestEntitySaveRequest && !request.isAutoCookieDisabled() && !CollectionUtils.isEmpty((httpRequest = (HttpRequestEntitySaveRequest)request).getCookies())) {
            try {
                URI uri = new URI(httpRequest.getUrl());
                HttpHeaderSaveRequest cookieHeader = this.cookieService.cookieListToRequestHeader(uri, httpRequest.getCookies());
                if (cookieHeader != null && !StringUtils.isEmpty((String)cookieHeader.getValue())) {
                    httpRequest.getRequestHeaders().add(0, cookieHeader);
                }
            }
            catch (URISyntaxException ignore) {
                log.debug("Syntax exception", (Throwable)ignore);
            }
        }
    }

    private RequestExecutionResponse prepareAndExecuteHttpRequest(HttpRequestEntitySaveRequest request, String context, SaveRequestResolvingContext resolvingContext, Optional<MultipartFile> binaryFile, List<FileData> fileDataList, RequestRuntimeOptions runtimeOptions) {
        this.updateSaveRequestHeadersFields(request.getRequestHeaders());
        this.updateSaveRequestParametersFields(request.getRequestParams());
        if (request.getBody() != null && RequestBodyType.GraphQL.equals((Object)request.getBody().getType())) {
            request.getBody().computeAndSetContent();
        }
        UUID projectId = request.getProjectId();
        try {
            RequestExecutionResponse response = this.executeHttpRequest(projectId, request, context, binaryFile, resolvingContext, fileDataList, runtimeOptions);
            if (Objects.isNull(request.getCookies())) {
                request.setCookies(new ArrayList<Cookie>());
            }
            request.setCookies(CookieUtils.addResponseCookie(request.getCookies(), response.getCookies()));
            return response;
        }
        catch (AtpException exception) {
            log.error("Failed to execute http request '{}'", (Object)request.getId(), (Object)exception);
            throw exception;
        }
        catch (HttpClientErrorException httpClientErrorException) {
            log.error("Failed to execute http request '{}'", (Object)request.getId(), (Object)httpClientErrorException);
            throw new ItfLiteHttpRequestExecuteException(httpClientErrorException);
        }
        catch (InvocationTargetException exception) {
            log.error("Failed to execute http request '{}'", (Object)request.getId(), (Object)exception.getTargetException());
            throw new ItfLiteHttpRequestExecuteException(exception.getTargetException());
        }
        catch (Exception ex) {
            log.error("Failed to execute http request '{}'", (Object)request.getId(), (Object)ex);
            throw new ItfLiteHttpRequestExecuteException(ex);
        }
    }

    private void addTimeMetric(TransportType type, UUID projectId, Stopwatch timer) {
        this.metricService.timer("atp.requests.duration", "project_id", projectId.toString(), "type", type.name().toLowerCase(Locale.US)).record(timer.elapsed());
        timer.stop();
    }

    RequestEntitySaveRequest generateRequestForHistory(RequestEntitySaveRequest request) {
        try {
            RequestEntitySaveRequest requestForHistoryDeepCopy = (RequestEntitySaveRequest)this.modelMapper.map((Object)request, request.getClass());
            if (request instanceof HttpRequestEntitySaveRequest) {
                HttpRequestEntitySaveRequest httpRequestEntitySaveRequest = (HttpRequestEntitySaveRequest)requestForHistoryDeepCopy;
                httpRequestEntitySaveRequest.setRequestParams(httpRequestEntitySaveRequest.getRequestParams().stream().filter(q -> !q.isDisabled()).collect(Collectors.toList()));
                httpRequestEntitySaveRequest.setRequestHeaders(httpRequestEntitySaveRequest.getRequestHeaders().stream().filter(h -> !h.isDisabled()).collect(Collectors.toList()));
                if (Objects.nonNull(httpRequestEntitySaveRequest.getBody())) {
                    if (RequestBodyType.FORM_DATA.equals((Object)httpRequestEntitySaveRequest.getBody().getType())) {
                        if (!CollectionUtils.isEmpty(httpRequestEntitySaveRequest.getBody().getFormDataBody())) {
                            httpRequestEntitySaveRequest.getBody().setFormDataBody(httpRequestEntitySaveRequest.getBody().getFormDataBody().stream().filter(fdp -> !fdp.isDisabled()).collect(Collectors.toList()));
                        }
                    } else if (RequestBodyType.GraphQL.equals((Object)httpRequestEntitySaveRequest.getBody().getType())) {
                        httpRequestEntitySaveRequest.getBody().computeAndSetContent();
                    }
                }
                this.addCookieHeader(httpRequestEntitySaveRequest);
            }
            return requestForHistoryDeepCopy;
        }
        catch (AtpException ex) {
            log.error("Failed to create request for history", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("Failed to create request for history", (Throwable)ex);
            throw new ItfLiteException("Failed to create request for history");
        }
    }

    private void updateRequestForHistory(RequestEntitySaveRequest request, RequestEntitySaveRequest historyRequest) {
        if (request instanceof HttpRequestEntitySaveRequest) {
            if (historyRequest != null) {
                ((HttpRequestEntitySaveRequest)historyRequest).setFile(((HttpRequestEntitySaveRequest)request).getFile());
            }
            log.debug("Copy file data for history request {}", (Object)historyRequest);
        }
    }

    public RequestExecutionResponse executeHttpRequest(UUID projectId, HttpRequestEntitySaveRequest httpRequest, String context, Optional<MultipartFile> binaryFile, SaveRequestResolvingContext resolvingContext, List<FileData> fileNameStreamMap, RequestRuntimeOptions runtimeOptions) throws Exception {
        HttpEntity entity = this.obtainHttpEntity(httpRequest, context, binaryFile, resolvingContext, fileNameStreamMap);
        Header[] headers = this.obtainHttpHeaders(httpRequest);
        HttpMethod method = this.obtainHttpMethod(httpRequest);
        String urlWithParameters = this.createUrlWithParameters(httpRequest, runtimeOptions);
        Date beforeExecutionDate = new Date();
        BasicCookieStore httpCookieStore = new BasicCookieStore();
        try (CloseableHttpClient client = this.httpClientService.getHttpClient(projectId, runtimeOptions, urlWithParameters, (CookieStore)httpCookieStore);){
            RequestExecutionResponse requestExecutionResponse;
            block12: {
                HttpEntityEnclosingRequestBase request = (HttpEntityEnclosingRequestBase)method.getHttpRequest(urlWithParameters);
                request.setEntity(entity);
                request.setHeaders(headers);
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                try {
                    this.calculateAndRegisterRequestSize(entity, headers, projectId, httpRequest.getTransportType());
                    requestExecutionResponse = this.createResponse(httpRequest, (HttpResponse)response, beforeExecutionDate, new Date(), (CookieStore)httpCookieStore, projectId);
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return requestExecutionResponse;
        }
    }

    private void calculateAndRegisterRequestSize(HttpEntity entity, Header[] headers, UUID projectId, TransportType transportType) throws Exception {
        double requestSize = 0.0;
        requestSize += RequestUtils.calculateHeadersSize(headers);
        if (Objects.nonNull(entity)) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)outputStream);
            outputStream.flush();
            requestSize += (double)outputStream.toByteArray().length;
        }
        this.metricService.incrementRequestSizePerProject(requestSize, projectId, transportType);
    }

    private boolean isNotEntityContentMeetLimit(long sizeInBytes, boolean isRequestEntity) {
        int bodySizeLimitInMb = this.requestResponseSizeProperties.getRequestSizeLimitInMb();
        if (!isRequestEntity) {
            bodySizeLimitInMb = this.requestResponseSizeProperties.getResponseSizeLimitInMb();
        }
        return (double)sizeInBytes * 1.0 / 1024.0 / 1024.0 >= (double)bodySizeLimitInMb;
    }

    private Header[] obtainHttpHeaders(HttpRequestEntitySaveRequest httpRequest) {
        if (Objects.isNull(httpRequest.getRequestHeaders())) {
            return null;
        }
        return (Header[])httpRequest.getRequestHeaders().stream().filter(h -> !h.isDisabled()).map(h -> new BasicHeader(h.getKey(), h.getValue())).toArray(Header[]::new);
    }

    private HttpMethod obtainHttpMethod(HttpRequestEntitySaveRequest httpRequest) {
        String requestUrl = httpRequest.getUrl();
        UUID requestId = httpRequest.getId();
        HttpMethod requestHttpMethod = httpRequest.getHttpMethod();
        if (StringUtils.isEmpty((String)requestUrl)) {
            log.error("Provided request '{}' URL is empty", (Object)requestId);
            throw new ItfLiteRequestIllegalUrlEmptyValueException();
        }
        if (Objects.isNull((Object)requestHttpMethod)) {
            log.error("Failed to obtain http method from value: {}", (Object)httpRequest.getHttpMethod());
            throw new ItfLiteHttpRequestIllegalMethodValueException(String.valueOf((Object)httpRequest.getHttpMethod()));
        }
        return requestHttpMethod;
    }

    @Nullable
    private HttpEntity obtainHttpEntity(HttpRequestEntitySaveRequest httpRequest, String context, Optional<MultipartFile> binaryFileOpt, SaveRequestResolvingContext resolvingContext, List<FileData> fileDataList) throws URISyntaxException, IOException {
        RequestBody body = httpRequest.getBody();
        if (Objects.isNull(body) && !binaryFileOpt.isPresent()) {
            return null;
        }
        if (binaryFileOpt.isPresent()) {
            MultipartFile binaryFile = binaryFileOpt.get();
            String contentType = binaryFile.getContentType();
            byte[] processedBinaryFile = this.itfLiteFileService.resolveParametersInMultipartFile(binaryFile, resolvingContext);
            if (processedBinaryFile != null) {
                httpRequest.setFile(new FileData(processedBinaryFile, binaryFile.getOriginalFilename()));
                httpRequest.setBody(new RequestBody((String)null, RequestBodyType.Binary));
                return EntityBuilder.create().setBinary(processedBinaryFile).setContentType(contentType == null ? ContentType.DEFAULT_BINARY : ContentType.parse((String)contentType)).build();
            }
            return null;
        }
        RequestBodyType bodyType = body.getType();
        String content = body.getContent();
        UUID projectId = httpRequest.getProjectId();
        if (RequestBodyType.Velocity.equals((Object)bodyType)) {
            String processedBody = this.processVelocity(projectId, content, context);
            return new StringEntity(processedBody);
        }
        if (RequestBodyType.FORM_DATA.equals((Object)bodyType)) {
            String boundary = this.getFormDataBoundary(httpRequest.getRequestHeaders());
            HttpEntity entity = this.prepareFormDataPart(body, fileDataList, boundary);
            this.updateGeneratedHeaderContentTypeValue(httpRequest.getRequestHeaders(), entity.getContentType().getValue());
            return entity;
        }
        if (Objects.nonNull(body.getContent())) {
            return new StringEntity(content, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Nullable
    private String getFormDataBoundary(List<HttpHeaderSaveRequest> headers) {
        String contentType = null;
        for (HttpHeaderSaveRequest header : headers) {
            if (!"Content-Type".equals(header.getKey())) continue;
            contentType = header.getValue();
        }
        if (StringUtils.isNotEmpty(contentType)) {
            String[] contentTypeParts;
            for (String contentTypePart : contentTypeParts = contentType.split(TAG_DELIMITER)) {
                int startValueIdx;
                if (!contentTypePart.contains("boundary") || (startValueIdx = contentTypePart.indexOf("=")) == -1) continue;
                String boundaryValue = contentTypePart.substring(startValueIdx + 1).trim();
                if (StringUtils.isEmpty((String)boundaryValue)) {
                    return null;
                }
                return boundaryValue;
            }
        }
        return null;
    }

    private void updateGeneratedHeaderContentTypeValue(List<HttpHeaderSaveRequest> headers, String contentType) {
        headers.stream().filter(h -> h.isGenerated() && "Content-Type".equals(h.getKey())).forEach(h -> h.setValue(contentType));
    }

    private HttpEntity prepareFormDataPart(RequestBody body, List<FileData> fileDataList, String boundary) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setBoundary(boundary);
        Map<Object, Object> map = Objects.isNull(fileDataList) ? new HashMap() : StreamUtils.toEntityMapWithMergeFunction(fileDataList, FileData::getFileName, (file1, file2) -> file1);
        body.getFormDataBody().forEach(requestFormDataBody -> {
            String fileName;
            FileData fileData;
            ValueType type = requestFormDataBody.getType();
            String key = requestFormDataBody.getKey();
            if (ValueType.TEXT.equals((Object)type)) {
                ContentType contentType = StringUtils.isEmpty((String)requestFormDataBody.getContentType()) ? ContentType.APPLICATION_OCTET_STREAM : ContentType.parse((String)requestFormDataBody.getContentType());
                multipartEntityBuilder.addPart(key, (ContentBody)new StringBody(requestFormDataBody.getValue(), contentType));
            } else if (ValueType.FILE.equals((Object)type) && (fileData = (FileData)map.get(fileName = requestFormDataBody.getValue())) != null) {
                ContentType contentType = StringUtils.isEmpty((String)requestFormDataBody.getContentType()) ? FileUtils.guessContentTypeFromName(fileName) : ContentType.parse((String)requestFormDataBody.getContentType());
                multipartEntityBuilder.addPart(key, (ContentBody)new ByteArrayBody(fileData.getContent(), contentType, fileName));
            }
        });
        return multipartEntityBuilder.build();
    }

    public Optional<FileBody> saveFileToFileSystemAndGridFs(UUID requestId, MultipartFile file, TransportType transportType) throws IOException {
        FileUtils.saveMultipartFileDictionaryToFileSystem(Constants.DEFAULT_BINARY_FILES_FOLDER, requestId, file);
        this.gridFsService.removeFileByRequestId(requestId);
        FileBody fileInfo = this.gridFsService.saveBinaryByRequestId(LocalDateTime.now().toString(), requestId, file.getInputStream(), file.getOriginalFilename(), file.getContentType());
        log.debug("File for request {} was saved with parameters {}", (Object)requestId, (Object)fileInfo);
        return Optional.of(fileInfo);
    }

    public String processVelocity(UUID projectId, String content, String context) throws URISyntaxException {
        if (this.feignClientsProperties.getIsFeignAtpItfEnabled().booleanValue()) {
            String[] contextArray = new String[]{};
            if (!StringUtils.isEmpty((String)context)) {
                contextArray = context.split(ITF_URL_CONTEXT_SEPARATOR);
            }
            if (contextArray.length > 1) {
                URI itfUri = this.getItfUri(contextArray[0]);
                String itfRoute = "";
                String contextId = contextArray[1];
                Properties properties = this.generatePropertiesForItfRequest(content, contextId);
                ItfParametersResolveResponse response = this.itfPlainFeignClient.processVelocity(itfUri, itfRoute, projectId, properties);
                return response.getResponse();
            }
            String contextId = context;
            UIVelocityRequestBodyDto requestBody = this.generateRequestBodyForItf(content, contextId);
            ItfParametersResolveResponse response = this.itfFeignService.processVelocity(projectId, requestBody);
            return response.getResponse();
        }
        return content;
    }

    private Properties generatePropertiesForItfRequest(String requestBody, String contextId) {
        Properties properties = new Properties();
        if (!StringUtils.isEmpty((String)contextId)) {
            properties.setProperty("context", contextId);
        } else {
            properties.setProperty("context", "");
        }
        properties.setProperty("xpath", "");
        properties.setProperty("message", requestBody);
        return properties;
    }

    private UIVelocityRequestBodyDto generateRequestBodyForItf(String requestBody, String contextId) {
        UIVelocityRequestBodyDto requestBodyDto = new UIVelocityRequestBodyDto();
        if (!StringUtils.isEmpty((String)contextId)) {
            requestBodyDto.setContext(contextId);
        } else {
            requestBodyDto.setContext("");
        }
        requestBodyDto.setMessage(requestBody);
        return requestBodyDto;
    }

    private RequestExecutionResponse createResponse(HttpRequestEntitySaveRequest httpRequest, HttpResponse response, Date beforeExecutionDate, Date afterExecutionDate, CookieStore cookieStore, UUID projectId) throws IOException {
        ArrayList<RequestExecutionHeaderResponse> headers = new ArrayList<RequestExecutionHeaderResponse>();
        Header[] respHeaders = response.getAllHeaders();
        double responseSize = 0.0;
        if (Objects.nonNull(respHeaders)) {
            for (Header header : respHeaders) {
                responseSize += RequestUtils.calculateHeaderSize(header);
                headers.add(new RequestExecutionHeaderResponse(header.getName(), header.getValue()));
            }
        }
        String requestDomain = UrlParsingUtils.getDomain(httpRequest.getUrl());
        List<ResponseCookie> cookies = CookieUtils.parseResponseCookie(requestDomain, cookieStore.getCookies());
        HttpEntity entity = response.getEntity();
        String body = "";
        if (Objects.nonNull(entity)) {
            body = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            ContentType contentType = ContentType.get((HttpEntity)entity);
            Charset charset = contentType == null ? null : ContentType.get((HttpEntity)entity).getCharset();
            responseSize += charset == null ? (double)body.getBytes().length : (double)body.getBytes(charset).length;
        }
        this.metricService.incrementResponseSizePerProject(responseSize, projectId, httpRequest.getTransportType());
        RequestBodyType bodyType = this.getResponseBodyType(respHeaders);
        String statusCode = String.valueOf(response.getStatusLine().getStatusCode());
        String statusText = response.getStatusLine().getReasonPhrase();
        BigInteger duration = BigInteger.valueOf(afterExecutionDate.getTime() - beforeExecutionDate.getTime());
        return RequestExecutionResponse.builder().id(httpRequest.getId()).responseHeaders(headers).body(body).bodyType(bodyType).statusCode(statusCode).statusText(statusText).duration(duration).startedWhen(beforeExecutionDate).executedWhen(afterExecutionDate).cookies(cookies).build();
    }

    RequestBodyType getResponseBodyType(Map<String, List<String>> headersMap) {
        BasicHeader[] responseHeaders = (BasicHeader[])headersMap.entrySet().stream().flatMap(entry -> {
            String headerName = (String)entry.getKey();
            List headerValues = (List)entry.getValue();
            return headerValues.stream().map(value -> new BasicHeader(headerName, value));
        }).toArray(BasicHeader[]::new);
        return this.getResponseBodyType((Header[])responseHeaders);
    }

    RequestBodyType getResponseBodyType(Header[] responseHeaders) {
        RequestBodyType bodyType = RequestBodyType.JSON;
        if (responseHeaders != null) {
            Optional<Header> responseContentTypeHeader = Arrays.stream(responseHeaders).filter(header -> "Content-Type".equals(header.getName())).findFirst();
            Optional<Header> contentDisposition = Arrays.stream(responseHeaders).filter(h -> "Content-Disposition".equals(h.getName())).findFirst();
            bodyType = RequestBodyType.valueOfContentType(responseContentTypeHeader.map(NameValuePair::getValue).orElse(null), contentDisposition.map(NameValuePair::getValue).orElse(null));
            if (Objects.isNull((Object)bodyType)) {
                bodyType = RequestBodyType.JSON;
            }
        }
        return bodyType;
    }

    private String createUrlWithParameters(HttpRequestEntitySaveRequest httpRequest, RequestRuntimeOptions runtimeOptions) {
        List<HttpParamSaveRequest> requestParams = httpRequest.getRequestParams();
        String url = httpRequest.getUrl();
        if (CollectionUtils.isEmpty(requestParams)) {
            return url;
        }
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        requestParams.forEach(parameter -> {
            if (!parameter.isDisabled()) {
                String key = parameter.getKey();
                String value = parameter.getValue();
                try {
                    if (!runtimeOptions.isDisableAutoEncoding()) {
                        uriComponentsBuilder.queryParam(URLEncoder.encode(key, "UTF-8").replace("+", "%20"), new Object[]{URLEncoder.encode(value, "UTF-8").replace("+", "%20")});
                    } else {
                        uriComponentsBuilder.queryParam(key, new Object[]{value});
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Failed to encode query parameter '{}' with value: '{}'", new Object[]{key, value, e});
                    throw new ItfLiteRequestQueryParamEncodingException(key, value);
                }
            }
        });
        return uriComponentsBuilder.build().toUriString();
    }

    public String getContext(UUID projectId, String context) throws URISyntaxException {
        if (this.feignClientsProperties.getIsFeignAtpItfEnabled().booleanValue()) {
            log.debug("Getting context: {}", (Object)context);
            if (StringUtils.isEmpty((String)context)) {
                log.debug("Context is empty");
                return "";
            }
            String[] contextArray = context.split(ITF_URL_CONTEXT_SEPARATOR);
            if (contextArray.length > 1) {
                URI itfUri = this.getItfUri(contextArray[0]);
                String itfRoute = "";
                return this.itfPlainFeignClient.getContext(itfUri, itfRoute, projectId, contextArray[1]);
            }
            return this.itfFeignService.getContext(context, projectId);
        }
        return "";
    }

    private URI getItfUri(String itfString) throws URISyntaxException {
        if (itfString.contains(ITF_CONFIGURATOR)) {
            String[] itfArray = itfString.split(ITF_URL_PROJECT_SEPARATOR);
            String itfExecutor = itfArray[0].replace(ITF_CONFIGURATOR, ITF_EXECUTOR);
            return new URI(itfExecutor);
        }
        return new URI(itfString);
    }

    public HttpRequest resolveAllVariables(HttpRequest httpRequest, String context, Boolean isVelocityResolveRequired, UUID environmentId) throws URISyntaxException, AtpDecryptException {
        HttpRequestEntitySaveRequest httpRequestEntitySaveRequest = (HttpRequestEntitySaveRequest)this.modelMapper.map((Object)httpRequest, HttpRequestEntitySaveRequest.class);
        this.envParamService.resolveEnvironmentParameters(httpRequestEntitySaveRequest, false, environmentId);
        this.resolveVelocityVariables(httpRequest, context, isVelocityResolveRequired, httpRequestEntitySaveRequest);
        return (HttpRequest)this.modelMapper.map((Object)httpRequestEntitySaveRequest, HttpRequest.class);
    }

    public void resolveVelocityVariables(HttpRequest httpRequest, String context, Boolean isVelocityResolveRequired, HttpRequestEntitySaveRequest saveRequest) throws URISyntaxException {
        RequestBody body;
        if (isVelocityResolveRequired.booleanValue() && (body = saveRequest.getBody()) != null) {
            RequestBodyType bodyType = body.getType();
            String content = body.getContent();
            UUID projectId = httpRequest.getProjectId();
            if (RequestBodyType.Velocity.equals((Object)bodyType)) {
                String processedBody = this.processVelocity(projectId, content, context);
                body.setContent(processedBody);
            }
        }
    }

    public void updateHeadersFields(List<RequestHeader> entities) {
        entities.forEach(entity -> {
            entity.setKey(entity.getKey().trim().replaceAll("[\n\r\t\b]", ""));
            entity.setValue(entity.getValue().trim());
        });
    }

    public void updateParametersFields(List<RequestParam> entities) {
        entities.forEach(entity -> {
            entity.setKey(entity.getKey().trim().replaceAll("[\n\r\t\b]", ""));
            entity.setValue(entity.getValue().trim());
        });
    }

    public void setOrder(Request request) {
        int n;
        Integer maxOrder;
        UUID projectId = request.getProjectId();
        UUID folderId = request.getFolderId();
        Integer n2 = maxOrder = Objects.isNull(folderId) ? this.requestRepository.findMaxOrder(projectId) : this.requestRepository.findMaxOrder(projectId, folderId);
        if (Objects.nonNull(maxOrder)) {
            maxOrder = maxOrder + 1;
            n = maxOrder;
        } else {
            n = 0;
        }
        Integer calcOrder = n;
        log.debug("Request order: {}", (Object)calcOrder);
        request.setOrder(calcOrder);
    }

    public void order(UUID requestId, RequestOrderChangeRequest request) {
        log.debug("Change order for the request with id '{}', request params: {}", (Object)requestId, (Object)request);
        UUID projectId = request.getProjectId();
        UUID folderId = request.getFolderId();
        int order = request.getOrder();
        List<Request> requests = this.requestRepository.findAllByProjectIdAndFolderId(projectId, folderId);
        requests.sort(Comparator.comparing(Request::getOrder, Comparator.nullsLast(Comparator.naturalOrder())));
        Request changedRequest = StreamUtils.find(requests, req -> req.getId().equals(requestId));
        requests.remove(changedRequest);
        requests.add(order, changedRequest);
        int count = 0;
        for (Request requestEntity : requests) {
            requestEntity.setOrder(count++);
        }
        this.requestRepository.saveAll(requests);
    }

    public void updateSaveRequestHeadersFields(List<HttpHeaderSaveRequest> entities) {
        if (!CollectionUtils.isEmpty(entities)) {
            entities.forEach(entity -> {
                entity.setKey(entity.getKey().trim().replaceAll("[\n\r\t\b]", ""));
                entity.setValue(entity.getValue().trim());
            });
            this.processContentTypeHeaders(entities);
        }
    }

    private void processContentTypeHeaders(List<HttpHeaderSaveRequest> entities) {
        Predicate<HttpHeaderSaveRequest> isContentTypeHeader = header -> header.getKey().equalsIgnoreCase("Content-Type");
        List enabledUserContentTypeHeaders = entities.stream().filter(header -> isContentTypeHeader.test((HttpHeaderSaveRequest)header) && !header.isGenerated() && !header.isDisabled()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(enabledUserContentTypeHeaders)) {
            log.debug("Enabled user content type headers: {}", enabledUserContentTypeHeaders);
            entities.stream().filter(header -> isContentTypeHeader.test((HttpHeaderSaveRequest)header) && header.isGenerated() && !header.isDisabled()).forEach(header -> header.setDisabled(true));
        }
    }

    public void updateSaveRequestParametersFields(List<HttpParamSaveRequest> entities) {
        entities.forEach(entity -> {
            entity.setKey(entity.getKey().trim().replaceAll("[\n\r\t\b]", ""));
            entity.setValue(entity.getValue().trim());
        });
    }

    public Request getByProjectIdAndSourceId(UUID projectId, UUID sourceId) {
        return this.requestRepository.getByProjectIdAndSourceId(projectId, sourceId);
    }

    public void encodeRequestParametersExceptEnv(List<RequestParam> parameters) {
        parameters.forEach(parameter -> {
            String key = parameter.getKey();
            String value = parameter.getValue();
            try {
                parameter.setKey(URLEncoder.encode(key, StandardCharsets.UTF_8.name()));
                parameter.setValue(this.envParamService.encodeParameterExceptEnv(value));
            }
            catch (UnsupportedEncodingException e) {
                log.error("Failed to encode query parameter '{}' with value: '{}'", new Object[]{key, value, e});
                throw new ItfLiteRequestQueryParamEncodingException(key, value);
            }
        });
    }

    public RequestRuntimeOptions retrieveRuntimeOptions(UUID requestId) {
        return this.requestRepository.getRequestRuntimeOptionsById(requestId).orElseThrow(() -> {
            log.error("Failed to found Request with id: {}", (Object)requestId);
            return new AtpEntityNotFoundException("Request", (Object)requestId);
        });
    }

    private UUID parseRequestPath(String requestPath) {
        List<Request> requests;
        String splitChar = "/";
        List requestParts = Arrays.stream(requestPath.split(splitChar)).map(String::trim).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(requestParts)) {
            log.error("Request path is empty. Can't get request id");
            return null;
        }
        if (requestParts.size() == 1 && !CollectionUtils.isEmpty(requests = this.requestRepository.findAllByName((String)requestParts.get(0)))) {
            Request filteredRequest = requests.stream().filter(request -> request.getFolderId() == null).findAny().orElse(null);
            return filteredRequest != null ? filteredRequest.getId() : null;
        }
        requests = this.requestRepository.findAllByName((String)requestParts.get(requestParts.size() - 1));
        UUID requestId = null;
        for (Request request2 : requests) {
            requestId = request2.getId();
            UUID currentFolderId = request2.getFolderId();
            int i = requestParts.size() - 2;
            while (i > 0) {
                if (currentFolderId == null) {
                    i = 0;
                    requestId = null;
                    continue;
                }
                String currentFolderName = (String)requestParts.get(i);
                List<Folder> foundFolders = this.folderService.getFolderByIdAndName(currentFolderId, currentFolderName);
                if (CollectionUtils.isEmpty(foundFolders)) {
                    i = 0;
                    requestId = null;
                    continue;
                }
                --i;
                currentFolderId = foundFolders.get(0).getParentId();
            }
        }
        return requestId;
    }

    private String getResponseFilenameFromResponseHeaders(Map<String, List<String>> headersMap) {
        NameValuePair nameValuePair;
        HeaderElement headerElement;
        Optional<Map.Entry> contentDispositionMapEntryOptional = headersMap.entrySet().stream().filter(entry -> "Content-Disposition".equalsIgnoreCase((String)entry.getKey())).findFirst();
        if (!contentDispositionMapEntryOptional.isPresent()) {
            return null;
        }
        List headerValues = (List)contentDispositionMapEntryOptional.get().getValue();
        if (CollectionUtils.isEmpty((Collection)headerValues)) {
            return null;
        }
        BasicHeader basicHeader = new BasicHeader("Content-Disposition", (String)headerValues.get(0));
        HeaderElement[] headerElements = basicHeader.getElements();
        if (headerElements.length > 0 && (headerElement = headerElements[0]).getName().equalsIgnoreCase("attachment") && (nameValuePair = headerElement.getParameterByName("filename")) != null) {
            return nameValuePair.getValue();
        }
        return null;
    }

    private String getExtensionByContentTypeHeader(Map<String, List<String>> headersMap) {
        Optional<Map.Entry> contentDispositionMapEntryOptional = headersMap.entrySet().stream().filter(entry -> "Content-Disposition".equalsIgnoreCase((String)entry.getKey())).findFirst();
        if (contentDispositionMapEntryOptional.isPresent()) {
            return null;
        }
        Optional<Map.Entry> contentTypeMapEntryOptional = headersMap.entrySet().stream().filter(entry -> "Content-Type".equalsIgnoreCase((String)entry.getKey())).findFirst();
        if (!contentTypeMapEntryOptional.isPresent()) {
            return null;
        }
        List headerValues = (List)contentTypeMapEntryOptional.get().getValue();
        BasicHeader basicHeader = new BasicHeader("Content-Type", (String)headerValues.get(0));
        HeaderElement[] headerElements = basicHeader.getElements();
        if (headerElements.length > 0) {
            HeaderElement headerElement = headerElements[0];
            String contentType = headerElement.getName();
            MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
            try {
                return allTypes.forName(contentType).getExtension();
            }
            catch (MimeTypeException e) {
                log.warn("Can't get extension by contentType = {}", (Object)contentType);
            }
        }
        return null;
    }

    public RequestService(RequestRepository requestRepository, ModelMapper modelMapper, ObjectMapper objectMapper, CurlFormatToRequestConverter curlFormatToRequestConverter, RequestToCurlFormatConverter requestToCurlFormatConverter, ItfFeignService itfFeignService, ItfPlainFeignClient itfPlainFeignClient, FeignClientsProperties feignClientsProperties, GridFsService gridFsService, RequestExecutionHistoryService executionHistoryService, FolderService folderService, RequestAuthorizationService requestAuthorizationService, EnvironmentVariableService envParamService, RequestSpecificationService requestSpecificationService, MetricService metricService, HttpClientService httpClientService, MacrosService macrosService, JsScriptEngineService scriptService, ItfLiteFileService itfLiteFileService, TemplateResolverService templateResolverService, RamService ramService, DynamicVariablesService dynamicVariablesService, WritePermissionsService writePermissionsService, CookieService cookieService, RequestExecutionDetailsRepository detailsRepository, NextRequestService nextRequestService, RequestResponseSizeProperties requestResponseSizeProperties, DeleteHistoryService deleteHistoryService) {
        this.requestRepository = requestRepository;
        this.modelMapper = modelMapper;
        this.objectMapper = objectMapper;
        this.curlFormatToRequestConverter = curlFormatToRequestConverter;
        this.requestToCurlFormatConverter = requestToCurlFormatConverter;
        this.itfFeignService = itfFeignService;
        this.itfPlainFeignClient = itfPlainFeignClient;
        this.feignClientsProperties = feignClientsProperties;
        this.gridFsService = gridFsService;
        this.executionHistoryService = executionHistoryService;
        this.folderService = folderService;
        this.requestAuthorizationService = requestAuthorizationService;
        this.envParamService = envParamService;
        this.requestSpecificationService = requestSpecificationService;
        this.metricService = metricService;
        this.httpClientService = httpClientService;
        this.macrosService = macrosService;
        this.scriptService = scriptService;
        this.itfLiteFileService = itfLiteFileService;
        this.templateResolverService = templateResolverService;
        this.ramService = ramService;
        this.dynamicVariablesService = dynamicVariablesService;
        this.writePermissionsService = writePermissionsService;
        this.cookieService = cookieService;
        this.detailsRepository = detailsRepository;
        this.nextRequestService = nextRequestService;
        this.requestResponseSizeProperties = requestResponseSizeProperties;
        this.deleteHistoryService = deleteHistoryService;
    }
}

