/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.Date;
import java.util.List;
import org.qubership.atp.itf.lite.backend.model.entities.key.RequestSnapshotKey;
import org.qubership.atp.itf.lite.backend.service.RequestSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class RequestSnapshotCleaner {
    private static final Logger log = LoggerFactory.getLogger(RequestSnapshotCleaner.class);
    @Value(value="${atp.itf.lite.clean.snapshot.expiration.period.seconds:86400}")
    private String snapshotExpirationPeriod;
    private final RequestSnapshotService requestSnapshotService;

    @Scheduled(cron="${atp.itf.lite.clean.snapshot.cron.expression}")
    public void deleteOldSnapshots() {
        List<RequestSnapshotKey> expiredSnapshotIds = this.requestSnapshotService.getByCreatedWhenDifferenceGreaterThanReferenceDate(new Date(), Long.parseLong(this.snapshotExpirationPeriod));
        expiredSnapshotIds.forEach(key -> this.requestSnapshotService.deleteSnapshotByRequestSnapshotKey(key.getSessionId(), key.getRequestId()));
    }

    public RequestSnapshotCleaner(RequestSnapshotService requestSnapshotService) {
        this.requestSnapshotService = requestSnapshotService;
    }
}

