/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.modelmapper.ModelMapper;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.integration.configuration.model.notification.Notification;
import org.qubership.atp.integration.configuration.service.NotificationService;
import org.qubership.atp.itf.lite.backend.configuration.SseProperties;
import org.qubership.atp.itf.lite.backend.enums.ImportToolType;
import org.qubership.atp.itf.lite.backend.enums.SseEventType;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.exceptions.ItfLiteException;
import org.qubership.atp.itf.lite.backend.model.RequestRuntimeOptions;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ItfLiteExecutionFinishEvent;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.ErrorResponseSerializable;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionHeaderResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExportResultResponse;
import org.qubership.atp.itf.lite.backend.model.api.sse.GetAccessTokenData;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.model.entities.history.HttpRequestExecutionDetails;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecutionDetails;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.qubership.atp.itf.lite.backend.service.RequestExecutionHistoryService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.kafka.KafkaExecutionFinishSendingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class SseEmitterService {
    private static final Logger log = LoggerFactory.getLogger(SseEmitterService.class);
    private final RequestService requestService;
    private final NotificationService notificationService;
    private final KafkaExecutionFinishSendingService kafkaExecutionFinishSendingService;
    private final RequestExecutionHistoryService requestExecutionHistoryService;
    private final ModelMapper modelMapper;
    private final ExecutorService ssePingsExecutorService = Executors.newCachedThreadPool();
    private final SseProperties sseProperties;
    private final Map<UUID, SseEmitter> sseEmitters = new ConcurrentHashMap<UUID, SseEmitter>();
    private final GridFsService gridFsService;

    public SseEmitter generateAndConfigureEmitter(UUID sseId, UUID userId) {
        SseEmitter emitter = new SseEmitter(this.sseProperties.getSseEmitterTimeout());
        this.sseEmitters.put(sseId, emitter);
        emitter.onCompletion(() -> this.sseEmitters.remove(sseId));
        emitter.onTimeout(() -> {
            this.sseEmitters.remove(sseId);
            this.prepareAndSendSseEmitterExpiredNotification(userId);
        });
        Map mdcMap = MDC.getCopyOfContextMap();
        this.ssePingsExecutorService.execute(() -> {
            try {
                MdcUtils.setContextMap((Map)mdcMap);
                SseEmitter.SseEventBuilder pingEventWithZeroRetryTimeout = SseEmitter.event().name(SseEventType.PING.name()).reconnectTime(0L);
                while (true) {
                    TimeUnit.MILLISECONDS.sleep(this.sseProperties.getSseEmitterPingTimeout());
                    emitter.send(pingEventWithZeroRetryTimeout);
                }
            }
            catch (Exception e) {
                log.debug("Emitter with sseId = {} was removed from sseEmitters map.", (Object)sseId);
                emitter.completeWithError((Throwable)e);
                return;
            }
        });
        return emitter;
    }

    private void prepareAndSendSseEmitterExpiredNotification(UUID userId) {
        Notification notification = new Notification("SSE emitter is expired. Please establish new connection.", Notification.Type.INFO, userId);
        this.notificationService.sendNotification(notification);
    }

    public SseEmitter getEmitter(UUID sseId) {
        return this.sseEmitters.getOrDefault(sseId, null);
    }

    public void emitterCompleteWithError(SseEmitter emitter, Exception e) {
        String message = e.getMessage();
        log.error("Exception occurred while sending a response throw emitter: {}", (Object)message, (Object)e);
        String errorMessage = String.format("System couldn't execute the request.\n%s\nPlease, see details in Request History", message);
        if (e instanceof ItfLiteException) {
            emitter.completeWithError((Throwable)e);
            throw (ItfLiteException)((Object)e);
        }
        emitter.completeWithError((Throwable)((Object)new ItfLiteException(errorMessage)));
        throw new ItfLiteException(errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGetAccessTokenResult(UUID sseId, SseEmitter emitter, GetAccessTokenData getAccessTokenData) {
        try {
            log.debug("Sending sse event of 'GetAccessToken' for sseId = {}", (Object)sseId);
            SseEmitter.SseEventBuilder getAccessTokenEvent = SseEmitter.event().name(SseEventType.GET_ACCESS_TOKEN_FINISHED.name()).data((Object)getAccessTokenData, MediaType.APPLICATION_JSON);
            emitter.send(getAccessTokenEvent);
        }
        catch (IOException e) {
            log.error("Can't send to emitter result '{}' due to exception", (Object)getAccessTokenData, (Object)e);
        }
        finally {
            emitter.complete();
        }
    }

    public void sendEventWithExportResult(UUID sseId, SseEmitter emitter, ImportToolType importToolType, RequestExportResultResponse exportResult) throws IOException {
        log.debug("Sending sse event for sseId = {}, importToolType = {}", (Object)sseId, (Object)importToolType);
        SseEmitter.SseEventBuilder event = SseEmitter.event().name(SseEventType.EXPORT_FINISHED.name()).data((Object)exportResult, MediaType.APPLICATION_JSON);
        emitter.send(event);
    }

    public void sendEventWithExecutionResult(UUID sseId, SseEmitter emitter, RequestExecutionResponse requestExecutionResponse) {
        log.debug("Sending sse event for sseId = {}", (Object)sseId);
        SseEmitter.SseEventBuilder executionEvent = SseEmitter.event().name(SseEventType.EXECUTION_FINISHED.name()).data((Object)requestExecutionResponse, MediaType.APPLICATION_JSON);
        try {
            emitter.send(executionEvent);
        }
        catch (IOException e) {
            log.error("ERROR during sending sse event for sseId {}", (Object)sseId, (Object)e);
        }
        emitter.complete();
    }

    public void processRequestExecution(RequestEntitySaveRequest requestEntity, String context, String token, UUID sseId, Optional<MultipartFile> file, List<MultipartFile> files, UUID environmentId) {
        this.processRequestExecution(requestEntity, context, token, sseId, file, files, environmentId, new RequestRuntimeOptions(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestExecution(RequestEntitySaveRequest requestEntity, String context, String token, UUID sseId, Optional<MultipartFile> file, List<MultipartFile> files, UUID environmentId, RequestRuntimeOptions runtimeOptions, UUID sessionId) {
        Optional<FileData> existingFileDataOpt;
        if (!file.isPresent() && sessionId != null && (existingFileDataOpt = this.gridFsService.downloadFileBySessionIdAndRequestId(sessionId, requestEntity.getId())).isPresent()) {
            file = Optional.of((MultipartFile)existingFileDataOpt.get());
        }
        ItfLiteExecutionFinishEvent finishEvent = new ItfLiteExecutionFinishEvent(sseId, requestEntity.getId(), requestEntity.getTransportType());
        RequestExecutionResponse response = new RequestExecutionResponse();
        try {
            List<FileData> fileDataList = this.convertListMultipartToFileData(files);
            response = this.requestService.executeRequest(requestEntity, context, token, sseId, file, environmentId, fileDataList, runtimeOptions);
        }
        catch (ItfLiteException itfLiteException) {
            this.setErrorMessageInResponseAndFinishEvent(response, finishEvent, (Exception)((Object)itfLiteException));
            throw itfLiteException;
        }
        catch (Exception e) {
            log.error("Error happen during request execution with ID {} in scope of SSE ID {}", new Object[]{requestEntity.getId(), sseId, e});
            this.setErrorMessageInResponseAndFinishEvent(response, finishEvent, e);
        }
        finally {
            this.finishExecutionRequest(response, finishEvent);
        }
    }

    private void setErrorMessageInResponseAndFinishEvent(RequestExecutionResponse response, ItfLiteExecutionFinishEvent finishEvent, Exception e) {
        finishEvent.setErrorMessage(e.getMessage());
        ErrorResponseSerializable error = new ErrorResponseSerializable();
        error.setMessage(e.getMessage());
        response.setError(error);
    }

    void finishExecutionRequest(RequestExecutionResponse response, ItfLiteExecutionFinishEvent finishEvent) {
        SseEmitter sseEmitter = this.getEmitter(finishEvent.getSseId());
        if (sseEmitter != null) {
            if (response == null) {
                this.generateResponseAndSendToEmitter(sseEmitter, finishEvent);
            } else {
                this.sendEventWithExecutionResult(finishEvent.getSseId(), sseEmitter, response);
            }
        } else {
            this.kafkaExecutionFinishSendingService.executionFinishEventSend(finishEvent);
        }
    }

    public void generateResponseAndSendToEmitter(SseEmitter sseEmitter, ItfLiteExecutionFinishEvent executionFinishEvent) {
        log.info("Generate response (from kafka or due to exception)");
        RequestExecutionResponse response = new RequestExecutionResponse();
        RequestExecutionDetails executionDetails = this.requestExecutionHistoryService.getExecutionHistoryDetailsBySseId(executionFinishEvent.getSseId());
        HttpRequestExecutionDetails httpExecutionDetails = (HttpRequestExecutionDetails)executionDetails;
        this.fillHttpExecutionResponse(httpExecutionDetails, executionFinishEvent.getRequestId(), response);
        this.sendEventWithExecutionResult(executionFinishEvent.getSseId(), sseEmitter, response);
    }

    void fillHttpExecutionResponse(HttpRequestExecutionDetails httpExecutionDetails, UUID requestId, RequestExecutionResponse response) {
        log.debug("Fetched http details from database: [{}]", (Object)httpExecutionDetails);
        this.modelMapper.map((Object)httpExecutionDetails.getRequestExecution(), (Object)response);
        response.setId(requestId);
        response.setBody(httpExecutionDetails.getResponseBody());
        response.setError(httpExecutionDetails.getErrorMessage());
        response.setExecutionId(httpExecutionDetails.getRequestExecution().getId());
        response.setContextVariables(httpExecutionDetails.getContextVariables());
        response.setCookies(httpExecutionDetails.getCookies());
        response.setCookieHeader(httpExecutionDetails.getCookieHeader());
        this.fillResponseFromResponseBodyByte(httpExecutionDetails, response);
        ArrayList<RequestExecutionHeaderResponse> responseHeaders = new ArrayList<RequestExecutionHeaderResponse>();
        Map<String, List<String>> executionDetailsResponseHeaders = httpExecutionDetails.getResponseHeaders();
        if (executionDetailsResponseHeaders != null) {
            for (Map.Entry<String, List<String>> entry : executionDetailsResponseHeaders.entrySet()) {
                String headerKey = entry.getKey();
                List<String> headerValues = entry.getValue();
                if (headerValues == null) continue;
                headerValues.forEach(headerValue -> responseHeaders.add(new RequestExecutionHeaderResponse(headerKey, (String)headerValue)));
            }
            response.setResponseHeaders(responseHeaders);
            RequestBodyType responseBodyType = this.requestService.getResponseBodyType(executionDetailsResponseHeaders);
            response.setBodyType(responseBodyType);
        }
        log.debug("Configured http response from database: [{}]", (Object)response);
    }

    protected List<FileData> convertListMultipartToFileData(List<MultipartFile> files) {
        ArrayList<FileData> res = new ArrayList<FileData>();
        if (files != null) {
            files.forEach(multipartFile -> {
                String fileName = multipartFile.getOriginalFilename();
                try {
                    res.add(new FileData(multipartFile.getBytes(), fileName));
                }
                catch (IOException e) {
                    log.error("Unable put to list for file = {}", (Object)fileName, (Object)e);
                }
            });
        }
        return res;
    }

    private void fillResponseFromResponseBodyByte(RequestExecutionDetails executionDetails, RequestExecutionResponse response) {
        if (Objects.isNull(executionDetails.getResponseBody()) && Objects.nonNull(executionDetails.getResponseBodyByte())) {
            response.setBody(new String(executionDetails.getResponseBodyByte(), StandardCharsets.UTF_8));
        }
    }

    public SseEmitterService(RequestService requestService, NotificationService notificationService, KafkaExecutionFinishSendingService kafkaExecutionFinishSendingService, RequestExecutionHistoryService requestExecutionHistoryService, ModelMapper modelMapper, SseProperties sseProperties, GridFsService gridFsService) {
        this.requestService = requestService;
        this.notificationService = notificationService;
        this.kafkaExecutionFinishSendingService = kafkaExecutionFinishSendingService;
        this.requestExecutionHistoryService = requestExecutionHistoryService;
        this.modelMapper = modelMapper;
        this.sseProperties = sseProperties;
        this.gridFsService = gridFsService;
    }
}

