/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.qubership.atp.crypt.CryptoTools;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.replacer.ContextVariablesReplacer;
import org.qubership.atp.itf.lite.backend.components.replacer.EnvironmentReplacer;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteDecryptException;
import org.qubership.atp.itf.lite.backend.model.api.request.ResolvableRequest;
import org.qubership.atp.itf.lite.backend.model.context.SaveRequestResolvingContext;
import org.qubership.atp.itf.lite.backend.service.macros.SimpleContextWithParametersDecrypting;
import org.qubership.atp.macros.core.processor.AbstractContext;
import org.qubership.atp.macros.core.processor.Evaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TemplateResolverService {
    private static final Logger log = LoggerFactory.getLogger(TemplateResolverService.class);
    private final ContextVariablesReplacer contextVariablesReplacer;
    private final EnvironmentReplacer environmentReplacer;
    private final Decryptor decryptor;
    @Value(value="${template.resolver.recursion.depth.max:3}")
    private static int MAX_RECURSION_DEPTH;

    public void resolveTemplatesWithOrder(ResolvableRequest request, SaveRequestResolvingContext context, Evaluator evaluator) {
        ArrayList<Function<String, String>> replacers = new ArrayList<Function<String, String>>();
        Map<String, Object> mergedScopes = context.mergeScopes();
        if (Objects.nonNull(mergedScopes) && !mergedScopes.isEmpty()) {
            replacers.add(value -> this.contextVariablesReplacer.replace((String)value, mergedScopes));
        }
        Map<String, Object> environmentContext = context.getEnvironmentVariables();
        replacers.add(value -> this.environmentReplacer.replace((String)value, environmentContext));
        SimpleContextWithParametersDecrypting macrosContext = new SimpleContextWithParametersDecrypting(this.decryptor);
        macrosContext.setContextParameters(mergedScopes);
        replacers.add(value -> evaluator.evaluate(value, (AbstractContext)macrosContext));
        request.resolveTemplates(value -> this.resolveVariables((String)value, (List<Function<String, String>>)replacers, 0));
    }

    public void processEncryptedValues(ResolvableRequest request, boolean safely) {
        ArrayList<Function<String, String>> replacers = new ArrayList<Function<String, String>>();
        if (safely) {
            replacers.add(CryptoTools::maskEncryptedData);
        } else {
            replacers.add(value -> {
                try {
                    return this.decryptor.decryptEncryptedPlacesInString(value);
                }
                catch (AtpDecryptException e) {
                    log.error("Error occurred while decrypting value in request", (Throwable)e);
                    throw new ItfLiteDecryptException();
                }
            });
        }
        request.resolveTemplates(value -> this.resolveVariables((String)value, (List<Function<String, String>>)replacers, 0));
    }

    private String resolveVariables(String value, List<Function<String, String>> replacers, int recursionDepth) {
        if (value == null) {
            return null;
        }
        for (Function<String, String> replacer : replacers) {
            value = replacer.apply(value);
        }
        if (this.isStringContainsTemplate(value) && recursionDepth < MAX_RECURSION_DEPTH) {
            return this.resolveVariables(value, replacers, ++recursionDepth);
        }
        return value;
    }

    private boolean isStringContainsTemplate(String value) {
        return value.contains("$") || value.contains("{");
    }

    public TemplateResolverService(ContextVariablesReplacer contextVariablesReplacer, EnvironmentReplacer environmentReplacer, Decryptor decryptor) {
        this.contextVariablesReplacer = contextVariablesReplacer;
        this.environmentReplacer = environmentReplacer;
        this.decryptor = decryptor;
    }
}

