/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.modelmapper.ModelMapper;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.UserSettingsRepository;
import org.qubership.atp.itf.lite.backend.model.entities.user.UserSettings;
import org.qubership.atp.itf.lite.backend.service.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class UserService
extends CrudService<UserSettings> {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    public final String sessionState = "session_state";
    public final String sub = "sub";
    private String issuer;
    @Value(value="${keycloak.auth-server-url}")
    private String baseUrl;
    @Value(value="${keycloak.realm}")
    private String realm;
    @Qualifier(value="m2mRestTemplate")
    private RestTemplate m2mRestTemplate;
    private final UserSettingsRepository userSettingsRepository;
    private final ModelMapper modelMapper;

    @Autowired
    public UserService(RestTemplate m2mRestTemplate, UserSettingsRepository userSettingsRepository, ModelMapper modelMapper) {
        this.m2mRestTemplate = m2mRestTemplate;
        this.userSettingsRepository = userSettingsRepository;
        this.modelMapper = modelMapper;
    }

    @PostConstruct
    public void init() {
        this.issuer = this.baseUrl + "/admin/realms/" + this.realm;
    }

    @Override
    protected JpaRepository<UserSettings, UUID> repository() {
        return this.userSettingsRepository;
    }

    public UserInfo getUserInfoByToken(String token) {
        UserInfo userInfo;
        UUID userId = this.getUserIdFromToken(token);
        try {
            userInfo = (UserInfo)this.m2mRestTemplate.getForObject(this.issuer + "/users/" + userId.toString(), UserInfo.class, new Object[0]);
        }
        catch (Exception e) {
            log.error(String.format("Could not find user: %s ", userId.toString()));
            return null;
        }
        return userInfo;
    }

    public UUID getUserIdFromToken(String token) {
        UUID userId = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                token = token.split(" ")[1];
                JsonParser parser = JsonParserFactory.getJsonParser();
                Map tokenData = parser.parseMap(JwtHelper.decode((String)token).getClaims());
                userId = UUID.fromString(tokenData.get("sub").toString());
            }
            catch (Exception e) {
                log.warn("Cannot parse token with error: ", (Throwable)e);
            }
        }
        return userId;
    }

    public UserSettings saveUserSettings(UserSettings userSettings, String token) {
        log.debug("Get userId by token");
        UUID userId = this.getUserIdFromToken(token);
        log.debug("Check if settings with name = {} already exists", (Object)userSettings.getName());
        UserSettings existedUserSettings = this.userSettingsRepository.findByUserIdAndName(userId, userSettings.getName());
        if (existedUserSettings == null) {
            log.info("Create user settings by request: {}", (Object)userSettings);
            existedUserSettings = (UserSettings)this.modelMapper.map((Object)userSettings, UserSettings.class);
            existedUserSettings.setUserId(userId);
        } else {
            log.debug("Update existed user settings");
            existedUserSettings.setVisibleColumns(userSettings.getVisibleColumns());
        }
        log.info("Saved user settings: {}", (Object)existedUserSettings);
        return this.save(existedUserSettings);
    }

    public List<UserSettings> getSettingsByUser(String token) {
        UUID userId = this.getUserIdFromToken(token);
        return this.userSettingsRepository.findByUserId(userId);
    }
}

