/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.entities.Operations;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.security.permissions.PolicyEnforcement;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.itf.lite.backend.utils.UserManagementEntities;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WritePermissionsService {
    private final PolicyEnforcement entityAccess;
    private final UsersService usersService;
    private final Provider<UserInfo> userInfoProvider;

    public boolean hasWritePermissions(UUID permissionFolderId, UUID projectId) {
        if (Objects.nonNull(permissionFolderId)) {
            Map objectPermissions = this.usersService.getPermissionsByObjectId(UserManagementEntities.FOLDER.getName(), projectId, permissionFolderId);
            String objectName = this.usersService.getObjectName(UserManagementEntities.FOLDER.getName(), permissionFolderId);
            if (!CollectionUtils.isEmpty((Map)objectPermissions) && objectPermissions.containsKey(objectName)) {
                Map assignedUsers = (Map)objectPermissions.get(objectName);
                return this.userHasWritePermissions(assignedUsers);
            }
        }
        return true;
    }

    private boolean userHasWritePermissions(Map<UUID, Operations> objectPermissions) {
        UserInfo userInfo = (UserInfo)this.userInfoProvider.get();
        UUID userId = Objects.nonNull(userInfo) ? userInfo.getId() : null;
        return this.entityAccess.isAdmin() || Objects.nonNull(userId) && objectPermissions.containsKey(userId);
    }

    public WritePermissionsService(PolicyEnforcement entityAccess, UsersService usersService, Provider<UserInfo> userInfoProvider) {
        this.entityAccess = entityAccess;
        this.usersService = usersService;
        this.userInfoProvider = userInfoProvider;
    }
}

