/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.history.impl;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestRepository;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.feign.dto.history.HistoryItemTypeDto;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.service.history.iface.RestoreHistoryService;
import org.qubership.atp.itf.lite.backend.service.history.iface.RetrieveHistoryService;
import org.springframework.stereotype.Component;

@Component
public class HistoryServiceFactory {
    private final List<RestoreHistoryService> restoreHistoryServices;
    private final List<RetrieveHistoryService> retrieveHistoryServices;
    private final RequestRepository requestRepository;

    public Optional<RestoreHistoryService> getRestoreHistoryService(String itemType, UUID itemId) {
        if (HistoryItemTypeDto.REQUEST.toString().equalsIgnoreCase(itemType)) {
            List restoreRequestHistoryServices = this.restoreHistoryServices.stream().filter(service -> service.getItemType().toString().equalsIgnoreCase(itemType)).collect(Collectors.toList());
            TransportType type = this.requestRepository.findTransportType(itemId);
            return restoreRequestHistoryServices.stream().filter(service -> HttpRequest.class.equals(service.getEntityClass())).findFirst();
        }
        return this.restoreHistoryServices.stream().filter(service -> service.getItemType().toString().equalsIgnoreCase(itemType)).findFirst();
    }

    public Optional<RetrieveHistoryService> getRetrieveHistoryService(String itemType, UUID itemId) {
        if (HistoryItemTypeDto.REQUEST.toString().equalsIgnoreCase(itemType)) {
            List retrieveRequestHistoryServiced = this.retrieveHistoryServices.stream().filter(service -> service.getItemType().toString().equalsIgnoreCase(itemType)).collect(Collectors.toList());
            TransportType type = this.requestRepository.findTransportType(itemId);
            return retrieveRequestHistoryServiced.stream().filter(service -> HttpRequest.class.equals(service.getEntityClass())).findFirst();
        }
        return this.retrieveHistoryServices.stream().filter(service -> service.getItemType().toString().equalsIgnoreCase(itemType)).findFirst();
    }

    public HistoryServiceFactory(List<RestoreHistoryService> restoreHistoryServices, List<RetrieveHistoryService> retrieveHistoryServices, RequestRepository requestRepository) {
        this.restoreHistoryServices = restoreHistoryServices;
        this.retrieveHistoryServices = retrieveHistoryServices;
        this.requestRepository = requestRepository;
    }
}

