/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.history.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.javers.core.Javers;
import org.javers.shadow.Shadow;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.feign.dto.history.HistoryItemTypeDto;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.history.impl.AbstractRestoreHistoryService;
import org.qubership.atp.itf.lite.backend.service.history.impl.ValidateReferenceExistsService;
import org.springframework.stereotype.Service;

@Service
public class HttpRequestRestoreHistoryService
extends AbstractRestoreHistoryService<Request> {
    public HttpRequestRestoreHistoryService(Javers javers, RequestService configurationService, ValidateReferenceExistsService validateReferenceExistsService, ModelMapper modelMapper) {
        super(javers, configurationService, validateReferenceExistsService, modelMapper);
    }

    @Override
    public HistoryItemTypeDto getItemType() {
        return HistoryItemTypeDto.REQUEST;
    }

    public Class<HttpRequest> getEntityClass() {
        return HttpRequest.class;
    }

    @Override
    void updateObjectWithChild(Shadow<Request> object) {
    }

    @Override
    public List<Shadow<Object>> getChildShadows(Shadow<Request> parentShadow, Class targetObject) {
        return new ArrayList<Shadow<Object>>();
    }

    @Override
    protected void copyValues(Request shadow, Request actualObject) {
        this.modelMapper.map((Object)shadow, (Object)actualObject);
        RequestBody body = ((HttpRequest)shadow).getBody();
        if (Objects.nonNull(body) && RequestBodyType.FORM_DATA.equals((Object)body.getType())) {
            ((HttpRequest)actualObject).getBody().setFormDataBody(new ArrayList<FormDataPart>(body.getFormDataBody()));
        }
    }
}

