/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.kafka;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ItfExportResponseEvent;
import org.qubership.atp.itf.lite.backend.model.api.kafka.MiaExportResponseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaExportEventExceptionResponseSendingService {
    private static final Logger log = LoggerFactory.getLogger(KafkaExportEventExceptionResponseSendingService.class);
    private String miaFinishTopicName;
    private KafkaTemplate<UUID, MiaExportResponseEvent> miaFinishExportKafkaTemplate;
    private String itfFinishTopicName;
    private KafkaTemplate<UUID, ItfExportResponseEvent> itfFinishExportKafkaTemplate;

    public KafkaExportEventExceptionResponseSendingService(String miaFinishTopicName, KafkaTemplate<UUID, MiaExportResponseEvent> miaFinishExportKafkaTemplate, String itfFinishTopicName, KafkaTemplate<UUID, ItfExportResponseEvent> itfFinishExportKafkaTemplate) {
        this.miaFinishTopicName = miaFinishTopicName;
        this.miaFinishExportKafkaTemplate = miaFinishExportKafkaTemplate;
        this.itfFinishTopicName = itfFinishTopicName;
        this.itfFinishExportKafkaTemplate = itfFinishExportKafkaTemplate;
    }

    public void miaFinishExportResponseEventSend(MiaExportResponseEvent miaExportResponseEvent) {
        log.debug("Send mia export finish response to kafka for requestExportId = {}, requestId = {}", (Object)miaExportResponseEvent.getId(), (Object)miaExportResponseEvent.getRequestId());
        this.miaFinishExportKafkaTemplate.send(this.miaFinishTopicName, (Object)miaExportResponseEvent.getId(), (Object)miaExportResponseEvent);
    }

    public void itfFinishExportResponseEventSend(ItfExportResponseEvent itfExportResponseEvent) {
        log.debug("Send itf export finish response to kafka for requestExportId = {}, requestId = {}", (Object)itfExportResponseEvent.getId(), (Object)itfExportResponseEvent.getRequestId());
        this.itfFinishExportKafkaTemplate.send(this.itfFinishTopicName, (Object)itfExportResponseEvent.getId(), (Object)itfExportResponseEvent);
    }

    public KafkaExportEventExceptionResponseSendingService() {
    }
}

