/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.kafka;

import java.io.IOException;
import java.util.UUID;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.enums.ImportToolType;
import org.qubership.atp.itf.lite.backend.enums.RequestExportStatus;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ExportResponseEvent;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ItfExportResponseEvent;
import org.qubership.atp.itf.lite.backend.model.api.kafka.MiaExportResponseEvent;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExportResultResponse;
import org.qubership.atp.itf.lite.backend.model.entities.RequestExportEntity;
import org.qubership.atp.itf.lite.backend.service.RequestExportService;
import org.qubership.atp.itf.lite.backend.service.SseEmitterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class KafkaExportEventResponseService {
    private static final Logger log = LoggerFactory.getLogger(KafkaExportEventResponseService.class);
    private static final String KAFKA_MIA_EXPORT_EVENT_RESPONSE_LISTENER_ID = "kafkaMiaExportEventResponseListenerId";
    private static final String KAFKA_ITF_EXPORT_EVENT_RESPONSE_LISTENER_ID = "kafkaItfExportEventResponseListenerId";
    private final SseEmitterService sseEmitterService;
    private final RequestExportService requestExportService;

    public KafkaExportEventResponseService(SseEmitterService sseEmitterService, RequestExportService requestExportService) {
        this.sseEmitterService = sseEmitterService;
        this.requestExportService = requestExportService;
    }

    @KafkaListener(groupId="kafkaMiaExportEventResponseListenerId_#{T(org.qubership.atp.itf.lite.backend.utils.PodNameUtils).getServicePodName()}", topics={"${kafka.itflite.export.mia.finish.topic}"}, containerFactory="miaExportContainerFactory")
    @Transactional
    public void listenMiaExportResponse(@Payload MiaExportResponseEvent miaExportResponse) throws IOException {
        MDC.clear();
        MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)miaExportResponse.getRequestId());
        this.processExportResponse(miaExportResponse, ImportToolType.MIA);
    }

    @KafkaListener(groupId="kafkaItfExportEventResponseListenerId_#{T(org.qubership.atp.itf.lite.backend.utils.PodNameUtils).getServicePodName()}", topics={"${kafka.itflite.export.itf.finish.topic}"}, containerFactory="itfExportContainerFactory")
    @Transactional
    public void listenItfExportResponse(@Payload ItfExportResponseEvent itfExportResponse) throws IOException {
        MDC.clear();
        MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)itfExportResponse.getRequestId());
        this.processExportResponse(itfExportResponse, ImportToolType.ITF);
    }

    @Transactional
    public void processExportResponse(ExportResponseEvent exportResponse, ImportToolType importToolType) throws IOException {
        log.debug("Start itf-lite export response from {} processing by event from kafka [{}]", (Object)importToolType, (Object)exportResponse);
        log.info("Read {} export response from kafka.", (Object)importToolType);
        UUID requestExportId = exportResponse.getId();
        log.debug("Search sseId by requestExportId = {}", (Object)requestExportId);
        RequestExportEntity requestExportEntity = this.requestExportService.findByRequestExportId(requestExportId);
        UUID sseId = requestExportEntity.getSseId();
        log.debug("Search for sseEmitter with sseId = {}", (Object)sseId);
        SseEmitter sseEmitter = this.sseEmitterService.getEmitter(sseId);
        if (sseEmitter == null) {
            log.debug("Sse emitter with sseId = {} not found.", (Object)sseId);
            return;
        }
        RequestExportStatus status = RequestExportStatus.DONE;
        if (!RequestExportStatus.DONE.name().equalsIgnoreCase(exportResponse.getStatus())) {
            status = RequestExportStatus.ERROR;
        }
        RequestExportResultResponse exportResult = this.buildExportResult(exportResponse, status);
        this.requestExportService.processExportResult(requestExportEntity, exportResult, sseEmitter, importToolType);
    }

    private RequestExportResultResponse buildExportResult(ExportResponseEvent exportResponse, RequestExportStatus requestExportStatus) {
        return RequestExportResultResponse.builder().requestId(exportResponse.getRequestId()).requestUrl(exportResponse.getRequestUrl()).errorDescription(exportResponse.getErrorMessage()).status(requestExportStatus).build();
    }
}

