/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.kafka.listeners;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.feign.service.EnvironmentFeignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentKafkaListener {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentKafkaListener.class);
    private static final String KAFKA_ENVIRONMENT_EVENT_RESPONSE_LISTENER_ID = "kafkaEnvironmentEventResponseListenerId";
    private final EnvironmentFeignService environmentFeignService;

    @Autowired
    public EnvironmentKafkaListener(EnvironmentFeignService environmentFeignService) {
        this.environmentFeignService = environmentFeignService;
    }

    @KafkaListener(groupId="kafkaEnvironmentEventResponseListenerId_#{T(org.qubership.atp.itf.lite.backend.utils.PodNameUtils).getServicePodName()}", topics={"${kafka.environment.notification.topic}"}, containerFactory="environmentContainerFactory")
    public void listenEnvironmentNotificationEvent(@Header(value="kafka_receivedMessageKey") UUID environmentId) {
        this.environmentFeignService.evictEnvironmentSystemsCacheByEnvironmentId(environmentId);
    }
}

