/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.macros;

import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.exceptions.macros.ItfLiteMacrosAtpDecryptException;
import org.qubership.atp.macros.core.parser.antlr4.MacrosParser;
import org.qubership.atp.macros.core.processor.SimpleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContextWithParametersDecrypting
extends SimpleContext {
    private static final Logger log = LoggerFactory.getLogger(SimpleContextWithParametersDecrypting.class);
    private final Decryptor decryptor;

    protected String getArgument(MacrosParser.MacroArgContext arg) {
        String argument = super.getArgument(arg);
        try {
            return this.decryptor.decryptEncryptedPlacesInString(argument);
        }
        catch (AtpDecryptException e) {
            log.error("Error occurred while decrypting macros argument {}", (Object)argument, (Object)e);
            throw new ItfLiteMacrosAtpDecryptException("Argument: " + argument);
        }
    }

    public SimpleContextWithParametersDecrypting(Decryptor decryptor) {
        this.decryptor = decryptor;
    }
}

