/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.service.rest;

import java.net.HttpCookie;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.itf.lite.backend.configuration.HttpClientProperties;
import org.qubership.atp.itf.lite.backend.exceptions.internal.ItfLiteSslCertificateVerificationFileException;
import org.qubership.atp.itf.lite.backend.exceptions.internal.ItfLiteSslClientVerificationFileException;
import org.qubership.atp.itf.lite.backend.feign.dto.CertificateDto;
import org.qubership.atp.itf.lite.backend.model.RequestRuntimeOptions;
import org.qubership.atp.itf.lite.backend.service.CertificateService;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@EnableConfigurationProperties(value={HttpClientProperties.class})
public class HttpClientService {
    private static final Logger log = LoggerFactory.getLogger(HttpClientService.class);
    private final HttpClientProperties httpClientProperties;
    private final CertificateService certificateService;
    private final EncryptionService encryptionService;

    public CloseableHttpClient getHttpClient(UUID projectId) {
        return this.getHttpClient(projectId, new RequestRuntimeOptions(), "", null);
    }

    public CloseableHttpClient getHttpClient(UUID projectId, RequestRuntimeOptions runtimeOptions) {
        return this.getHttpClient(projectId, runtimeOptions, "", null);
    }

    public CloseableHttpClient getHttpClient(UUID projectId, RequestRuntimeOptions runtimeOptions, String requestUrl, CookieStore cookieStore) {
        RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectionRequestTimeout(this.httpClientProperties.getRequestTimeout()).setConnectTimeout(this.httpClientProperties.getConnectionTimeout()).setSocketTimeout(this.httpClientProperties.getSocketTimeout());
        if (runtimeOptions.isDisableFollowingRedirect()) {
            configBuilder.setRedirectsEnabled(false);
        }
        RequestConfig requestConfig = configBuilder.build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)this.poolingConnectionManager(projectId, runtimeOptions, requestUrl)).setKeepAliveStrategy(this.connectionKeepAliveStrategy());
        if (runtimeOptions.isDisableFollowingRedirect()) {
            httpClientBuilder.disableRedirectHandling();
        }
        if (Objects.nonNull(cookieStore)) {
            httpClientBuilder.setDefaultCookieStore(cookieStore);
        }
        return httpClientBuilder.build();
    }

    private PoolingHttpClientConnectionManager poolingConnectionManager(UUID projectId) {
        return this.poolingConnectionManager(projectId, new RequestRuntimeOptions(), "");
    }

    private PoolingHttpClientConnectionManager poolingConnectionManager(UUID projectId, RequestRuntimeOptions runtimeOptions) {
        return this.poolingConnectionManager(projectId, runtimeOptions, "");
    }

    private PoolingHttpClientConnectionManager poolingConnectionManager(UUID projectId, RequestRuntimeOptions runtimeOptions, String requestUrl) {
        boolean enableSslCertificateVerification = !runtimeOptions.isDisableSslCertificateVerification();
        boolean enableSslClientCertificate = !runtimeOptions.isDisableSslClientCertificate();
        SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
        if (enableSslCertificateVerification || enableSslClientCertificate) {
            char[] pass;
            CertificateDto cert = this.certificateService.getCertificate(projectId);
            enableSslCertificateVerification = !runtimeOptions.isDisableSslCertificateVerification() && BooleanUtils.toBoolean((Boolean)cert.getEnableCertificateVerification());
            boolean bl = enableSslClientCertificate = !runtimeOptions.isDisableSslClientCertificate() && BooleanUtils.toBoolean((Boolean)cert.getEnableClientCertificate());
            if ((enableSslCertificateVerification || enableSslClientCertificate) && StringUtils.isNotEmpty((CharSequence)requestUrl)) {
                String host = UriComponentsBuilder.fromHttpUrl((String)requestUrl).build().getHost();
                if (enableSslCertificateVerification && !CollectionUtils.isEmpty(cert.getTrustStoreDomainNames()) && !this.matchesAnyOfDomainsArray(cert.getTrustStoreDomainNames(), host)) {
                    enableSslCertificateVerification = false;
                }
                if (enableSslClientCertificate && !CollectionUtils.isEmpty(cert.getKeyStoreDomainNames()) && !this.matchesAnyOfDomainsArray(cert.getKeyStoreDomainNames(), host)) {
                    enableSslClientCertificate = false;
                }
            }
            if (enableSslCertificateVerification) {
                try {
                    sslContextBuilder.setProtocol(cert.getProtocol());
                    pass = this.encryptionService.decryptIfEncrypted(cert.getTrustStorePassphrase()).toCharArray();
                    sslContextBuilder.loadTrustMaterial(this.certificateService.getCertificateVerificationFile(projectId), pass);
                }
                catch (AtpException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error("Failed to apply SSL verification file for project '{}'", (Object)projectId, (Object)e);
                    throw new ItfLiteSslCertificateVerificationFileException();
                }
            }
            if (enableSslClientCertificate) {
                try {
                    pass = this.encryptionService.decryptIfEncrypted(cert.getKeyStorePassphrase()).toCharArray();
                    sslContextBuilder.loadKeyMaterial(this.certificateService.getClientCertificateFile(projectId), pass, pass);
                }
                catch (AtpException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error("Failed to apply SSL client certificate file for project '{}'", (Object)projectId, (Object)e);
                    throw new ItfLiteSslClientVerificationFileException();
                }
            }
        }
        if (!enableSslCertificateVerification && !enableSslClientCertificate) {
            try {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy());
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                log.error("Pooling Connection Manager Initialisation failure because of " + e.getMessage(), (Throwable)e);
            }
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("Pooling Connection Manager Initialisation failure because of " + e.getMessage(), (Throwable)e);
        }
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory());
        if (sslConnectionSocketFactory != null) {
            registryBuilder.register("https", (Object)sslConnectionSocketFactory);
        }
        Registry socketFactoryRegistry = registryBuilder.build();
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        poolingConnectionManager.setMaxTotal(this.httpClientProperties.getMaxTotalConnections());
        return poolingConnectionManager;
    }

    private boolean matchesAnyOfDomainsArray(List<String> domains, String host) {
        return domains.stream().anyMatch(domain -> HttpCookie.domainMatches(domain, host));
    }

    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy() {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator responseHeaderIterator = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (responseHeaderIterator.hasNext()) {
                    HeaderElement headerElement = responseHeaderIterator.nextElement();
                    String param = headerElement.getName();
                    String value = headerElement.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return HttpClientService.this.httpClientProperties.getDefaultKeepAliveTimeMillis();
            }
        };
    }

    @Bean
    public Runnable idleConnectionMonitor(final PoolingHttpClientConnectionManager connectionManager) {
        return new Runnable(){

            @Override
            @Scheduled(fixedDelay=10000L)
            public void run() {
                try {
                    if (connectionManager != null) {
                        log.trace("run IdleConnectionMonitor - Closing expired and idle connections...");
                        connectionManager.closeExpiredConnections();
                        connectionManager.closeIdleConnections((long)HttpClientService.this.httpClientProperties.getCloseIdleConnectionWaitTimeSecs(), TimeUnit.SECONDS);
                    } else {
                        log.trace("run IdleConnectionMonitor - Http Client Connection manager is not initialised");
                    }
                }
                catch (Exception e) {
                    log.error("run IdleConnectionMonitor - Exception occurred. msg={}, e={}", (Object)e.getMessage(), (Object)e);
                }
            }
        };
    }

    public HttpClientService(HttpClientProperties httpClientProperties, CertificateService certificateService, EncryptionService encryptionService) {
        this.httpClientProperties = httpClientProperties;
        this.certificateService = certificateService;
        this.encryptionService = encryptionService;
    }
}

