/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.utils;

import java.net.HttpCookie;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.cookie.ClientCookie;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.exceptions.cookie.IllegalCookieException;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanCookieDto;
import org.qubership.atp.itf.lite.backend.model.api.dto.CookieDto;
import org.qubership.atp.itf.lite.backend.model.api.dto.CookiesDto;
import org.qubership.atp.itf.lite.backend.model.api.dto.ResponseCookie;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CookieUtils {
    private static final Logger log = LoggerFactory.getLogger(CookieUtils.class);
    private static final ModelMapper modelMapper = new ModelMapper();

    public static List<Cookie> convertToCookieList(List<CookiesDto> cookiesDto) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        cookiesDto.forEach(cookieDto -> {
            String domain = cookieDto.getDomain();
            cookieDto.getCookies().forEach(c -> {
                Cookie newCookie = new Cookie();
                newCookie.setDomain(domain);
                newCookie.setKey(c.getKey());
                newCookie.setValue(c.getValue());
                newCookie.setDisabled(c.isDisabled());
                cookies.add(newCookie);
            });
        });
        return cookies;
    }

    public static List<CookiesDto> convertToCookiesDtoList(List<Cookie> cookies) {
        Map<String, List<Cookie>> mappedCookies = StreamUtils.toEntityListMap(cookies, Cookie::getDomain);
        ArrayList<CookiesDto> cookiesDto = new ArrayList<CookiesDto>();
        mappedCookies.forEach((domain, cookie) -> {
            ArrayList<CookieDto> listCookies = new ArrayList<CookieDto>();
            cookie.forEach(c -> listCookies.add((CookieDto)modelMapper.map(c, CookieDto.class)));
            cookiesDto.add(new CookiesDto((String)domain, (List<CookieDto>)listCookies));
        });
        return cookiesDto;
    }

    public static List<Cookie> convertPostmanCookieDtoListToCookieList(List<PostmanCookieDto> cookiesDto) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        cookiesDto.forEach(cookieDto -> {
            Cookie newCookie = new Cookie();
            List<HttpCookie> parsedCookies = HttpCookie.parse(cookieDto.getValue());
            newCookie.setKey(cookieDto.getKey());
            newCookie.setValue(cookieDto.getValue());
            newCookie.setDomain(parsedCookies.get(0).getDomain());
            cookies.add(newCookie);
        });
        return cookies;
    }

    public static List<PostmanCookieDto> convertCookieListToPostmanCookieDtoList(List<Cookie> cookies) {
        ArrayList<PostmanCookieDto> postmanCookieDtos = new ArrayList<PostmanCookieDto>();
        cookies.forEach(cookie -> {
            if (!cookie.isDisabled()) {
                PostmanCookieDto postmanCookieDto = new PostmanCookieDto();
                postmanCookieDto.setKey(cookie.getKey());
                postmanCookieDto.setValue(CookieUtils.collectToString(cookie));
                postmanCookieDtos.add(postmanCookieDto);
            }
        });
        return postmanCookieDtos;
    }

    private static String collectToString(Cookie cookie) {
        String valueCookie = cookie.getValue();
        if (cookie.getValue().toLowerCase().contains("domain")) {
            return valueCookie;
        }
        if (!StringUtils.isEmpty((Object)cookie.getDomain())) {
            return valueCookie + " Domain=" + cookie.getDomain() + ";";
        }
        return valueCookie;
    }

    public static List<Cookie> convertResponseCookieListToCookieList(List<ResponseCookie> responseCookieList) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        responseCookieList.forEach(responseCookie -> cookies.add(CookieUtils.convertResponseCookieToCookie(responseCookie)));
        return cookies;
    }

    public static Cookie convertResponseCookieToCookie(ResponseCookie respCookie) {
        Cookie newCookie = new Cookie();
        newCookie.setKey(respCookie.getName());
        newCookie.setValue(CookieUtils.getValueByResponseCookie(respCookie));
        newCookie.setDomain(respCookie.getDomain());
        return newCookie;
    }

    public static List<Cookie> parseCookieHeader(String domain, String headerValue) {
        if (StringUtils.isEmpty((Object)domain)) {
            log.error("Domain is null");
            throw new IllegalCookieException("Domain can not be null or empty");
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        List<HttpCookie> parsedCookies = HttpCookie.parse(headerValue);
        parsedCookies.forEach(parsedCookie -> {
            Cookie newCookie = new Cookie();
            newCookie.setKey(parsedCookie.getName());
            newCookie.setValue(CookieUtils.httpCookieToString(parsedCookie));
            newCookie.setDomain(StringUtils.isEmpty((Object)parsedCookie.getDomain()) ? domain : parsedCookie.getDomain());
            cookies.add(newCookie);
        });
        return cookies;
    }

    public static List<ResponseCookie> convertCookieListToResponseCookieList(List<Cookie> cookies) {
        if (Objects.isNull(cookies)) {
            return null;
        }
        ArrayList<ResponseCookie> responseCookies = new ArrayList<ResponseCookie>();
        cookies.forEach(cookie -> {
            ResponseCookie newCookie = new ResponseCookie();
            newCookie.setName(cookie.getKey());
            newCookie.setDomain(cookie.getDomain());
            List<HttpCookie> parsedCookies = HttpCookie.parse(cookie.getValue());
            newCookie.setValue(parsedCookies.get(0).getValue());
            newCookie.setPath(parsedCookies.get(0).getPath());
            newCookie.setExpires(CookieUtils.timestampToCookieDate(System.currentTimeMillis() + parsedCookies.get(0).getMaxAge() * 1000L));
            newCookie.setHttpOnly(parsedCookies.get(0).isHttpOnly());
            newCookie.setSecure(parsedCookies.get(0).getSecure());
            responseCookies.add(newCookie);
        });
        return responseCookies;
    }

    public static String getValueByResponseCookie(ResponseCookie responseCookie) {
        StringBuilder sb = new StringBuilder();
        sb.append(responseCookie.getName()).append('=').append(responseCookie.getValue());
        if (!StringUtils.isEmpty((Object)responseCookie.getDomain())) {
            sb.append("; Domain=").append(responseCookie.getDomain());
        }
        if (!StringUtils.isEmpty((Object)responseCookie.getPath())) {
            sb.append("; Path=").append(responseCookie.getPath());
        }
        if (!StringUtils.isEmpty((Object)responseCookie.getExpires())) {
            sb.append("; Expires=").append(responseCookie.getExpires());
        }
        if (responseCookie.isHttpOnly()) {
            sb.append("; HttpOnly");
        }
        if (responseCookie.isSecure()) {
            sb.append("; Secure");
        }
        return sb.toString();
    }

    public static String timestampToCookieDate(long timestamp) {
        Date expdate = new Date();
        expdate.setTime(timestamp);
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(expdate);
    }

    public static String dateToCookieDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(date);
    }

    private static String httpCookieToString(HttpCookie httpCookie) {
        StringJoiner sj = new StringJoiner("; ");
        if (StringUtils.isEmpty((Object)httpCookie.getName())) {
            log.error("Cookie name is empty");
            throw new IllegalCookieException("Cookie name can not be empty");
        }
        String value = httpCookie.getValue();
        sj.add(String.format("%s=%s", httpCookie.getName(), Objects.isNull(value) ? "" : value));
        if (!StringUtils.isEmpty((Object)httpCookie.getDomain())) {
            sj.add(String.format("%s=%s", "Domain", httpCookie.getDomain()));
        }
        if (!StringUtils.isEmpty((Object)httpCookie.getPath())) {
            sj.add(String.format("%s=%s", "Path", httpCookie.getPath()));
        }
        if (httpCookie.getMaxAge() > -1L) {
            sj.add(String.format("%s=%s", "Expires", CookieUtils.timestampToCookieDate(System.currentTimeMillis() + httpCookie.getMaxAge() * 1000L)));
        }
        if (httpCookie.getSecure()) {
            sj.add(String.format("%s", "Secure"));
        }
        if (httpCookie.isHttpOnly()) {
            sj.add(String.format("%s", "HttpOnly"));
        }
        return sj.toString();
    }

    public static List<ResponseCookie> parseResponseCookie(String requestDomain, List<org.apache.http.cookie.Cookie> responseCookies) {
        ArrayList<ResponseCookie> respCookies = new ArrayList<ResponseCookie>();
        responseCookies.forEach(respCookie -> {
            ClientCookie cc;
            String httpOnly;
            ResponseCookie c = new ResponseCookie();
            c.setName(respCookie.getName());
            c.setValue(respCookie.getValue());
            if (StringUtils.isEmpty((Object)respCookie.getDomain())) {
                c.setDomain(requestDomain);
            } else {
                c.setDomain(respCookie.getDomain());
            }
            c.setPath(respCookie.getPath());
            if (respCookie.isPersistent()) {
                c.setExpires(CookieUtils.dateToCookieDate(respCookie.getExpiryDate()));
            }
            c.setSecure(respCookie.isSecure());
            if (respCookie instanceof ClientCookie && Objects.nonNull(httpOnly = (cc = (ClientCookie)respCookie).getAttribute("httponly"))) {
                c.setHttpOnly(Boolean.parseBoolean(httpOnly));
            }
            respCookies.add(c);
        });
        return respCookies;
    }

    public static List<Cookie> addResponseCookie(List<Cookie> requestCookies, List<ResponseCookie> responseCookies) {
        Map cookieMap = requestCookies.stream().collect(Collectors.toMap(CookieUtils::getNameWithDomain, Function.identity()));
        responseCookies.forEach(respCookie -> cookieMap.put(CookieUtils.getNameWithDomain(respCookie), CookieUtils.convertResponseCookieToCookie(respCookie)));
        return new ArrayList<Cookie>(cookieMap.values());
    }

    private static String getNameWithDomain(Cookie cookie) {
        return cookie.getKey() + "-" + cookie.getDomain();
    }

    private static String getNameWithDomain(ResponseCookie cookie) {
        return cookie.getName() + "-" + cookie.getDomain();
    }
}

