/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractEntity;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractNamedEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);
    private static final ModelMapper modelMapper = new ModelMapper();

    public static <T> Set<UUID> extractIds(Collection<T> entities, Function<T, UUID> extractor) {
        if (entities == null) {
            return Collections.emptySet();
        }
        return StreamUtils.getIdsStream(entities, extractor).collect(Collectors.toSet());
    }

    public static <T extends AbstractEntity> Set<UUID> extractIds(Collection<T> entities) {
        return StreamUtils.extractIds(entities, AbstractEntity::getId);
    }

    public static <T> Set<UUID> extractFlatIds(Collection<T> entities, Function<T, Collection<UUID>> extractor) {
        if (entities == null) {
            return Collections.emptySet();
        }
        return StreamUtils.getFlatIdsStream(entities, extractor).collect(Collectors.toSet());
    }

    private static <T> Stream<UUID> getIdsStream(Collection<T> entities, Function<T, UUID> extractor) {
        return entities.stream().map(extractor).filter(Objects::nonNull);
    }

    private static <T> Stream<UUID> getFlatIdsStream(Collection<T> entities, Function<T, Collection<UUID>> extractor) {
        return entities.stream().filter(elem -> !CollectionUtils.isEmpty((Collection)((Collection)extractor.apply(elem)))).flatMap(elem -> ((Collection)extractor.apply(elem)).stream());
    }

    private static <T> Stream<T> stream(Iterable<T> entities) {
        return StreamSupport.stream(entities.spliterator(), false);
    }

    public static <T> Map<UUID, T> toIdEntityMap(Iterable<T> entities, Function<T, UUID> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, Function.identity()));
    }

    public static <T extends AbstractNamedEntity> Map<UUID, T> toIdEntityMap(Iterable<T> entities) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(AbstractEntity::getId, Function.identity()));
    }

    public static <T, R> Map<R, T> toEntityMap(Iterable<T> entities, Function<T, R> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, Function.identity()));
    }

    public static <T, R> Map<R, T> toEntityMapWithMergeFunction(Iterable<T> entities, Function<T, R> keyExtractor, BinaryOperator<T> mergeFunction) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, Function.identity(), mergeFunction));
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> entities, Function<T, K> keyExtractor, Function<T, V> valueExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, valueExtractor));
    }

    public static <T extends AbstractNamedEntity> Map<UUID, String> toIdNameEntityMap(Iterable<T> entities) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(AbstractEntity::getId, AbstractNamedEntity::getName));
    }

    public static <S, T> Map<S, List<T>> toEntityListMap(Iterable<T> entities, Function<T, S> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.groupingBy(keyExtractor));
    }

    public static <T> List<T> toEntityList(Iterable<T> entities) {
        return StreamUtils.stream(entities).collect(Collectors.toList());
    }

    public static <T, R> List<R> mapToClazz(Iterable<T> entities, Class<R> clazz) {
        return StreamUtils.stream(entities).map(entity -> modelMapper.map(entity, clazz)).collect(Collectors.toList());
    }

    public static <T, R> R mapToClazz(T entity, Class<R> clazz) {
        return (R)modelMapper.map(entity, clazz);
    }

    public static <T, R> Set<R> extractFields(Collection<T> entities, Function<T, R> extractor) {
        if (entities == null) {
            return Collections.emptySet();
        }
        return entities.stream().map(extractor).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T, R> List<R> map(Collection<T> entities, Function<T, R> mapFunc) {
        return entities.stream().map(mapFunc).collect(Collectors.toList());
    }

    public static <T extends AbstractNamedEntity> List<T> filterList(Collection<T> entities, Collection<UUID> containKeys) {
        return entities.stream().filter(entity -> containKeys.contains(entity.getId())).collect(Collectors.toList());
    }

    public static <T extends AbstractNamedEntity> List<T> filterList(Collection<T> entities, Predicate<T> predicate) {
        return entities.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T> List<T> filterList(Collection<T> entities, Function<T, UUID> entityKeyExtractFunc, Collection<UUID> containKeys) {
        return entities.stream().filter(entity -> containKeys.contains(entityKeyExtractFunc.apply(entity))).collect(Collectors.toList());
    }

    public static <T extends AbstractNamedEntity> T find(Collection<T> entities, Predicate<T> predicate) {
        return (T)((AbstractNamedEntity)entities.stream().filter(predicate).findFirst().orElseThrow(() -> new IllegalStateException("Failed to find element in list")));
    }

    public static <T> List<T> getEntitiesFromMap(Set<UUID> ids, Map<UUID, T> entitiesMap) {
        return ids.stream().map(entitiesMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> T getFirstElem(List<T> elements) {
        if (!CollectionUtils.isEmpty(elements)) {
            return elements.get(0);
        }
        log.error("Failed to find first list element");
        throw new IllegalStateException("Failed to find first list element");
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private StreamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

