/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;

public class UrlParsingUtils {
    public static void parseUrlAndRequestParams(HttpRequest httpRequest, String token) {
        String[] splitOption = token.split("\\?");
        httpRequest.setUrl(splitOption[0]);
        if (splitOption.length > 1) {
            List<RequestParam> requestParams = UrlParsingUtils.parseRequestParams(splitOption[1]);
            httpRequest.setRequestParams(requestParams);
        } else {
            httpRequest.setRequestParams(new ArrayList<RequestParam>());
        }
    }

    public static String getDomain(String url) {
        return url.replaceAll("http(s)?://|www\\.|:.*|/.*", "");
    }

    public static List<RequestParam> parseRequestParams(String paramsString) {
        List<String> parameters = Arrays.asList(paramsString.split("&"));
        ArrayList<RequestParam> params = new ArrayList<RequestParam>();
        parameters.forEach(parameter -> {
            String[] keyValue = parameter.split("=");
            String key = keyValue[0];
            String value = "";
            if (keyValue.length > 1) {
                value = keyValue[1];
            }
            params.add(new RequestParam(UUID.randomUUID(), key, value, "", false));
        });
        return params;
    }
}

