/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.itf.lite.backend.converters.history;

import java.util.Objects;

import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.feign.dto.history.AuthorizationDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.HistoryItemTypeDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.HttpRequestHistoryDto;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.springframework.stereotype.Component;

@Component
public class HttpRequestVersioningMapper extends AbstractVersioningMapper<HttpRequest, HttpRequestHistoryDto> {

    public HttpRequestVersioningMapper(ModelMapper mapper) {
        super(HttpRequest.class, HttpRequestHistoryDto.class, mapper);
    }

    @Override
    HistoryItemTypeDto getEntityTypeEnum() {
        return HistoryItemTypeDto.REQUEST;
    }

    @Override
    void mapSpecificFields(HttpRequest source, HttpRequestHistoryDto destination) {
        super.mapSpecificFields(source, destination);
        if (Objects.nonNull(source.getAuthorization())) {
            destination.setAuthorization(mapper.map(source.getAuthorization(), AuthorizationDto.class));
        }
    }
}
