/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.auth;

import java.util.Objects;
import java.util.function.Consumer;
import org.codehaus.commons.compiler.util.Producer;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.crypt.exception.AtpEncryptException;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractAuthorizationStrategy
implements RequestAuthorizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthorizationStrategy.class);
    public static final String TO_ENCRYPT_FLAG = "{2ENC}";
    private static final String IS_ENCRYPTED_FLAG = "{ENC}";
    protected final EncryptionService encryptionService;
    protected static final String AUTH_HEADER_KEY = "Authorization";
    protected static final String CALCULATED_VALUE = "<calculated when request is sent>";

    protected void decodeParameter(Producer<String> getter, Consumer<String> setter) {
        String paramValue = (String)getter.produce();
        if (Objects.nonNull(paramValue) && paramValue.startsWith(TO_ENCRYPT_FLAG)) {
            paramValue = paramValue.replace(TO_ENCRYPT_FLAG, "");
            paramValue = this.encryptionService.decodeBase64(paramValue);
            setter.accept(paramValue);
        }
    }

    protected void decryptParameter(Producer<String> getter, Consumer<String> setter) {
        String paramValue = (String)getter.produce();
        if (Objects.nonNull(paramValue) && paramValue.startsWith(IS_ENCRYPTED_FLAG)) {
            try {
                paramValue = this.encryptionService.decrypt(paramValue);
            }
            catch (AtpDecryptException err) {
                log.error("Failed to decrypt parameter for request authorization", (Throwable)err);
                throw new IllegalStateException("Failed to decrypt parameter for request authorization");
            }
            setter.accept(paramValue);
        }
    }

    protected void encryptParameter(Producer<String> getter, Consumer<String> setter) {
        String paramValue = (String)getter.produce();
        if (Objects.nonNull(paramValue) && paramValue.startsWith(TO_ENCRYPT_FLAG)) {
            this.decodeParameter(getter, setter);
            paramValue = (String)getter.produce();
            try {
                paramValue = this.encryptionService.encrypt(paramValue);
            }
            catch (AtpEncryptException err) {
                log.error("Failed to encrypt parameter for request authorization", (Throwable)err);
                throw new IllegalStateException("Failed to encrypt parameter for request authorization");
            }
            setter.accept(paramValue);
        }
    }

    public AbstractAuthorizationStrategy(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }
}

