/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.auth.AbstractAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationRegistry;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.exceptions.ItfLiteException;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyRequest;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyResponse;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationResolvingContext;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.InheritFromParentAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.auth.OAuth2AuthrizationResponse;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.auth.InheritFromParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.qubership.atp.itf.lite.backend.service.FolderService;
import org.qubership.atp.itf.lite.backend.utils.AuthorizationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class InheritFromParentAuthorizationStrategy
extends AbstractAuthorizationStrategy
implements RequestAuthorizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(InheritFromParentAuthorizationStrategy.class);
    private FolderService folderService;
    private RequestAuthorizationRegistry requestAuthorizationRegistry;

    public InheritFromParentAuthorizationStrategy(EncryptionService encryptionService) {
        super(encryptionService);
    }

    @Autowired
    public void setRequestAuthorizationRegistry(@Lazy RequestAuthorizationRegistry requestAuthorizationRegistry) {
        this.requestAuthorizationRegistry = requestAuthorizationRegistry;
    }

    @Autowired
    public void setFolderService(@Lazy FolderService folderService) {
        this.folderService = folderService;
    }

    @Override
    public AuthorizationStrategyResponse getAuthorizationToken(AuthorizationStrategyRequest authorizationStrategyRequest) throws AtpDecryptException {
        UUID authorizationFolderId;
        Folder authFolder;
        RequestAuthorization authorization;
        InheritFromParentAuthorizationSaveRequest inheritFromParentAuthorizationSaveRequest = (InheritFromParentAuthorizationSaveRequest)authorizationStrategyRequest.getUnsafeAuthorizationRequest();
        if (Objects.nonNull(inheritFromParentAuthorizationSaveRequest.getAuthorizationFolderId()) && Objects.nonNull(authorization = (authFolder = this.folderService.getFolder(authorizationFolderId = inheritFromParentAuthorizationSaveRequest.getAuthorizationFolderId())).getAuthorization())) {
            AuthorizationSaveRequest newAuthSaveRequest = AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
            try {
                AuthorizationResolvingContext authResolvingContext = authorizationStrategyRequest.getAuthResolvingContext();
                AuthorizationStrategyRequest newAuthStrategyRequest = AuthorizationUtils.createAuthStrategyRequest(newAuthSaveRequest, authorizationStrategyRequest.getEvaluator(), authorizationStrategyRequest.getResolvingContext(), authorizationStrategyRequest.getProjectId(), authorizationStrategyRequest.getEnvironmentId(), Objects.nonNull(authResolvingContext) ? authResolvingContext.getUrl() : null, Objects.nonNull(authResolvingContext) ? authResolvingContext.getHttpMethod() : null);
                return this.requestAuthorizationRegistry.getRequestAuthorizationStrategy(authorization.getType()).getAuthorizationToken(newAuthStrategyRequest);
            }
            catch (JsonProcessingException ex) {
                log.error("Failed to create authorizationStrategyRequest", (Throwable)ex);
                throw new ItfLiteException("Failed to evaluate authorization");
            }
        }
        return null;
    }

    @Override
    public void encryptParameters(AuthorizationSaveRequest requestAuthorization) {
    }

    @Override
    public void decryptParameters(AuthorizationSaveRequest requestAuthorization) {
    }

    @Override
    public OAuth2AuthrizationResponse performAuthorization(UUID projectId, String url, MultiValueMap<String, String> map) {
        return null;
    }

    @Override
    public RequestAuthorizationType getAuthorizationType() {
        return RequestAuthorizationType.INHERIT_FROM_PARENT;
    }

    @Override
    public RequestAuthorization parseAuthorizationFromMap(Map<String, String> authorizationInfo) {
        InheritFromParentRequestAuthorization authRequest = new InheritFromParentRequestAuthorization();
        authRequest.setType(RequestAuthorizationType.INHERIT_FROM_PARENT);
        return authRequest;
    }

    @Override
    @Nullable
    public RequestHeader generateAuthorizationHeader(RequestAuthorization authorization) {
        RequestAuthorization parentAuthorization = this.getParentAuthorization(authorization);
        if (Objects.nonNull(parentAuthorization) && Objects.nonNull((Object)parentAuthorization.getType())) {
            return this.requestAuthorizationRegistry.getRequestAuthorizationStrategy(parentAuthorization.getType()).generateAuthorizationHeader(parentAuthorization);
        }
        log.warn("Parent folder not contains authorization or auth type. Authorization header not generated");
        return null;
    }

    @Override
    public List<RequestParam> generateAuthorizationParams(RequestAuthorization authorization) {
        RequestAuthorization parentAuthorization = this.getParentAuthorization(authorization);
        if (Objects.nonNull(parentAuthorization) && Objects.nonNull((Object)parentAuthorization.getType())) {
            return this.requestAuthorizationRegistry.getRequestAuthorizationStrategy(parentAuthorization.getType()).generateAuthorizationParams(parentAuthorization);
        }
        log.warn("Parent folder not contains authorization or auth type. Authorization header not generated");
        return null;
    }

    private RequestAuthorization getParentAuthorization(RequestAuthorization authorization) {
        InheritFromParentAuthorizationSaveRequest inheritAuth = (InheritFromParentAuthorizationSaveRequest)AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
        UUID authorizationFolderId = inheritAuth.getAuthorizationFolderId();
        if (Objects.isNull(authorizationFolderId)) {
            log.debug("Parent folder not set. Authorization header not generated");
            return null;
        }
        Folder authFolder = this.folderService.getFolder(authorizationFolderId);
        return authFolder.getAuthorization();
    }
}

