/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.auth;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.commons.compiler.util.Producer;
import org.jetbrains.annotations.Nullable;
import org.modelmapper.ModelMapper;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.auth.AbstractAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.enums.auth.OAuth1AddDataType;
import org.qubership.atp.itf.lite.backend.enums.auth.OAuth1SignatureMethod;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyRequest;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyResponse;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationResolvingContext;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.OAuth1AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.auth.OAuth2AuthrizationResponse;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth1RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.qubership.atp.itf.lite.backend.utils.AuthorizationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class OAuth1RequestAuthorizationStrategy
extends AbstractAuthorizationStrategy
implements RequestAuthorizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(OAuth1RequestAuthorizationStrategy.class);
    private static final String OAUTH_VERSION = "1.0";
    private static final String CALCULATED_VALUE = "<calculated when request is sent>";
    private static final String MASKED_VALUE = "******";
    private ModelMapper modelMapper;

    public OAuth1RequestAuthorizationStrategy(EncryptionService encryptionService, ModelMapper modelMapper) {
        super(encryptionService);
        this.modelMapper = modelMapper;
    }

    @Override
    public AuthorizationStrategyResponse getAuthorizationToken(AuthorizationStrategyRequest request) throws AtpDecryptException {
        OAuth1AuthorizationSaveRequest authorization = (OAuth1AuthorizationSaveRequest)request.getUnsafeAuthorizationRequest();
        AuthorizationResolvingContext authResolvingContext = request.getAuthResolvingContext();
        Map<String, String> oauthParams = this.getOauthParams(authorization, authResolvingContext);
        OAuth1AddDataType addDataType = authorization.getAddDataType();
        switch (addDataType) {
            case REQUEST_HEADERS: {
                String authHeader = this.generateAuthorizationHeader(oauthParams);
                return new AuthorizationStrategyResponse(authHeader, authHeader);
            }
            case REQUEST_URL: {
                return new AuthorizationStrategyResponse(oauthParams);
            }
        }
        throw new IllegalArgumentException("Unsupported add data type: " + (Object)((Object)addDataType));
    }

    private Map<String, String> getOauthParams(OAuth1AuthorizationSaveRequest authorization, AuthorizationResolvingContext authResolvingContext) {
        this.decryptParameters(authorization);
        String url = authorization.getUrl();
        String httpMethod = authorization.getHttpMethod();
        if (Objects.isNull(url) && Objects.isNull(httpMethod)) {
            url = authResolvingContext.getUrl();
            httpMethod = authResolvingContext.getHttpMethod().toString();
        }
        OAuth1SignatureMethod signatureMethod = authorization.getSignatureMethod();
        String consumerKey = authorization.getConsumerKey();
        String consumerSecret = authorization.getConsumerSecret();
        String token = authorization.getAccessToken();
        String tokenSecret = authorization.getTokenSecret();
        TreeMap<String, String> oauthParams = new TreeMap<String, String>();
        oauthParams.put("oauth_consumer_key", consumerKey);
        oauthParams.put("oauth_nonce", this.getNonce());
        oauthParams.put("oauth_signature_method", signatureMethod.getKey());
        oauthParams.put("oauth_timestamp", this.getTimestamp());
        oauthParams.put("oauth_version", OAUTH_VERSION);
        if (Objects.nonNull(token) && Objects.nonNull(tokenSecret)) {
            oauthParams.put("oauth_token", token);
        }
        String baseString = this.getSignatureBaseString(oauthParams, url, httpMethod);
        String signingKey = this.percentEncode(consumerSecret) + "&" + (tokenSecret != null ? this.percentEncode(tokenSecret) : "");
        String signature = this.generateSignature(baseString, signingKey, signatureMethod.getKey());
        oauthParams.put("oauth_signature", signature);
        return oauthParams;
    }

    private String getSignatureBaseString(Map<String, String> oauthParams, String url, String httpMethod) {
        StringBuilder baseString = new StringBuilder();
        baseString.append(httpMethod).append("&");
        baseString.append(this.percentEncode(url)).append("&");
        StringBuilder paramString = new StringBuilder();
        for (Map.Entry<String, String> entry : oauthParams.entrySet()) {
            paramString.append(this.percentEncode(entry.getKey())).append("=").append(this.percentEncode(entry.getValue())).append("&");
        }
        paramString.deleteCharAt(paramString.length() - 1);
        baseString.append(this.percentEncode(paramString.toString()));
        return baseString.toString();
    }

    private String generateSignature(String data, String key, String algorithm) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to generate HMAC", e);
        }
    }

    private String percentEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getNonce() {
        return Long.toString(System.currentTimeMillis());
    }

    private String getTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    @Override
    public void encryptParameters(AuthorizationSaveRequest requestAuthorization) {
        OAuth1AuthorizationSaveRequest authorization = (OAuth1AuthorizationSaveRequest)requestAuthorization;
        this.encryptParameter((Producer<String>)((Producer)authorization::getConsumerKey), authorization::setConsumerKey);
        this.encryptParameter((Producer<String>)((Producer)authorization::getConsumerSecret), authorization::setConsumerSecret);
        this.encryptParameter((Producer<String>)((Producer)authorization::getAccessToken), authorization::setAccessToken);
        this.encryptParameter((Producer<String>)((Producer)authorization::getTokenSecret), authorization::setTokenSecret);
    }

    @Override
    public void decryptParameters(AuthorizationSaveRequest requestAuthorization) {
        OAuth1AuthorizationSaveRequest authorization = (OAuth1AuthorizationSaveRequest)requestAuthorization;
        this.decryptParameter((Producer<String>)((Producer)authorization::getConsumerKey), authorization::setConsumerKey);
        this.decryptParameter((Producer<String>)((Producer)authorization::getConsumerSecret), authorization::setConsumerSecret);
        this.decryptParameter((Producer<String>)((Producer)authorization::getAccessToken), authorization::setAccessToken);
        this.decryptParameter((Producer<String>)((Producer)authorization::getTokenSecret), authorization::setTokenSecret);
    }

    @Override
    public OAuth2AuthrizationResponse performAuthorization(UUID projectId, String url, MultiValueMap<String, String> map) {
        return null;
    }

    @Override
    public RequestAuthorizationType getAuthorizationType() {
        return RequestAuthorizationType.OAUTH1;
    }

    @Override
    public RequestAuthorization parseAuthorizationFromMap(Map<String, String> authorizationInfo) {
        OAuth1AuthorizationSaveRequest authorizationSaveRequest = new OAuth1AuthorizationSaveRequest();
        authorizationSaveRequest.setType(RequestAuthorizationType.OAUTH1);
        String signatureMethodKey = authorizationInfo.getOrDefault("signatureMethod", "");
        authorizationSaveRequest.setSignatureMethod(OAuth1SignatureMethod.fromKey(signatureMethodKey));
        authorizationSaveRequest.setConsumerKey(authorizationInfo.getOrDefault("consumerKey", ""));
        authorizationSaveRequest.setConsumerSecret(authorizationInfo.getOrDefault("consumerSecret", ""));
        authorizationSaveRequest.setAccessToken(authorizationInfo.getOrDefault("token", ""));
        authorizationSaveRequest.setTokenSecret(authorizationInfo.getOrDefault("tokenSecret", ""));
        this.encryptParameters(authorizationSaveRequest);
        return (RequestAuthorization)this.modelMapper.map((Object)authorizationSaveRequest, OAuth1RequestAuthorization.class);
    }

    @Override
    @Nullable
    public RequestHeader generateAuthorizationHeader(RequestAuthorization authorization) {
        OAuth1AuthorizationSaveRequest oauthAuthorization = (OAuth1AuthorizationSaveRequest)AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
        OAuth1AddDataType addDataType = oauthAuthorization.getAddDataType();
        if (addDataType == OAuth1AddDataType.REQUEST_HEADERS) {
            return new RequestHeader(null, "Authorization", CALCULATED_VALUE, "", false, true);
        }
        return null;
    }

    private String generateAuthorizationHeader(Map<String, String> oauthParams) {
        StringBuilder header = new StringBuilder("OAuth ");
        for (Map.Entry<String, String> entry : oauthParams.entrySet()) {
            header.append(entry.getKey()).append("=\"").append(this.percentEncode(entry.getValue())).append("\", ");
        }
        header.deleteCharAt(header.length() - 2);
        return header.toString();
    }

    @Override
    public List<RequestParam> generateAuthorizationParams(RequestAuthorization authorization) {
        OAuth1AuthorizationSaveRequest oauthAuthorization = (OAuth1AuthorizationSaveRequest)AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
        OAuth1AddDataType addDataType = oauthAuthorization.getAddDataType();
        String accessToken = oauthAuthorization.getAccessToken();
        String tokenSecret = oauthAuthorization.getTokenSecret();
        ArrayList<String> baseParams = new ArrayList<String>(Arrays.asList("oauth_consumer_key", "oauth_nonce", "oauth_signature", "oauth_signature_method", "oauth_timestamp", "oauth_version"));
        if (addDataType == OAuth1AddDataType.REQUEST_URL) {
            if (!StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{accessToken, tokenSecret})) {
                baseParams.add("oauth_token");
            }
            return baseParams.stream().map(param -> new RequestParam((String)param, MASKED_VALUE, "", false, true)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

