/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.auth;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.codehaus.commons.compiler.util.Producer;
import org.modelmapper.ModelMapper;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.utils.ExceptionUtils;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.auth.AbstractAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.enums.auth.OAuth2GrantType;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestIllegalAuthorizationGrantTypeException;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyRequest;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyResponse;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.OAuth2AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.auth.OAuth2AuthrizationResponse;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth2RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.qubership.atp.itf.lite.backend.service.rest.RestTemplateService;
import org.qubership.atp.itf.lite.backend.utils.AuthorizationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class OAuth2RequestAuthorizationStrategy
extends AbstractAuthorizationStrategy
implements RequestAuthorizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(OAuth2RequestAuthorizationStrategy.class);
    public static final String GRANT_TYPE = "grant_type";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String AUTH_HEADER_PREFIX_PATTERN = "%s %s";
    public static final String TO_ENCRYPT_FLAG = "{2ENC}";
    private static final String IS_ENCRYPTED_FLAG = "{ENC}";
    private final RestTemplateService restTemplateService;
    private final ModelMapper modelMapper;

    public OAuth2RequestAuthorizationStrategy(RestTemplateService restTemplateService, EncryptionService encryptionService, ModelMapper modelMapper) {
        super(encryptionService);
        this.restTemplateService = restTemplateService;
        this.modelMapper = modelMapper;
    }

    @Override
    public AuthorizationStrategyResponse getAuthorizationToken(AuthorizationStrategyRequest request) throws AtpDecryptException {
        AuthorizationSaveRequest authorization = request.getUnsafeAuthorizationRequest();
        OAuth2AuthorizationSaveRequest oAuth2Authorization = (OAuth2AuthorizationSaveRequest)authorization;
        log.debug("Get Authorization header using OAuth2 type and params: {}", (Object)oAuth2Authorization);
        this.decryptParameters(authorization);
        this.decodeParameters(authorization);
        this.decryptParameters(authorization);
        OAuth2GrantType grantType = oAuth2Authorization.getGrantType();
        String username = oAuth2Authorization.getUsername();
        String password = oAuth2Authorization.getPassword();
        String clientId = oAuth2Authorization.getClientId();
        String clientSecret = oAuth2Authorization.getClientSecret();
        String url = oAuth2Authorization.getUrl();
        String headerPrefix = oAuth2Authorization.getHeaderPrefix();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)CLIENT_ID, (Object)clientId);
        switch (grantType) {
            case CLIENT_CREDENTIALS: {
                params.add((Object)GRANT_TYPE, (Object)AuthorizationGrantType.CLIENT_CREDENTIALS.getValue());
                params.add((Object)CLIENT_SECRET, (Object)clientSecret);
                break;
            }
            case PASSWORD_CREDENTIALS: {
                params.add((Object)GRANT_TYPE, (Object)AuthorizationGrantType.PASSWORD.getValue());
                params.add((Object)USERNAME, (Object)username);
                params.add((Object)PASSWORD, (Object)password);
                break;
            }
            case AUTHORIZATION_CODE: {
                String authHeader = oAuth2Authorization.getToken();
                if (StringUtils.isEmpty((String)authHeader)) {
                    log.warn("Token for AUTHORIZATION_CODE auth type not generated. Generating auth header skipped");
                    return null;
                }
                if (StringUtils.isNotEmpty((String)headerPrefix)) {
                    authHeader = String.format(AUTH_HEADER_PREFIX_PATTERN, headerPrefix, authHeader);
                }
                log.debug("Result Authorization header: {}", (Object)authHeader);
                return new AuthorizationStrategyResponse(authHeader, authHeader);
            }
            default: {
                ExceptionUtils.throwWithLog((Logger)log, (AtpException)new ItfLiteRequestIllegalAuthorizationGrantTypeException(grantType));
            }
        }
        OAuth2AuthrizationResponse response = this.performAuthorization(request.getProjectId(), url, (MultiValueMap<String, String>)params);
        String authHeader = response.getAccessToken();
        if (StringUtils.isNotEmpty((String)headerPrefix)) {
            authHeader = String.format(AUTH_HEADER_PREFIX_PATTERN, headerPrefix, authHeader);
        }
        log.debug("Result Authorization header: {}", (Object)authHeader);
        return new AuthorizationStrategyResponse(authHeader, authHeader);
    }

    @Override
    public void decryptParameters(AuthorizationSaveRequest authorization) {
        log.debug("Decrypt authorization parameters");
        OAuth2AuthorizationSaveRequest oAuth2Authorization = (OAuth2AuthorizationSaveRequest)authorization;
        this.decryptParameter((Producer<String>)((Producer)oAuth2Authorization::getPassword), oAuth2Authorization::setPassword);
        log.debug("Password has been successfully decrypted");
        this.decryptParameter((Producer<String>)((Producer)oAuth2Authorization::getClientSecret), oAuth2Authorization::setClientSecret);
        log.debug("Client secret has been successfully decrypted");
    }

    @Override
    public void encryptParameters(AuthorizationSaveRequest authorization) {
        log.debug("Encrypt authorization parameters");
        OAuth2AuthorizationSaveRequest oAuth2Authorization = (OAuth2AuthorizationSaveRequest)authorization;
        this.encryptParameter((Producer<String>)((Producer)oAuth2Authorization::getPassword), oAuth2Authorization::setPassword);
        log.debug("Password has been successfully encrypted");
        this.encryptParameter((Producer<String>)((Producer)oAuth2Authorization::getClientSecret), oAuth2Authorization::setClientSecret);
        log.debug("Client secret has been successfully encrypted");
    }

    public void decodeParameters(AuthorizationSaveRequest authorization) {
        log.debug("Decode authorization parameters");
        OAuth2AuthorizationSaveRequest oAuth2Authorization = (OAuth2AuthorizationSaveRequest)authorization;
        this.decodeParameter((Producer<String>)((Producer)oAuth2Authorization::getPassword), oAuth2Authorization::setPassword);
        log.debug("Password has been successfully decoded");
        this.decodeParameter((Producer<String>)((Producer)oAuth2Authorization::getClientSecret), oAuth2Authorization::setClientSecret);
        log.debug("Client secret has been successfully decoded");
    }

    @Override
    public OAuth2AuthrizationResponse performAuthorization(UUID projectId, String url, MultiValueMap<String, String> map) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity params = new HttpEntity(map, (MultiValueMap)headers);
        Class<OAuth2AuthrizationResponse> responseType = OAuth2AuthrizationResponse.class;
        return (OAuth2AuthrizationResponse)this.restTemplateService.restTemplate(projectId).postForEntity(url, (Object)params, responseType, new Object[0]).getBody();
    }

    @Override
    public RequestAuthorizationType getAuthorizationType() {
        return RequestAuthorizationType.OAUTH2;
    }

    @Override
    public RequestAuthorization parseAuthorizationFromMap(Map<String, String> authorizationInfo) {
        OAuth2AuthorizationSaveRequest authorizationSaveRequest = new OAuth2AuthorizationSaveRequest();
        authorizationSaveRequest.setType(RequestAuthorizationType.OAUTH2);
        if (authorizationInfo.containsKey("headerPrefix")) {
            authorizationSaveRequest.setHeaderPrefix(authorizationInfo.get("headerPrefix"));
        } else if (authorizationInfo.containsKey("header_prefix")) {
            authorizationSaveRequest.setHeaderPrefix(authorizationInfo.get("header_prefix"));
        }
        if (authorizationInfo.containsKey(GRANT_TYPE)) {
            OAuth2GrantType grantType = Arrays.stream(OAuth2GrantType.values()).filter(currentGrantType -> currentGrantType.getKey().equals(authorizationInfo.get(GRANT_TYPE))).findFirst().orElse(OAuth2GrantType.PASSWORD_CREDENTIALS);
            authorizationSaveRequest.setGrantType(grantType);
        } else {
            authorizationSaveRequest.setGrantType(OAuth2GrantType.PASSWORD_CREDENTIALS);
        }
        if (authorizationInfo.containsKey("scope")) {
            authorizationSaveRequest.setScope(authorizationInfo.get("scope"));
        }
        if (authorizationInfo.containsKey(USERNAME)) {
            authorizationSaveRequest.setUsername(authorizationInfo.get(USERNAME));
        }
        authorizationSaveRequest.setClientId(authorizationInfo.getOrDefault("clientId", ""));
        authorizationSaveRequest.setUrl(authorizationInfo.getOrDefault("accessTokenUrl", ""));
        if (authorizationInfo.containsKey(PASSWORD)) {
            authorizationSaveRequest.setPassword(TO_ENCRYPT_FLAG + this.encryptionService.encodeBase64(authorizationInfo.get(PASSWORD)));
        }
        if (authorizationInfo.containsKey("clientSecret")) {
            authorizationSaveRequest.setClientSecret(TO_ENCRYPT_FLAG + this.encryptionService.encodeBase64(authorizationInfo.get("clientSecret")));
        }
        this.encryptParameters(authorizationSaveRequest);
        return (RequestAuthorization)this.modelMapper.map((Object)authorizationSaveRequest, OAuth2RequestAuthorization.class);
    }

    @Override
    @Nullable
    public RequestHeader generateAuthorizationHeader(RequestAuthorization authorization) {
        OAuth2AuthorizationSaveRequest oauthAuthorization = (OAuth2AuthorizationSaveRequest)AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
        OAuth2GrantType grantType = oauthAuthorization.getGrantType();
        if (Objects.nonNull((Object)grantType)) {
            String headerValue;
            switch (grantType) {
                case CLIENT_CREDENTIALS: 
                case PASSWORD_CREDENTIALS: {
                    headerValue = "<calculated when request is sent>";
                    break;
                }
                case AUTHORIZATION_CODE: {
                    String headerPrefix = oauthAuthorization.getHeaderPrefix();
                    String token = oauthAuthorization.getToken();
                    headerValue = StringUtils.isNotEmpty((String)headerPrefix) ? String.format(AUTH_HEADER_PREFIX_PATTERN, headerPrefix, token) : token;
                    break;
                }
                default: {
                    log.error("Found unsupported OAuth2 grant type: {}", (Object)grantType);
                    throw new ItfLiteRequestIllegalAuthorizationGrantTypeException(grantType);
                }
            }
            return new RequestHeader(null, "Authorization", headerValue, "", false, true);
        }
        log.warn("Grant type for OAuth authorization not sets. Generating of authorization header skipped");
        return null;
    }
}

