/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.auth;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyRequest;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyResponse;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.auth.OAuth2AuthrizationResponse;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.springframework.util.MultiValueMap;

public interface RequestAuthorizationStrategy {
    public AuthorizationStrategyResponse getAuthorizationToken(AuthorizationStrategyRequest var1) throws AtpDecryptException;

    public void encryptParameters(AuthorizationSaveRequest var1);

    public void decryptParameters(AuthorizationSaveRequest var1);

    public OAuth2AuthrizationResponse performAuthorization(UUID var1, String var2, MultiValueMap<String, String> var3);

    public RequestAuthorizationType getAuthorizationType();

    public RequestAuthorization parseAuthorizationFromMap(Map<String, String> var1);

    @Nullable
    public RequestHeader generateAuthorizationHeader(RequestAuthorization var1);

    default public List<RequestParam> generateAuthorizationParams(RequestAuthorization authorization) {
        return Collections.emptyList();
    }
}

