/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.itf.lite.backend.components.export.strategies.ExportStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportStrategiesRegistry {
    private static final Logger log = LoggerFactory.getLogger(ExportStrategiesRegistry.class);
    private final List<ExportStrategy> exportStrategies;

    public ExportStrategy getStrategy(@NotNull ExportFormat format) {
        return this.exportStrategies.stream().filter(exportStrategy -> format.equals((Object)exportStrategy.getFormat())).findFirst().orElse(new ExportStrategy(){

            @Override
            public void export(ExportImportData exportData, Path workDir) {
                log.info("ITF Lite not support `{}` export format: {}", (Object)exportData.getFormat());
            }

            @Override
            public void exportFolders(Set<UUID> exportFolderIds, Path workDir, UUID projectId) {
            }

            @Override
            public void exportRequests(ExportImportData exportData, Path workDir, Set<UUID> exportRequestIds) throws ExportException {
            }

            @Override
            public ExportFormat getFormat() {
                return null;
            }
        });
    }

    public ExportStrategiesRegistry(List<ExportStrategy> exportStrategies) {
        this.exportStrategies = exportStrategies;
    }
}

