/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.qubership.atp.itf.lite.backend.components.export.strategies.request.RequestExportStrategy;
import org.qubership.atp.itf.lite.backend.enums.ImportToolType;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestExportStrategiesRegistry {
    private static final Logger log = LoggerFactory.getLogger(RequestExportStrategiesRegistry.class);
    @Autowired
    private List<RequestExportStrategy> exportStrategies;

    public RequestExportStrategy getStrategy(@NotNull ImportToolType importToolType, @NotNull TransportType requestTransportType) {
        return this.exportStrategies.stream().filter(exportStrategy -> importToolType.equals((Object)exportStrategy.getImportToolType())).filter(exportStrategy -> requestTransportType.equals((Object)exportStrategy.getRequestTransportType())).findFirst().orElseThrow(() -> {
            String errMsg = String.format("Failed to find export strategy by import tool type '%s' and request transport type '%s'", new Object[]{importToolType, requestTransportType});
            log.error(errMsg);
            return new IllegalStateException(errMsg);
        });
    }
}

