/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export.strategies;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.ObjectSaverToDiskService;
import org.qubership.atp.itf.lite.backend.components.export.strategies.ExportStrategy;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.FolderRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestRepository;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractEntity;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileInfo;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtpExportStrategy
implements ExportStrategy {
    private static final Logger log = LoggerFactory.getLogger(AtpExportStrategy.class);
    private final RequestRepository requestRepository;
    private final FolderRepository folderRepository;
    private final ObjectSaverToDiskService objectSaverToDiskService;
    private final FileService fileService;
    private final GridFsService gridFsService;
    private final ObjectMapper objectMapper;

    @Override
    public ExportFormat getFormat() {
        return ExportFormat.ATP;
    }

    @Override
    public void export(ExportImportData exportData, Path path) {
        this.exportFolders(exportData, Paths.get(path.toString(), "Folders"));
        this.exportRequests(exportData, Paths.get(path.toString(), "Requests"));
    }

    @Override
    public void exportFolders(Set<UUID> exportFolderIds, Path workDir, UUID projectId) {
        Map folders = this.folderRepository.findAllByProjectId(projectId).stream().collect(Collectors.toMap(AbstractEntity::getId, Function.identity()));
        HashSet parentFolders = new HashSet();
        exportFolderIds.forEach(folderId -> parentFolders.addAll(this.getParentFolders(folders, (UUID)folderId)));
        folders.forEach((folderId, folder) -> {
            if (parentFolders.contains(folderId)) {
                UUID originalPermissionFolderId = folder.getPermissionFolderId();
                String originalPermissions = folder.getPermission();
                folder.setPermissionFolderId(null);
                folder.setPermission(null);
                try {
                    this.objectSaverToDiskService.exportAtpEntity(folderId, folder, workDir);
                }
                finally {
                    folder.setPermissionFolderId(originalPermissionFolderId);
                    folder.setPermission(originalPermissions);
                }
            }
        });
    }

    @Override
    public void exportRequests(ExportImportData exportData, Path workDir, Set<UUID> exportRequestIds) throws ExportException {
        ((Set)exportData.getExportScope().getEntities().getOrDefault("projects", new HashSet())).forEach(projectId -> this.requestRepository.findAllByProjectId(UUID.fromString(projectId)).stream().filter(request -> exportRequestIds.contains(request.getId())).forEach(request -> this.objectSaverToDiskService.exportAtpEntity(request.getId(), request, workDir)));
        this.exportFiles(exportRequestIds, workDir.getParent());
    }

    private Set<UUID> getParentFolders(Map<UUID, Folder> folders, UUID childFolderId) {
        HashSet<UUID> parentFolders = new HashSet<UUID>();
        Folder childFolder = folders.get(childFolderId);
        if (childFolder == null) {
            return parentFolders;
        }
        parentFolders.add(childFolderId);
        parentFolders.addAll(this.getParentFolders(folders, childFolder.getParentId()));
        return parentFolders;
    }

    private void exportFiles(Set<UUID> exportRequestIds, Path workDir) {
        log.debug("Start export files for requests {}", exportRequestIds);
        Path fileDirectoryPath = workDir.resolve("Files");
        Map<UUID, List<FileInfo>> files = this.gridFsService.getFileInfosByRequestIds(exportRequestIds);
        for (Map.Entry<UUID, List<FileInfo>> entry : files.entrySet()) {
            UUID requestId = entry.getKey();
            List<FileInfo> fileInfos = entry.getValue();
            Path requestDirectoryPath = fileDirectoryPath.resolve(requestId.toString());
            this.fileService.createDirectory(requestDirectoryPath);
            Map<UUID, InputStream> fileToFileId = this.gridFsService.getFilesByFileInfos(fileInfos);
            for (Map.Entry<UUID, InputStream> fileEntry : fileToFileId.entrySet()) {
                String fileName = fileEntry.getKey().toString();
                Path filePath = requestDirectoryPath.resolve(fileName);
                try (InputStream in = fileEntry.getValue();){
                    Files.copy(in, filePath, new CopyOption[0]);
                }
                catch (IOException e) {
                    log.error("Error when writing file {} for Request {} to the file system.", new Object[]{fileName, requestId, e});
                }
                Path metadataFilePath = requestDirectoryPath.resolve(fileName + ".json");
                Optional<FileInfo> fileInfo = fileInfos.stream().filter(info -> fileName.equals(info.getFileId().toString())).findFirst();
                if (!fileInfo.isPresent()) continue;
                try {
                    this.objectMapper.writeValue(metadataFilePath.toFile(), (Object)fileInfo.get());
                }
                catch (IOException e) {
                    log.error("Error when writing file info with fileId {} for Request {} to the file system.", new Object[]{fileName, requestId, e});
                }
            }
        }
        log.debug("End export files for requests {}", exportRequestIds);
    }

    public AtpExportStrategy(RequestRepository requestRepository, FolderRepository folderRepository, ObjectSaverToDiskService objectSaverToDiskService, FileService fileService, GridFsService gridFsService, ObjectMapper objectMapper) {
        this.requestRepository = requestRepository;
        this.folderRepository = folderRepository;
        this.objectSaverToDiskService = objectSaverToDiskService;
        this.fileService = fileService;
        this.gridFsService = gridFsService;
        this.objectMapper = objectMapper;
    }
}

