/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export.strategies.request;

import java.math.BigInteger;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.itf.lite.backend.components.export.strategies.request.RequestExportStrategy;
import org.qubership.atp.itf.lite.backend.model.api.kafka.ItfExportRequestEvent;
import org.qubership.atp.itf.lite.backend.model.api.kafka.entities.ExportRequestEntity;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestItfExportRequest;
import org.qubership.atp.itf.lite.backend.service.kafka.KafkaExportEventSendingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class ItfAbstractRequestExportStrategy
implements RequestExportStrategy {
    private static final Logger log = LoggerFactory.getLogger(ItfAbstractRequestExportStrategy.class);
    private final KafkaExportEventSendingService kafkaExportEventSendingService;

    public void sendExportRequestEvent(UUID exportRequestId, RequestItfExportRequest requestItfExportRequest, ExportRequestEntity request) {
        BigInteger receiverId;
        log.debug("Send export request for exportRequestId = {}, requestId = {}", (Object)exportRequestId, (Object)request.getId());
        ItfExportRequestEvent itfExportRequestEvent = new ItfExportRequestEvent();
        itfExportRequestEvent.setId(exportRequestId);
        itfExportRequestEvent.setProjectId(requestItfExportRequest.getProjectId());
        itfExportRequestEvent.setItfUrl(requestItfExportRequest.getItfUrl());
        itfExportRequestEvent.setSystemId(requestItfExportRequest.getSystemId().toString());
        itfExportRequestEvent.setOperationId(requestItfExportRequest.getOperationId().toString());
        if (this.isReceiversMapContainRequestIdKey(requestItfExportRequest.getRequestIdsReceiversMap(), request.getId()) && (receiverId = requestItfExportRequest.getRequestIdsReceiversMap().get(request.getId())) != null) {
            itfExportRequestEvent.setReceiver(receiverId.toString());
        }
        itfExportRequestEvent.setRequest(request);
        this.kafkaExportEventSendingService.itfExportRequestEventSend(exportRequestId, itfExportRequestEvent);
    }

    private boolean isReceiversMapContainRequestIdKey(Map<UUID, BigInteger> receiversMap, UUID requestId) {
        return !CollectionUtils.isEmpty(receiversMap) && receiversMap.containsKey(requestId);
    }

    public ItfAbstractRequestExportStrategy(KafkaExportEventSendingService kafkaExportEventSendingService) {
        this.kafkaExportEventSendingService = kafkaExportEventSendingService;
    }
}

