/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export.strategies.request;

import java.net.URISyntaxException;
import java.util.UUID;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.export.strategies.request.ItfAbstractRequestExportStrategy;
import org.qubership.atp.itf.lite.backend.enums.ImportToolType;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.model.api.kafka.entities.HttpRequestExportEntity;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestExportRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestItfExportRequest;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.kafka.KafkaExportEventSendingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ItfSoapRequestExportStrategy
extends ItfAbstractRequestExportStrategy {
    private static final Logger log = LoggerFactory.getLogger(ItfSoapRequestExportStrategy.class);
    private final RequestService requestService;

    public ItfSoapRequestExportStrategy(KafkaExportEventSendingService kafkaExportEventSendingService, RequestService requestService) {
        super(kafkaExportEventSendingService);
        this.requestService = requestService;
    }

    @Override
    public void export(UUID exportRequestId, RequestExportRequest exportRequest, Request request, String context, UUID environmentId) throws URISyntaxException, AtpDecryptException {
        HttpRequest httpRequestWithResolvedVariables = this.requestService.resolveAllVariables((HttpRequest)request, context, false, environmentId);
        this.requestService.encodeRequestParametersExceptEnv(httpRequestWithResolvedVariables.getRequestParams());
        HttpRequestExportEntity httpRequestExportEntity = new HttpRequestExportEntity(httpRequestWithResolvedVariables);
        this.sendExportRequestEvent(exportRequestId, (RequestItfExportRequest)exportRequest, httpRequestExportEntity);
    }

    @Override
    public TransportType getRequestTransportType() {
        return TransportType.SOAP;
    }

    @Override
    public ImportToolType getImportToolType() {
        return ImportToolType.ITF;
    }
}

