/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export.strategies.request;

import java.net.URISyntaxException;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.components.export.strategies.request.RequestExportStrategy;
import org.qubership.atp.itf.lite.backend.model.api.kafka.MiaExportRequestEvent;
import org.qubership.atp.itf.lite.backend.model.api.kafka.entities.HttpRequestExportEntity;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestMiaExportRequest;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.kafka.KafkaExportEventSendingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MiaAbstractRequestExportStrategy
implements RequestExportStrategy {
    private static final Logger log = LoggerFactory.getLogger(MiaAbstractRequestExportStrategy.class);
    private final KafkaExportEventSendingService kafkaExportEventSendingService;
    private final RequestService requestService;
    private final ModelMapper modelMapper;

    public void sendExportRequestEvent(UUID exportRequestId, RequestMiaExportRequest requestMiaExportRequest, Request request, String context) throws URISyntaxException {
        log.debug("Send export request for exportRequestId = {}, requestId = {}", (Object)exportRequestId, (Object)request.getId());
        HttpRequest httpRequest = (HttpRequest)request;
        HttpRequestEntitySaveRequest saveRequest = (HttpRequestEntitySaveRequest)this.modelMapper.map((Object)httpRequest, HttpRequestEntitySaveRequest.class);
        this.requestService.resolveVelocityVariables(httpRequest, context, true, saveRequest);
        this.requestService.encodeRequestParametersExceptEnv(httpRequest.getRequestParams());
        MiaExportRequestEvent miaExportRequestEvent = new MiaExportRequestEvent();
        miaExportRequestEvent.setId(exportRequestId);
        miaExportRequestEvent.setProjectId(requestMiaExportRequest.getProjectId());
        miaExportRequestEvent.setMiaPath(requestMiaExportRequest.getMiaPath());
        miaExportRequestEvent.setMiaProcessName(request.getName());
        HttpRequestExportEntity miaRequestEntity = new HttpRequestExportEntity(httpRequest, true);
        miaExportRequestEvent.setRequest(miaRequestEntity);
        this.kafkaExportEventSendingService.miaExportRequestEventSend(exportRequestId, miaExportRequestEvent);
    }

    public MiaAbstractRequestExportStrategy(KafkaExportEventSendingService kafkaExportEventSendingService, RequestService requestService, ModelMapper modelMapper) {
        this.kafkaExportEventSendingService = kafkaExportEventSendingService;
        this.requestService = requestService;
        this.modelMapper = modelMapper;
    }
}

