/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.replacer;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContextVariablesReplacer {
    private static final Logger log = LoggerFactory.getLogger(ContextVariablesReplacer.class);
    private static final String CONTEXT_VARIABLE_REGEXP = "\\$\\{([^}]+)}|\\{\\{([^}]+)}}";
    private static final Pattern pattern = Pattern.compile("\\$\\{([^}]+)}|\\{\\{([^}]+)}}");
    private final EncryptionService cryptService;

    public String replace(String value, Map<String, Object> context) {
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            try {
                String match = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
                String foundParameter = this.findParameterByName(match.replace("\\\"", ""), context);
                value = foundParameter == null ? value : value.replace(matcher.group(0), foundParameter);
            }
            catch (RuntimeException | AtpDecryptException exception) {
                String message = String.format("Error occurred while injecting context variable [%s].\n%s\n%s", matcher.group(0), exception.getClass().getName(), exception.getMessage());
                log.error(message);
                throw new RuntimeException(message);
            }
        }
        return value;
    }

    private String findParameterByName(String parameterName, Map<String, Object> context) throws AtpDecryptException {
        Object foundValue = context.get(parameterName);
        if (foundValue == null) {
            log.debug(String.format("Parameter %s not found in any variables context", parameterName));
            return null;
        }
        return this.cryptService.decryptIfEncrypted(foundValue.toString());
    }

    public ContextVariablesReplacer(EncryptionService cryptService) {
        this.cryptService = cryptService;
    }
}

