/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.configuration;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.model.Indexes;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.management.JMXConnectionPoolListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsCommandListener;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsConnectionPoolListener;
import java.util.concurrent.TimeUnit;
import org.bson.UuidRepresentation;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="itf-lite-gridfs-config")
public class GridFsConfiguration {
    @Value(value="${gridfs.host}")
    private String host;
    @Value(value="${gridfs.port}")
    private String port;
    @Value(value="${gridfs.database}")
    private String database;
    @Value(value="${gridfs.user}")
    private String user;
    @Value(value="${gridfs.password}")
    private String password;
    @Value(value="${max.connection.idle.time}")
    private long maxConnectionIdleTime;
    @Value(value="${min.connections.per.host}")
    private int minConnectionsPerHost;
    @Value(value="${connections.per.host}")
    private int connectionsPerHost;

    @Bean(value={"itfLiteGridFsMongoDatabase"})
    public MongoDatabase gridFsMongoDatabase(MeterRegistry meterRegistry) {
        String mongoClientUri = "mongodb://" + this.user + ":" + this.password + "@" + this.host + ":" + this.port + "/?authSource=" + this.database;
        MongoClientSettings settings = MongoClientSettings.builder().addCommandListener((CommandListener)new MongoMetricsCommandListener(meterRegistry)).applyConnectionString(new ConnectionString(mongoClientUri)).uuidRepresentation(UuidRepresentation.JAVA_LEGACY).applyToConnectionPoolSettings(connPoolBuilder -> ConnectionPoolSettings.builder().maxConnectionIdleTime(this.maxConnectionIdleTime, TimeUnit.MILLISECONDS).minSize(this.minConnectionsPerHost).maxSize(this.connectionsPerHost).addConnectionPoolListener((ConnectionPoolListener)new JMXConnectionPoolListener()).addConnectionPoolListener((ConnectionPoolListener)new MongoMetricsConnectionPoolListener(meterRegistry))).build();
        MongoClient mongo = MongoClients.create((MongoClientSettings)settings);
        return mongo.getDatabase(this.database);
    }

    @Bean
    public GridFSBucket provideGridFileSystemBuckets(@Qualifier(value="itfLiteGridFsMongoDatabase") MongoDatabase db) {
        GridFSBucket gridFsBucket = GridFSBuckets.create((MongoDatabase)db);
        MongoCollection filesCollection = db.getCollection("fs.files");
        MongoCollection chunksCollection = db.getCollection("fs.chunks");
        filesCollection.createIndex(Indexes.descending((String[])new String[]{"metadata.logRecordUuid"}));
        chunksCollection.createIndex(Indexes.descending((String[])new String[]{"files_id"}));
        return gridFsBucket;
    }
}

