/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.BasicAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.BearerAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.InheritFromParentAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.OAuth1AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.OAuth2AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BasicRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BearerRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.InheritFromParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth1RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth2RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MapperConfiguration {
    private static final Map<Class<? extends RequestAuthorization>, Class<? extends AuthorizationSaveRequest>> authorizationToSaveAuthorizationMap = new HashMap<Class<? extends RequestAuthorization>, Class<? extends AuthorizationSaveRequest>>(){
        {
            this.put(RequestAuthorization.class, AuthorizationSaveRequest.class);
            this.put(BasicRequestAuthorization.class, BasicAuthorizationSaveRequest.class);
            this.put(BearerRequestAuthorization.class, BearerAuthorizationSaveRequest.class);
            this.put(InheritFromParentRequestAuthorization.class, InheritFromParentAuthorizationSaveRequest.class);
            this.put(OAuth1RequestAuthorization.class, OAuth1AuthorizationSaveRequest.class);
            this.put(OAuth2RequestAuthorization.class, OAuth2AuthorizationSaveRequest.class);
        }
    };

    @Bean
    public ModelMapper modelMapper() {
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setAmbiguityIgnored(true);
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        modelMapper.createTypeMap(AuthorizationSaveRequest.class, RequestAuthorization.class).setConverter(mappingContext -> {
            AuthorizationSaveRequest source = (AuthorizationSaveRequest)mappingContext.getSource();
            if (Objects.nonNull(source)) {
                return (RequestAuthorization)modelMapper.map((Object)source, source.getAuthEntityType());
            }
            return null;
        });
        modelMapper.createTypeMap(RequestAuthorization.class, AuthorizationSaveRequest.class).setConverter(mappingContext -> {
            RequestAuthorization source = (RequestAuthorization)mappingContext.getSource();
            if (Objects.nonNull(source)) {
                return (AuthorizationSaveRequest)modelMapper.map((Object)source, authorizationToSaveAuthorizationMap.get(source.getClass()));
            }
            return null;
        });
        modelMapper.createTypeMap(HttpRequestEntitySaveRequest.class, HttpRequest.class).addMappings(map -> {
            map.using(mappingContext -> {
                List source = (List)mappingContext.getSource();
                if (source != null) {
                    return source.stream().map(RequestParam::new).collect(Collectors.toList());
                }
                return new ArrayList();
            }).map(HttpRequestEntitySaveRequest::getRequestParams, HttpRequest::setRequestParams);
            map.using(mappingContext -> {
                List source = (List)mappingContext.getSource();
                if (source != null) {
                    return source.stream().map(RequestHeader::new).collect(Collectors.toList());
                }
                return new ArrayList();
            }).map(HttpRequestEntitySaveRequest::getRequestHeaders, HttpRequest::setRequestHeaders);
        });
        return modelMapper;
    }

    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper(){
            {
                this.registerModule((Module)new JavaTimeModule());
                this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                this.findAndRegisterModules();
            }
        };
    }
}

