/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.configuration.cache;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import org.qubership.atp.itf.lite.backend.enums.CacheKeys;
import org.qubership.atp.itf.lite.backend.utils.PodNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cache.hazelcast.client.enable"}, havingValue="true")
public class ItfLiteHazelCastCacheConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ItfLiteHazelCastCacheConfiguration.class);
    @Value(value="${spring.cache.hazelcast.cluster-name:atp-hc}")
    private String cacheClusterName;
    @Value(value="${spring.cache.hazelcast.server.address:127.0.0.1}")
    private String hazelcastServerAddress;
    @Value(value="${spring.cache.hazelcast.server.enable:#{true}}")
    private boolean hazelcastServerEnable;
    @Value(value="${spring.cache.hazelcast.server.port:#{5701}}")
    private int hazelcastServerPort;
    private volatile HazelcastInstance hzInstanceClient;
    private boolean serverStarted = false;
    @Autowired
    private PodNameUtils podNameService;

    @Bean
    public CacheManager cacheManager() {
        log.info("Create HAZELCAST cache manager");
        return new HazelcastCacheManager(this.getHzInstance());
    }

    public synchronized HazelcastInstance getHzInstance() {
        if (this.hzInstanceClient == null) {
            ClientConfig clientConfig = new ClientConfig();
            String podName = PodNameUtils.getServicePodName();
            clientConfig.setInstanceName(podName);
            clientConfig.setClusterName(this.cacheClusterName);
            clientConfig.getNetworkConfig().addAddress(new String[]{this.hazelcastServerAddress + ":" + this.hazelcastServerPort});
            clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
            if (!this.serverStarted) {
                this.startCacheServer();
            }
            try {
                log.debug("Connect to HAZELCAST as client");
                this.hzInstanceClient = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
                for (CacheKeys key : CacheKeys.values()) {
                    String name = key.getKey();
                    try {
                        log.debug("Try to create config for map {}", (Object)name);
                        this.hzInstanceClient.getConfig().addMapConfig(new MapConfig(name).setTimeToLiveSeconds(key.getTtlInSeconds()));
                    }
                    catch (Exception failedCreate) {
                        log.warn("Map {} already created. Not possible to change map config: {}", (Object)name, (Object)failedCreate);
                    }
                }
            }
            catch (Exception e) {
                log.error("HazelCast server is not available!!! {}", (Throwable)e);
                this.serverStarted = false;
            }
        }
        return this.hzInstanceClient;
    }

    private void startCacheServer() {
        if (this.hazelcastServerEnable) {
            log.info("Get or start cache config on address " + this.hazelcastServerAddress + ":" + this.hazelcastServerPort);
            Config config = new Config("ATP-ITF_LITE-HC-SERVER");
            NetworkConfig network = config.getNetworkConfig().setPort(this.hazelcastServerPort).setPortCount(1).setPortAutoIncrement(false).setReuseAddress(true);
            network.getJoin().getMulticastConfig().setEnabled(true);
            for (CacheKeys key : CacheKeys.values()) {
                config.addMapConfig(new MapConfig(key.getKey()).setTimeToLiveSeconds(key.getTtlInSeconds()));
            }
            config.setClusterName(this.cacheClusterName);
            try {
                if (Hazelcast.getOrCreateHazelcastInstance((Config)config) != null) {
                    this.serverStarted = true;
                }
            }
            catch (Exception e) {
                log.warn("HazelCast server already started: {}", (Object)e.getMessage());
                this.serverStarted = false;
            }
        } else {
            this.serverStarted = true;
        }
    }
}

