/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.itf.lite.backend.model.api.request.CollectionExecuteRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.ImportCollectionsRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.ImportCollectionsResponse;
import org.qubership.atp.itf.lite.backend.service.CollectionsService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/collections"})
public class CollectionController {
    private final CollectionsService collectionsService;

    @AuditAction(auditAction="Import collection {{#requestEntity.name}} to project {{#requestEntity.projectId}}")
    @PreAuthorize(value="#requestEntity.getTargetFolderId() != null ? @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#requestEntity.getProjectId(),@folderService.getFolder(#requestEntity.getTargetFolderId()).getPermissionFolderId(), 'UPDATE') : true and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#requestEntity.getProjectId(),'CREATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#requestEntity.getProjectId(),'CREATE')")
    @PostMapping(value={"/import"})
    public ResponseEntity<List<ImportCollectionsResponse>> importCollections(@RequestPart(name="file") MultipartFile collections, @RequestPart(name="requestEntity") @Valid ImportCollectionsRequest requestEntity) {
        return ResponseEntity.ok(this.collectionsService.importCollections(collections, requestEntity));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#request.getProjectId(),'EXECUTE')")
    @PostMapping(value={"/execute"})
    public ResponseEntity<List<UUID>> executeCollection(@RequestHeader(value="Authorization") String token, @RequestBody CollectionExecuteRequest request) {
        return ResponseEntity.ok(this.collectionsService.executeCollection(token, request));
    }

    public CollectionController(CollectionsService collectionsService) {
        this.collectionsService = collectionsService;
    }
}

