/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.itf.lite.backend.model.api.dto.CookiesDto;
import org.qubership.atp.itf.lite.backend.model.api.request.ImportFromRamRequest;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.service.CookieService;
import org.qubership.atp.itf.lite.backend.utils.CookieUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/project/{projectId}/cookies"})
public class CookieController {
    private final CookieService cookieService;

    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, 'UPDATE')")
    @PostMapping
    @Transactional
    public ResponseEntity<List<CookiesDto>> saveCookies(@PathVariable(name="projectId") UUID projectId, @RequestBody List<CookiesDto> cookiesDto) {
        this.cookieService.deleteByUserIdAndProjectId(projectId);
        List<Cookie> cookies = CookieUtils.convertToCookieList(cookiesDto);
        this.cookieService.fillCookieInfo(cookies, projectId);
        return ResponseEntity.ok(CookieUtils.convertToCookiesDtoList(this.cookieService.save(cookies)));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, 'READ')")
    @GetMapping
    public ResponseEntity<List<CookiesDto>> getCookies(@PathVariable(name="projectId") UUID projectId) {
        List<Cookie> cookies = this.cookieService.getNotExpiredCookiesByUserIdAndProjectId(projectId);
        return ResponseEntity.ok(CookieUtils.convertToCookiesDtoList(cookies));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectId, 'UPDATE')")
    @PostMapping(value={"/import"})
    public ResponseEntity<List<CookiesDto>> importCookieFromRam(@PathVariable(name="projectId") UUID projectId, @RequestBody ImportFromRamRequest importFromRamRequest) {
        List<Cookie> cookies = this.cookieService.importCookiesFromRam(projectId, importFromRamRequest);
        return ResponseEntity.ok(CookieUtils.convertToCookiesDtoList(cookies));
    }

    public CookieController(CookieService cookieService) {
        this.cookieService = cookieService;
    }
}

