/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.exceptions.history.ItfLiteRevisionHistoryIncorrectTypeException;
import org.qubership.atp.itf.lite.backend.feign.dto.history.CompareEntityResponseDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.HistoryItemResponseDto;
import org.qubership.atp.itf.lite.backend.service.history.iface.RestoreHistoryService;
import org.qubership.atp.itf.lite.backend.service.history.iface.RetrieveHistoryService;
import org.qubership.atp.itf.lite.backend.service.history.impl.HistoryServiceFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoryChangeController {
    private final HistoryServiceFactory historyServiceFactory;
    private final ModelMapper modelMapper;

    @RequestMapping(method={RequestMethod.GET}, value={"/atp-itf-lite/api/v1/history/{projectId}/{itemType}/{id}"}, produces={"application/json"})
    @PreAuthorize(value="@entityAccess.checkAccess(#itemType, #projectId, 'READ')")
    public ResponseEntity<HistoryItemResponseDto> getAllHistory(@PathVariable UUID projectId, @PathVariable String itemType, @PathVariable UUID id, @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="limit", required=false, defaultValue="10") Integer limit) {
        Optional<RetrieveHistoryService> historyServiceOptional = this.historyServiceFactory.getRetrieveHistoryService(itemType, id);
        if (historyServiceOptional.isPresent()) {
            RetrieveHistoryService retrieveHistoryService = historyServiceOptional.get();
            HistoryItemResponseDto response = retrieveHistoryService.getAllHistory(id, offset, limit);
            return ResponseEntity.ok((Object)response);
        }
        throw new ItfLiteRevisionHistoryIncorrectTypeException(itemType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/atp-itf-lite/api/v1/entityversioning/{projectId}/{itemType}/{id}"}, produces={"application/json"})
    @PreAuthorize(value="@entityAccess.checkAccess(#itemType, #projectId, 'READ')")
    public ResponseEntity<List<CompareEntityResponseDto>> getEntitiesByVersion(@PathVariable UUID projectId, @PathVariable String itemType, @PathVariable UUID id, @RequestParam List<String> versions) {
        Optional<RetrieveHistoryService> historyServiceOptional = this.historyServiceFactory.getRetrieveHistoryService(itemType, id);
        if (historyServiceOptional.isPresent()) {
            return ResponseEntity.ok(historyServiceOptional.get().getEntitiesByVersions(id, versions));
        }
        throw new ItfLiteRevisionHistoryIncorrectTypeException(itemType);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/atp-itf-lite/api/v1/history/restore/{projectId}/{itemType}/{id}/revision/{revisionId}"})
    @PreAuthorize(value="@entityAccess.checkAccess(#itemType,#projectId,'UPDATE')")
    public ResponseEntity<Void> restoreToRevision(@PathVariable UUID projectId, @PathVariable String itemType, @PathVariable UUID id, @PathVariable Integer revisionId) {
        Optional<RestoreHistoryService> historyServiceOptional = this.historyServiceFactory.getRestoreHistoryService(itemType, id);
        if (historyServiceOptional.isPresent()) {
            historyServiceOptional.get().restoreToRevision(id, revisionId.intValue());
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        throw new ItfLiteRevisionHistoryIncorrectTypeException(itemType);
    }

    public HistoryChangeController(HistoryServiceFactory historyServiceFactory, ModelMapper modelMapper) {
        this.historyServiceFactory = historyServiceFactory;
        this.modelMapper = modelMapper;
    }
}

