/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistoryRequestDetailsResponse;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistorySearchRequest;
import org.qubership.atp.itf.lite.backend.model.entities.history.PaginatedResponse;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecution;
import org.qubership.atp.itf.lite.backend.service.RequestExecutionHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/history"})
public class HistoryController {
    private static final Logger log = LoggerFactory.getLogger(HistoryController.class);
    private final RequestExecutionHistoryService requestExecutionHistoryService;

    @AuditAction(auditAction="Get execution history in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(#request.getProjectId(),'READ')")
    @PostMapping
    public ResponseEntity<PaginatedResponse<RequestExecution>> getExecutionsHistory(@RequestBody HistorySearchRequest request) {
        return ResponseEntity.ok(this.requestExecutionHistoryService.getExecutionHistory(request));
    }

    @AuditAction(auditAction="Get execution history details for the item '{{#historyItemId}}' in the '{{#projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<HistoryRequestDetailsResponse> getExecutionHistoryDetails(@PathVariable(value="id") UUID historyItemId, @RequestParam TransportType type, @RequestParam UUID projectId) {
        return ResponseEntity.ok((Object)this.requestExecutionHistoryService.getExecutionHistoryDetailsByHistoryItemId(historyItemId));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    @GetMapping(value={"/file/{id}"})
    public void getBinaryFileHistory(@PathVariable(value="id") UUID fileId, @RequestHeader(value="X-Project-Id") UUID projectId, HttpServletResponse response) throws IOException {
        this.requestExecutionHistoryService.getBinaryFileHistory(fileId, response);
    }

    @AuditAction(auditAction="Get all executors in the execution history for the '{{#projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    @GetMapping(value={"/executors"})
    public ResponseEntity<List<String>> getExecutorsInRequestExecutionHistory(@RequestParam UUID projectId) {
        return ResponseEntity.ok(this.requestExecutionHistoryService.getExecutorsInRequestExecutionHistory(projectId));
    }

    public HistoryController(RequestExecutionHistoryService requestExecutionHistoryService) {
        this.requestExecutionHistoryService = requestExecutionHistoryService;
    }
}

