/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.exceptions.file.ItfLiteSaveResponseAsFileException;
import org.qubership.atp.itf.lite.backend.feign.service.RamService;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.model.api.request.ContextVariable;
import org.qubership.atp.itf.lite.backend.model.api.request.CurlStringImportRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.ExecutionCollectionRequestExecuteRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.ImportContextRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitiesBulkDelete;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitiesCopyRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitiesMoveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntityCopyRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntityCreateRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntityEditRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntityMoveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestOrderChangeRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.Settings;
import org.qubership.atp.itf.lite.backend.model.api.response.ContextResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.ImportContextResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExportResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.collections.ExecuteStepResponse;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.qubership.atp.itf.lite.backend.service.ActionService;
import org.qubership.atp.itf.lite.backend.service.ConcurrentModificationService;
import org.qubership.atp.itf.lite.backend.service.FormDataPartService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.RequestSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/requests"})
public class RequestController {
    private static final Logger log = LoggerFactory.getLogger(RequestController.class);
    private final RequestService requestService;
    private final RamService ramService;
    private final ActionService actionService;
    private final FormDataPartService formDataPartService;
    private final ConcurrentModificationService concurrentModificationService;
    private final RequestSnapshotService requestSnapshotService;

    @AuditAction(auditAction="Get all requests. Filters: project id = {{#projectId}}, folder id = {{#folderId}}")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId,'READ')")
    @GetMapping
    public ResponseEntity<Collection<Request>> getAllRequests(@org.springframework.web.bind.annotation.RequestParam UUID projectId, @org.springframework.web.bind.annotation.RequestParam(required=false) UUID folderId) {
        return ResponseEntity.ok(this.requestService.getAllRequests(projectId, folderId));
    }

    @AuditAction(auditAction="Create request with name '{{#request.name}}', transport type '{{#request.transportType}}' in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#request.getProjectId(), 'CREATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),#request.getFolderId() != null ? @folderService.getFolder(#request.getFolderId()).getPermissionFolderId() : null,'UPDATE')")
    @PostMapping
    public ResponseEntity<Request> createRequest(@RequestBody @Valid RequestEntityCreateRequest request) {
        return new ResponseEntity((Object)this.requestService.createRequest(request), HttpStatus.CREATED);
    }

    @AuditAction(auditAction="Get request by id '{{#requestId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId != null ? #projectId : @requestService.getRequest(#requestId).getProjectId(),'READ')")
    @GetMapping(value={"/{itfLiteRequestId}"})
    public ResponseEntity<Request> getRequest(@org.springframework.web.bind.annotation.RequestParam(required=false) UUID projectId, @PathVariable(value="itfLiteRequestId") UUID requestId) {
        Request request = this.requestService.getRequest(requestId, projectId);
        if (request instanceof HttpRequest) {
            List<RequestParam> requestParams;
            HttpRequest httpRequest = (HttpRequest)request;
            RequestHeader authHeader = this.requestService.generateAuthorizationHeader(request.getAuthorization());
            if (Objects.nonNull(authHeader)) {
                httpRequest.getRequestHeaders().add(0, authHeader);
            }
            if (!CollectionUtils.isEmpty(requestParams = this.requestService.generateAuthorizationParams(request.getAuthorization()))) {
                httpRequest.getRequestParams().addAll(0, requestParams);
            }
        }
        return ResponseEntity.ok((Object)request);
    }

    @AuditAction(auditAction="Get request setting by id '{{#requestId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(),'READ')")
    @GetMapping(value={"/{itfLiteRequestId}/settings"})
    public ResponseEntity<Settings> getRequestSetting(@PathVariable(value="itfLiteRequestId") UUID requestId) {
        return ResponseEntity.ok((Object)this.requestService.getSettings(requestId));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(),'READ')")
    @GetMapping(value={"/{itfLiteRequestId}/binary"})
    public void getRequestBinaryFile(@PathVariable(value="itfLiteRequestId") UUID requestId, HttpServletResponse response) throws IOException {
        this.requestService.getRequestBinaryFile(requestId, response);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(), 'CREATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),@requestService.getRequest(#requestId).getProjectId(),@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PutMapping(value={"/{itfLiteRequestId}/binary/upload"})
    public void uploadBinaryFile(@PathVariable(value="itfLiteRequestId") UUID requestId, @RequestPart(name="file") MultipartFile file) {
        this.requestService.uploadBinaryFile(requestId, file);
    }

    @AuditAction(auditAction="Save request with id '{{#requestId}}' and name '{{#requestEntity.name}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#requestEntity.getProjectId(), 'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#requestEntity.getProjectId(),@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PutMapping(value={"/{itfLiteRequestId}"})
    public ResponseEntity<Request> saveRequest(@PathVariable(value="itfLiteRequestId") UUID requestId, @org.springframework.web.bind.annotation.RequestParam(required=false) UUID sessionId, @RequestPart(name="file", required=false) MultipartFile file, @RequestPart(name="files", required=false) List<MultipartFile> files, @RequestPart(name="requestEntity") @Valid RequestEntitySaveRequest requestEntity) throws IOException {
        HttpStatus status = this.concurrentModificationService.getConcurrentModificationHttpStatus(requestId, requestEntity.getModifiedWhen(), this.requestService);
        if (sessionId != null) {
            this.requestSnapshotService.preSaveRequestProcessing(sessionId, requestId);
        }
        Optional<FileBody> fileInfo = Optional.empty();
        if (file != null) {
            fileInfo = this.requestService.saveFileToFileSystemAndGridFs(requestId, file, requestEntity.getTransportType());
        }
        return new ResponseEntity((Object)this.requestService.saveRequest(requestId, requestEntity, files, fileInfo), status);
    }

    @AuditAction(auditAction="Update request with id '{{#requestId}}' and name '{{#requestEntity.name}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#request.getProjectId(), 'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PatchMapping(value={"/{itfLiteRequestId}"})
    public ResponseEntity<Request> editRequest(@PathVariable(value="itfLiteRequestId") UUID requestId, @RequestBody @Valid RequestEntityEditRequest request) {
        HttpStatus status = this.concurrentModificationService.getConcurrentModificationHttpStatus(requestId, request.getModifiedWhen(), this.requestService);
        return new ResponseEntity((Object)this.requestService.editRequest(requestId, request), status);
    }

    @AuditAction(auditAction="Copy request with id '{{#requestId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#request.getProjectId(), 'CREATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),#request.getFolderId() != null ? @folderService.getFolder(#request.getFolderId()).getPermissionFolderId() : null,'UPDATE')")
    @PostMapping(value={"/{itfLiteRequestId}/copy"})
    public ResponseEntity<Request> copyRequest(@PathVariable(value="itfLiteRequestId") UUID requestId, @RequestBody @Valid RequestEntityCopyRequest request) {
        return ResponseEntity.ok((Object)this.requestService.copyRequest(requestId, request));
    }

    @AuditAction(auditAction="Copy requests with ids [{{#request.requestIds}}]")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#request.getProjectId(), 'CREATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),#request.getFolderId() != null ? @folderService.getFolder(#request.getFolderId()).getPermissionFolderId() : null,'UPDATE')")
    @PostMapping(value={"/copy"})
    public ResponseEntity<Void> copyRequests(@RequestBody @Valid RequestEntitiesCopyRequest request) {
        this.requestService.copyRequests(request);
        return ResponseEntity.ok().build();
    }

    @AuditAction(auditAction="Move request with id '{{#requestId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#request.getProjectId(), 'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),#request.getFolderId() != null ? @folderService.getFolder(#request.getFolderId()).getPermissionFolderId() : null,'UPDATE')")
    @PostMapping(value={"/{itfLiteRequestId}/move"})
    public ResponseEntity<Request> moveRequest(@PathVariable(value="itfLiteRequestId") UUID requestId, @RequestBody @Valid RequestEntityMoveRequest request) {
        return ResponseEntity.ok((Object)this.requestService.moveRequest(requestId, request));
    }

    @AuditAction(auditAction="Move requests with ids [{#request.requestIds}}] to folder '{{#request.folderId}}' in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#request.getProjectId(), 'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@requestService.getPermissionFolderIdsByIdsWithModifiedWhen(#request.getRequestIds()),'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),#request.getFolderId() != null ? @folderService.getFolder(#request.getFolderId()).getPermissionFolderId() : null,'UPDATE')")
    @PostMapping(value={"/move"})
    public ResponseEntity<List<UUID>> moveRequests(@RequestBody @Valid RequestEntitiesMoveRequest request) {
        Pair<HttpStatus, List<UUID>> concurrentModificationRes = this.concurrentModificationService.getConcurrentModificationHttpStatus(request.getRequestIds(), this.requestService);
        this.requestService.moveRequests(request);
        return ResponseEntity.status((HttpStatus)((HttpStatus)concurrentModificationRes.getFirst())).body((Object)((List)concurrentModificationRes.getSecond()));
    }

    @AuditAction(auditAction="Delete request with id '{{#requestId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(), 'DELETE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),@requestService.getRequest(#requestId).getProjectId(),@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @DeleteMapping(value={"/{itfLiteRequestId}"})
    public ResponseEntity<Void> deleteRequest(@PathVariable(value="itfLiteRequestId") UUID requestId) {
        this.requestService.deleteRequest(requestId);
        return ResponseEntity.ok().build();
    }

    @AuditAction(auditAction="Delete requests with ids [{{#request.requestIds}}] in the project '{{#request.projectId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#request.getProjectId(), 'DELETE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@requestService.getPermissionFolderIdsByRequestIds(#request.getRequestIds()),'UPDATE')")
    @DeleteMapping
    public ResponseEntity<Void> deleteRequests(@RequestBody @Valid RequestEntitiesBulkDelete request) {
        this.requestService.bulkDeleteRequests(request);
        return ResponseEntity.ok().build();
    }

    @AuditAction(auditAction="Export request with id '{{#requestId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(),'READ')")
    @GetMapping(value={"/{itfLiteRequestId}/export"})
    @Deprecated
    public ResponseEntity<RequestExportResponse> exportRequest(@PathVariable(value="itfLiteRequestId") UUID requestId, @org.springframework.web.bind.annotation.RequestParam(required=false) UUID environmentId, @org.springframework.web.bind.annotation.RequestParam(required=false) String context) throws URISyntaxException {
        String curlRequest = this.requestService.exportRequest(requestId, environmentId, context, null);
        return ResponseEntity.ok((Object)new RequestExportResponse(curlRequest));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(),'READ')")
    @PostMapping(value={"/{itfLiteRequestId}/export"})
    public ResponseEntity<RequestExportResponse> exportRequest(@PathVariable(value="itfLiteRequestId") UUID requestId, @org.springframework.web.bind.annotation.RequestParam(required=false) UUID environmentId, @org.springframework.web.bind.annotation.RequestParam(required=false) String context, @RequestBody(required=false) List<ContextVariable> contextVariables) throws URISyntaxException {
        String curlRequest = this.requestService.exportRequest(requestId, environmentId, context, contextVariables);
        return ResponseEntity.ok((Object)new RequestExportResponse(curlRequest));
    }

    @AuditAction(auditAction="Import request with id '{{#importRequest.requestId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#importRequest.getRequestId()).getProjectId(), 'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),@requestService.getRequest(#importRequest.getRequestId()).getProjectId(),@requestService.getRequest(#importRequest.getRequestId()).getPermissionFolderId(),'UPDATE')")
    @PostMapping(value={"/import"})
    public ResponseEntity<Request> importRequest(@RequestBody @Valid CurlStringImportRequest importRequest) {
        MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)importRequest.getRequestId());
        Request importedRequest = this.requestService.importRequest(importRequest);
        return ResponseEntity.ok((Object)importedRequest);
    }

    @AuditAction(auditAction="Get context by url '{{#context}}' in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId,'READ')")
    @GetMapping(value={"/context"})
    public ResponseEntity<ContextResponse> getContext(@org.springframework.web.bind.annotation.RequestParam UUID projectId, @org.springframework.web.bind.annotation.RequestParam String context) throws URISyntaxException {
        String response = this.requestService.getContext(projectId, context);
        return ResponseEntity.ok((Object)new ContextResponse(response));
    }

    @AuditAction(auditAction="Change order for the request '{{#requestId}}' in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#request.getProjectId(), 'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PostMapping(value={"/{itfLiteRequestId}/order"})
    public ResponseEntity<Void> order(@PathVariable(value="itfLiteRequestId") UUID requestId, @RequestBody RequestOrderChangeRequest request) {
        this.requestService.order(requestId, request);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#requestExecuteRequest.getProjectId(),'EXECUTE')")
    @PostMapping(value={"/execute"})
    public ResponseEntity<ExecuteStepResponse> execute(@org.springframework.web.bind.annotation.RequestParam(required=false) UUID environmentId, @RequestBody ExecutionCollectionRequestExecuteRequest requestExecuteRequest) throws JsonProcessingException {
        return ResponseEntity.ok((Object)this.actionService.executeAction(requestExecuteRequest, environmentId));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(), 'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),@requestService.getRequest(#requestId).getProjectId(),@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PutMapping(value={"/{itfLiteRequestId}/formdata/{formDataPartId}/file/upload"})
    public ResponseEntity<Void> uploadFormDataFile(@PathVariable(value="itfLiteRequestId") UUID requestId, @PathVariable UUID formDataPartId, @RequestPart(name="file") MultipartFile file) {
        this.formDataPartService.uploadFile(requestId, formDataPartId, file);
        return ResponseEntity.ok().build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(),'READ')")
    @GetMapping(value={"/{itfLiteRequestId}/file/{fileId}/download"})
    public void downloadFile(@PathVariable(value="itfLiteRequestId") UUID requestId, @PathVariable(value="fileId") UUID fileId, HttpServletResponse response) throws IOException {
        this.requestService.getFile(requestId, fileId, response);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#importContextRequest.getProjectId(),'READ')")
    @PostMapping(value={"/import/contextVariables"})
    public ResponseEntity<ImportContextResponse> importContextFromRam(@RequestBody ImportContextRequest importContextRequest) {
        return ResponseEntity.ok((Object)this.ramService.importContextVariables(importContextRequest));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(),'READ')")
    @GetMapping(value={"/{itfLiteRequestId}/downloadResponse"})
    public void downloadResponseAsFile(@PathVariable(value="itfLiteRequestId") UUID requestId, @org.springframework.web.bind.annotation.RequestParam UUID executionId, HttpServletResponse response) {
        try {
            this.requestService.writeResponseAsFile(requestId, executionId, response);
        }
        catch (Exception e) {
            log.error("Can't download response as file.", (Throwable)e);
            throw new ItfLiteSaveResponseAsFileException();
        }
    }

    public RequestController(RequestService requestService, RamService ramService, ActionService actionService, FormDataPartService formDataPartService, ConcurrentModificationService concurrentModificationService, RequestSnapshotService requestSnapshotService) {
        this.requestService = requestService;
        this.ramService = ramService;
        this.actionService = actionService;
        this.formDataPartService = formDataPartService;
        this.concurrentModificationService = concurrentModificationService;
        this.requestSnapshotService = requestSnapshotService;
    }
}

