/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.service.RequestParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/request-params"})
public class RequestParamsController {
    private static final Logger log = LoggerFactory.getLogger(RequestParamsController.class);
    private final RequestParamService service;

    @AuditAction(auditAction="Disable request '{{#requestId}}' param '{{#paramId}}' in the '{{#projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId,@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PutMapping(value={"/{id}/disable"})
    public void disableRequestParam(@RequestParam UUID projectId, @RequestParam UUID requestId, @PathVariable(value="id") UUID paramId) {
        MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)requestId);
        log.info("Request to disable param with id '{}' for request with id '{}'", (Object)paramId, (Object)requestId);
        this.service.disableRequestParam(paramId);
    }

    @AuditAction(auditAction="Enable request '{{#requestId}}' param '{{#paramId}}' in the '{{#projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId,@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PutMapping(value={"/{id}/enable"})
    public void enableRequestParam(@RequestParam UUID projectId, @RequestParam UUID requestId, @PathVariable(value="id") UUID paramId) {
        MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)requestId);
        log.info("Request to enable param with id '{}' for request with id '{}'", (Object)paramId, (Object)requestId);
        this.service.enableRequestParam(paramId);
    }

    public RequestParamsController(RequestParamService service) {
        this.service = service;
    }
}

